"use strict";
SHINKEN.TOOLS.TEST_AUTO_UI_VISU_REPORT = (function ( self ) {
    self.DOM                          = {};
    self.TEST                         = {};
    self.ACTION                       = {};
    self.CONST                        = {
        PROPERTY: {
            NAME: {
                FILTER                        : "filter",
                DATE_BEGIN                    : "dateBegin",
                DATE_END                      : "dateEnd",
                WARNING_THRESHOLD             : "warning_threshold",
                CRITICAL_THRESHOLD            : "critical_threshold",
                DISPLAY_REPORT_THRESHOLD      : "display_report_threshold",
                DISPLAY_ELEMENT_THRESHOLD     : "display_element_threshold",
                SHINKEN_ADD_DAILY_DETAILS     : "shinken_add_daily_details",
                SHINKEN_DISPLAY_TOTAL_SLA     : "shinken_display_total_sla",
                SHINKEN_DISPLAY_TOTAL_HISTORIC: "shinken_display_total_historic",
                SHINKEN_DAILY_SLA_GRAPH       : "shinken_daily_sla_graph",
                SHINKEN_GRAPH_SCALE           : "shinken_graph_scale",
                SHINKEN_GRAPH_YMAX            : "shinken_graph_ymax",
                SHINKEN_GRAPH_YMAX_VALUE      : "shinken_graph_ymax_value",
                SHINKEN_GRAPH_YMIN            : "shinken_graph_ymin",
                SHINKEN_GRAPH_YMIN_VALUE      : "shinken_graph_ymin_value"
            }
        }
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getIframe                = function () {
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).window.onerror = function () {
            _has_script_error++;
        };
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document;
    };
    self.DOM.input                    = function ( property_name ) {
        return self.DOM.getIframe().querySelector( "input[name='" + property_name + "']" );
    };
    self.DOM.selector                 = function ( property_name ) {
        return self.DOM.getIframe().querySelector( "select[name='" + property_name + "']" );
    };
    self.DOM.optionSelect             = function ( property_name, option_name ) {
        var _select_dom = self.DOM.selector( property_name );
        return _select_dom.querySelector( "option[value='" + option_name + "']" );
    };
    self.DOM.getSubmitButton          = function () {
        return self.DOM.getIframe().getElementById( "not-in-form-id-shinken-form-submit-web" );
    };
    self.DOM.getModifySelectionButton = function () {
        return self.DOM.getIframe().getElementById( "id-shinken-modify-selection-report" );
    };
    self.DOM.getNewSelectionButton    = function () {
        return self.DOM.getIframe().getElementById( "id-shinken-new-selection-report" );
    };
    //********************************************  GETTER   **************************************************//
    //********************************************  TEST   **************************************************//
    self.TEST.inputValue               = function ( timeout, property_name, value_expected ) {
        var _to_return = 100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.inputValue', property_name, value_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.input( property_name );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _dom.value, value_expected, 'inputValue' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.setValue               = function ( timeout, property_name, to_set ) {
        var _to_return = 400;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnAutoRefresh', "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            switch ( property_name ) {
                case self.CONST.PROPERTY.NAME.FILTER:
                case self.CONST.PROPERTY.NAME.DATE_BEGIN:
                case self.CONST.PROPERTY.NAME.DATE_END:
                case self.CONST.PROPERTY.NAME.WARNING_THRESHOLD:
                case self.CONST.PROPERTY.NAME.CRITICAL_THRESHOLD:
                case self.CONST.PROPERTY.NAME.SHINKEN_GRAPH_YMAX_VALUE:
                case self.CONST.PROPERTY.NAME.SHINKEN_GRAPH_YMIN_VALUE:
                    var _dom_input = self.DOM.input( property_name );
                    DOM.Service.setInputValue( _dom_input, to_set );
                    break;
                case self.CONST.PROPERTY.NAME.DISPLAY_REPORT_THRESHOLD:
                case self.CONST.PROPERTY.NAME.DISPLAY_ELEMENT_THRESHOLD:
                case self.CONST.PROPERTY.NAME.SHINKEN_ADD_DAILY_DETAILS:
                case self.CONST.PROPERTY.NAME.SHINKEN_DISPLAY_TOTAL_SLA:
                case self.CONST.PROPERTY.NAME.SHINKEN_DAILY_SLA_GRAPH:
                case self.CONST.PROPERTY.NAME.SHINKEN_DISPLAY_TOTAL_HISTORIC:
                    var _dom_checkbox = self.DOM.input( property_name );
                    DOM.Service.setCheckBoxValue( _dom_checkbox, to_set );
                    break;
                case self.CONST.PROPERTY.NAME.SHINKEN_GRAPH_SCALE:
                case self.CONST.PROPERTY.NAME.SHINKEN_GRAPH_YMAX:
                case self.CONST.PROPERTY.NAME.SHINKEN_GRAPH_YMIN:
                    var _dom_select   = self.DOM.selector( property_name );
                    _dom_select.value = to_set;
                    SHINKEN.TOOLS.TEST_AUTO.___dispatchOnChangeEvent( _dom_select );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.clickOnSubmitForm      = function ( timeout ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnSubmitForm', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getSubmitButton() );
            }
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnModifySelection = function ( timeout ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnModifiySelection', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getModifySelectionButton() );
            }
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnNewSelection    = function ( timeout ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnModifiySelection', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getNewSelectionButton() );
            }
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_REPORT || {} );

