//__lib__ lib_common
"use strict";

COMPONENT.InterfaceSingleSelect           = function () {
};
COMPONENT.InterfaceSingleSelect.prototype = {
    init     : function () {
        this.last_selected_key_name   = "";
        this.default_label_for_select = '--';
        this.uuid                     = SHINKEN.TOOLS.STRING.buildUUID();
    },
    hidePopup: function () {
        DOM.Service.setDataSet( this.getDomElement(), COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
        this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnSelector    : function () {
        DOM.Service.setDataSet( this.getDomElement(), COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, this.list_element.toggleState() );
    },
    clickOnItemSelector: function ( key_name, parent ) {
        this.resetStatus();
        this.setLastSelectedElementName( key_name );
        this.hidePopup();
        if ( parent ) {
            parent.doActionAfter( "click_on_item_selector_done", this );
        }
    },
    doActionAfter      : function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_selector":
                this.clickOnSelector();
                break;
            case "click_on_item_selector":
                this.clickOnItemSelector( param_1, param_2 );
                break;
        }
    },
    //********************************************  GETTER AND SETTER  **************************************************//
    getLastSelectedElement    : function () {
        return this.list_element.getContentByUUID( this.last_selected_key_name );
    },
    setTitle                  : function ( _to_set ) {
        if ( !this.is_editable ) {
            return;
        }
        this.title = _to_set;
        if ( !this.dom_select ) {
            return;
        }
        var _dom_text       = this.dom_select.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_TEXT );
        _dom_text.innerHTML = this.title;
    },
    getValue                  : function () {
        return this.getLastSelectedElementName();
    },
    getLabel                  : function () {
        return this.getLastSelectedElement().getLabel();
    },
    computeTitle              : function () {
        this.setTitle( this.last_selected_key_name !== "" ? this.getLabel() : this.default_label_for_select );
    },
    getLastSelectedElementName: function () {
        return this.last_selected_key_name;
    },
    setLastSelectedElementName: function ( to_set ) {
        this.previous_selected_key_name = this.last_selected_key_name;
        this.last_selected_key_name     = to_set;
        this.computeTitle();
    },
    setStatus                 : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.getDomElement(), 'status', to_set );
    },
    resetStatus               : function () {
        this.setStatus( "" );
    },
    getListElement            : function () {
        return this.list_element;
    },
    setDefaultLabelForSelector: function ( to_set ) {
        this.default_label_for_select = to_set;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceSingleSelect, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceSingleSelect, SHINKEN.OBJECT.ShinkenObjectHtml );

COMPONENT.SingleSelectFromData           = function ( property_name, selector_name ) {
    this.__class_name__ = 'COMPONENT.SingleSelectFromData';
    this.is_editable    = true;
    this.property_name  = property_name;
    this.selector_name  = selector_name || COMPONENT.CONST.SELECT.NAME_MAIN_SELECTOR;
    this.initSpecific();
};
COMPONENT.SingleSelectFromData.prototype = {
    initSpecific: function () {
        this.init();
        this.list_element = new COMPONENT.ListSelectFromData_V2( this.property_name, this.selector_name );
        this._onclick     = "MANAGER.EventManagerV2.clickSelector(event,'" + this.property_name + "')";
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setOptionsFromArray: function ( to_set ) {
        if ( to_set ) {
            for ( var i = 0, _size_i = to_set.length; i < _size_i; i++ ) {
                this.addOption( to_set[ i ] );
            }
        }
    },
    addOption          : function ( to_add ) {
        this.list_element.addFromString( to_add.name, to_add.label );
        if ( to_add.is_selected ) {
            this.setLastSelectedElementName( to_add.name );
        }
    },
    setClickEventName  : function ( to_set ) {
        this.specific_event_name = to_set;
        this._onclick            = "MANAGER.EventManagerV2.clickSelector(event,'" + this.property_name + "','" + this.specific_event_name + "')";
    },
    setParentName      : function ( to_set ) {
        this.property_name = to_set;
        
    },
    //********************************************  OTHER  *****************************************************//
    changeOptionsFromArray: function ( new_options_data ) {
        this.resetOptions();
        this.setOptionsFromArray( new_options_data );
        this.list_element.computeHtml();
        this.addDomElement( this.list_element.getDomElement() );
    },
    resetOptions          : function () {
        this.list_element.reset();
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.list_element.computeHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-select-container", "data-state-selector": 0 } ) );
        
        this.dom_select = DOM.Service.createElement( "div",
            {
                class  : "shinken-select-selector shinken-user-select-none",
                onclick: this._onclick
            }, '<span class="shinken-selector-label shinken-space">' + this.default_label_for_select + '</span><span class="shinkon header-chevron shinken-2023-arrow-down"></span>' );
        this.computeTitle();
        this.addDomElement( this.dom_select );
        this.addDomElement( this.list_element.getDomElement() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.SingleSelectFromData, COMPONENT.InterfaceSingleSelect );

COMPONENT.SingleSelectFromDataV2           = function ( property_name, selector_name ) {
    this.__class_name__ = 'COMPONENT.SingleSelectFromData';
    this.is_editable    = true;
    this.property_name  = property_name;
    this.selector_name  = selector_name || COMPONENT.CONST.SELECT.NAME_MAIN_SELECTOR;
    this.initSpecific();
};
COMPONENT.SingleSelectFromDataV2.prototype = {
    initSpecific     : function () {
        this.init();
        this.list_element = new COMPONENT.ListSelectFromData_V3_deprecated( this.property_name, this.selector_name );
        this._onclick     = "MANAGER.EventManagerV2.clickSelectorV2(event,'" + this.property_name + "')";
    },
    setClickEventName: function ( to_set ) {
        this.specific_event_name = to_set;
        this._onclick            = "MANAGER.EventManagerV2.clickSelectorV2(event,'" + this.property_name + "','" + this.specific_event_name + "')";
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "click_on_selector":
                DOM.Service.setDataSet( this.getDomElement(), COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, this.list_element.toggleState() );
                break;
            case "click_on_item_selector":
                this.resetStatus();
                this.setLastSelectedElementName( param[ PROPERTY.SELECT.PARAM.OPTION_NAME ] );
                this.hidePopup();
                param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ].doActionAfter( "click_on_item_selector_done", this );
                break;
            default:
                console.error( "[SingleSelectFromDataV2 - doActionAfter]", event_name );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.SingleSelectFromDataV2, COMPONENT.SingleSelectFromData );

COMPONENT.SingleSelectFromData_V3           = function ( property_name, selector_name ) {
    this.__class_name__ = 'COMPONENT.SingleSelectFromData';
    this.initSpecific( property_name, selector_name );
};
COMPONENT.SingleSelectFromData_V3.prototype = {
    initSpecific: function ( property_name, selector_name ) {
        this.init();
        this.is_editable   = true;
        this.property_name = property_name;
        this.selector_name = selector_name || COMPONENT.CONST.SELECT.NAME_MAIN_SELECTOR;
        this.list_element  = new COMPONENT.ListSelectFromData_V3( this.property_name, this.selector_name );
        this.addParamForEvents( PROPERTY.COMMON.PARAM.PROPERTY_NAME, property_name );
        this.addParamForEvents( PROPERTY.SELECT.PARAM.SELECTOR_NAME, this.selector_name );
        this.class = "shinken-select-container";
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter      : function ( event_name, param ) {
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon: function ( event_name, param ) {
        switch ( event_name ) {
            case "add_message_validation":
                this.setMessage__2024_12_16( param[ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ] );
                return;
            case "set_default_value_in_selector":
                this.setLastSelectedElementName( param[ PROPERTY.COMMON.PARAM.DEFAULT_VALUE ] );
                break;
            case "property_value__set__by_js":
            case "property_value__set__by_data":
                this.setLastSelectedElementName( param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] );
                return;
            case "change_selector_default_title":
                this.setDefaultLabelForSelector( param[ COMPONENT.CONST.PARAM.TEXT_DEFAULT_SELECTOR ] );
                break;
            case "click_on_selector_V3":
                SHINKEN_TOOLTIP.hideTooltip();
                DOM.Service.setDataSet( this.getDomElement(), COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, this.list_element.toggleState() );
                this.computeListPlacement( param );
                break;
            case "click_on_item_selector_V3":
                this.resetStatus();
                this.setLastSelectedElementName( param[ PROPERTY.SELECT.PARAM.OPTION_NAME ] );
                this.hidePopup();
                param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ].doActionAfter( "click_on_item_selector_done", this );
                break;
            case "ask_hide_pop_up":
            case "click_done":
                this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
                DOM.Service.setDataSet( this.getDomElement(), COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
                break;
            default:
                break;
        }
    },
    addParamForEvents  : function ( key, value ) {
        this.addParamForEventsCommon( key, value );
        if ( this.list_element ) {
            this.list_element.addParamForEvents( key, value );
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setMessage__2024_12_16    : function ( to_set ) {
        let _status              = COMPONENT.CONST.STATUS.NONE;
        this.message__2024_12_16 = to_set;
        if ( this.message__2024_12_16 ) {
            _status = this.message__2024_12_16.getStatus();
            this.setStatus( _status );
            switch ( _status ) {
                case COMPONENT.CONST.STATUS.ERROR:
                    this.setTooltipHtml( this.message__2024_12_16.buildMessageGeneric(), SHINKEN_TOOLTIP.TYPE.ERROR_BORDER );
                    break;
                case COMPONENT.CONST.STATUS.WARNING:
                    this.setTooltipHtml( this.message__2024_12_16.buildMessageGeneric(), SHINKEN_TOOLTIP.TYPE.WARNING_BORDER );
                    break;
                case COMPONENT.CONST.STATUS.NONE:
                    this.setTooltipHtml( this.message__2024_12_16 ? this.message__2024_12_16.buildMessageGeneric() : "", "" );
                    break;
            }
        }
    },
    getMessage__2024_12_16    : function () {
        return this.message__2024_12_16;
    },
    getDomElementForTooltip   : function () {
        return this.dom_select;
    },
    getLabel                  : function () {
        let to_return = this.getLastSelectedElement();
        if ( to_return ) {
            return to_return.getLabel();
        }
        return this.last_selected_key_name;
    },
    setLastSelectedElementName: function ( to_set ) {
        let last_element = this.getLastSelectedElement();
        if ( last_element && last_element.getDomElement() ) {
            last_element.getDomElement().classList.remove( "shinken-option-selected" );
        }
        this.previous_selected_key_name = this.last_selected_key_name;
        this.last_selected_key_name     = to_set;
        this.computeTitle();
        last_element = this.getLastSelectedElement();
        if ( last_element ) {
            last_element.addClass( "shinken-option-selected" );
        }
    },
    // ******************************************* LAST MODIFICATIONS ************************************************
    doActionAfterLastModification: function ( event_name, param ) {
        this.doActionAfter( "property_value__set__by_js", param );
        this.setMessage__2024_12_16( param[ "message" ] );
    },
    getDataForLastModification   : function ( params ) {
        return {
            [ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ]: this.getLastSelectedElementName(),
            "message"                               : this.getMessage__2024_12_16()
        };
    },
    //********************************************  HTML  *****************************************************//
    computeHtml         : function () {
        this.list_element.computeHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: this.getClass(), "data-state-selector": 0 } ) );
        this.dom_select = DOM.Service.createElement( "div", {
            class      : "shinken-select-selector-V3 shinken-select-selector shinken-user-select-none shinken-layout-center-h-v shinken-layout-justify-between",
            "data-name": this.selector_name,
            onclick    : "MANAGER.EventManagerV2.clickSelector_V3(event," + this.parseParamForEventsToHtml() + ")"
        }, '<span class="shinken-selector-label shinken-space">' + this.default_label_for_select + '</span><span class="shinkon shinken-header-chevron shinken-2023-arrow-down"></span>' );
        this.computeTitle();
        this.addDomElement( this.dom_select );
        this.addDomElement( this.list_element.getDomElement() );
    },
    computeListPlacement: function ( param ) {
        DOM.Service.removeClasses( this.list_element.getDomElement(), "shinken-display-on-top" );
        if ( this.list_element.getState() === COMPONENT.CONST.BTN_STATE.OFF ) {
            return;
        }
        DOM.Service.addOrRemoveClasses( this.list_element.getDomElement(), DOM.Service.isInScreenVertically( this.list_element.getDomElement() ),
            "shinken-display-on-top" );
        
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.SingleSelectFromData_V3, COMPONENT.SingleSelectFromData );

COMPONENT.SingleSelectWithResearchFromData_V3           = function ( property_name, selector_name, extra_columns ) {
    this.__class_name__ = 'COMPONENT.SingleSelectFromData';
    this.initSpecific( property_name, selector_name, extra_columns );
};
COMPONENT.SingleSelectWithResearchFromData_V3.prototype = {
    initSpecific: function ( property_name, selector_name, extra_columns ) {
        this.extra_columns = this.parseExtraColumn( extra_columns );
        this.init();
        this.is_editable   = true;
        this.property_name = property_name;
        this.selector_name = selector_name || COMPONENT.CONST.SELECT.NAME_MAIN_SELECTOR;
        this.addParamForEvents( PROPERTY.COMMON.PARAM.PROPERTY_NAME, property_name );
        this.addParamForEvents( PROPERTY.SELECT.PARAM.SELECTOR_NAME, this.selector_name );
        
        this.list_element = new SHINKEN_LIST.SetForPropertyResearch( "list_for_research" );
        this.list_element.addParamsForEvents( this.getParamForEvents() );
        this.list_element.setHeaders( new SHINKEN_LIST.HeadersFromData( SHINKEN.TOOLS.ARRAY.concat( [{ name: this.property_name }], this.extra_columns ) ) );
        this.list_element.setFilters( new SHINKEN_LIST.FiltersFromData_V3( this.list_element.headers.getContents(), this.list_element.getParamForEvents() ) );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "add_message_validation":
                this.setMessage__2024_12_16( param[ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ] );
                return;
            case "reset_display":
                this.list_element.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                DOM.Service.setDataSet( this.getDomElement(), COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
                return;
            case "property_value__set__by_js":
                this.setLastSelectedElementName( this.list_element.getLineByCellValue( this.property_name, param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] ) );
                return;
            case "property_value__set__by_data":
                this.setTitle( param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] );
                return;
            case "property_value__reset":
                this.setLastSelectedElementName( null );
                return;
            case "click_on_selector_V3":
                SHINKEN_TOOLTIP.hideTooltip();
                if ( param[ SHINKEN_LIST.CONST.PARAM.SET_UUID ] ) {
                    this.list_element.doActionAfter( event_name, param );
                    return;
                }
                this.list_element.togglePhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN, SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                DOM.Service.setDataSet( this.getDomElement(), COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, this.list_element.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ? COMPONENT.CONST.BTN_STATE.ON : COMPONENT.CONST.BTN_STATE.OFF );
                return;
            case "click_on_item_selector_V3":
                if ( param[ SHINKEN_LIST.CONST.PARAM.SET_UUID ] ) {
                    this.list_element.doActionAfter( event_name, param );
                    return;
                }
                break;
            case "line_list_content__clicked":
                this.resetStatus();
                this.setLastSelectedElementName( this.list_element.getLineByUUID( param[ SHINKEN_LIST.CONST.PARAM.LINE_UUID ] ) );
                this.hidePopup();
                param[ PROPERTY.SELECT.PARAM.OPTION_OBJECT ] = this.selected_line__20241114;
                CONTROLLER.Form.doActionAfter( "click_on_item_selector_done", param );
                return;
            case "clean_filter":
            case "ask_apply_filter":
            case "click_on_button_V3":
            case "onclick_in_input_V3":
            case "onchange_in_input_V3":
            case "clean_selected_element":
                this.list_element.doActionAfter( event_name, param );
                return;
            case "click_done":
                this.list_element.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                DOM.Service.setDataSet( this.getDomElement(), COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
                return;
            case "ask_hide_pop_up": //WARNING THE HIDE POP UP close the selection when changing pagination
                return;
        }
        this.doActionAfterCommon( event_name, param );
    },
    hidePopup    : function () {
        this.list_element.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
        DOM.Service.setDataSet( this.getDomElement(), COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getValue                  : function () {
        if ( this.selected_line__20241114 ) {
            return this.selected_line__20241114.getContentByUUID( this.property_name ).getValue();
        }
        if ( this.title && this.title !== this.default_label_for_select ) {
            return this.title;
        }
        return "";
    },
    setLastSelectedElementName: function ( to_set ) {
        if ( this.selected_line__20241114 ) {
            this.selected_line__20241114.setIsSelected__20241219( false );
        }
        this.selected_line__20241114 = to_set;
        this.computeTitle();
        if ( this.selected_line__20241114 ) {
            this.selected_line__20241114.setIsSelected__20241219( true );
        }
    },
    //********************************************  COMPUTE  *****************************************************//
    computeTitle    : function () {
        let to_set = this.selected_line__20241114 ? this.selected_line__20241114.getContentByUUID( this.property_name ).getValue() : this.default_label_for_select;
        this.setTitle( to_set );
    },
    parseExtraColumn: function ( extra_columns ) {
        let to_return = [];
        for ( let i = 0, _size_i = extra_columns.length; i < _size_i; i++ ) {
            to_return.push( { "name": extra_columns[ i ] } );
        }
        return to_return;
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-select-container", "data-state-selector": 0 } ) );
        this.dom_select = DOM.Service.createElement( "div",
            {
                class      : "shinken-select-selector-V3 shinken-select-selector shinken-user-select-none shinken-layout-center-h-v shinken-layout-justify-between",
                "data-name": this.selector_name,
                onclick    : "MANAGER.EventManagerV2.clickSelector_V3(event," + this.parseParamForEventsToHtml() + ")"
            }, '<span class="shinken-selector-label shinken-space">' + (this.title || this.default_label_for_select) + '</span><span class="shinkon shinken-header-chevron shinken-2023-arrow-down"></span>' );
        this.addDomElement( this.dom_select );
        this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-spinner" } ) );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.SingleSelectWithResearchFromData_V3, COMPONENT.SingleSelectFromData_V3 );


