"use strict";

SHINKEN.OBJECT.CONST.DEBUG_PHASE = {
    0  : "RUNNING",
    1  : "REFRESHING",
    2  : "INIT",
    3  : "EDITING",
    4  : "SAVING",
    5  : "WAITING_FOR_START_IMPORT",
    6  : "WAITING_FOR_IMPORT",
    7  : "WAITING_FOR_MERGE",
    8  : "WAITING_FOR_UPDATE",
    9  : "READY",
    10 : "WAITING_FOR_READY",
    11 : "STOPPING",
    12 : "STARTING",
    13 : "STUCK",
    14 : "HIDDEN",
    15 : "ASKING_ENTER_PREVIEWING",
    16 : "PREVIEWING",
    17 : "ASKING_ENTER_EDITING",
    171: "ASKING_SHOW_FORM",
    18 : "ASK_FOR_REFRESH",
    19 : "RUNNING_OK",
    191: "RUNNING_OK_WITH_WARNING",
    20 : "RUNNING_NOK",
    21 : "SAVING_AFTER_PREVIEWING",
    22 : "TO_BE_DELETED",
    23 : "ASK_FOR_SAVING",
    24 : "ASK_FOR_CANCEL",
    25 : "CANCEL",
    26 : "SAVE_DONE",
    27 : "RUNNING_WITH_WARNING",
    28 : "ASK_FOR_CLOSE"
};

SHINKEN.OBJECT.DEBUG_PHASE = (function ( self ) {
    "use strict";
    self.logPhase                = function ( object, quadri ) {
        console.warn(quadri || "UNKNOWN QUADRI", "[NUMBER - debug]", object.getObjectClassName(), self.parseToLog(object.getCurrentPhase()) , self.parseToLog(object.phase.previous_phase) );
    };
    self.parseToLog                = function ( phase_number ) {
        return self.parseToString(phase_number) + "(" + phase_number + ")"
    };
    self.parseToString                = function ( phase ) {
        return SHINKEN.OBJECT.CONST.DEBUG_PHASE[phase];
    };
    return self;
})( SHINKEN.OBJECT.DEBUG_PHASE || {} );
