//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.LastModification           = function () {
    this.init();
};
SHINKEN.OBJECT.LastModification.prototype = {
    init: function () {
        this.initContents();
        this.setTimestamp();
        
    },
    //********************************************  SETTER GETTER   **************************************************//
    setTimestamp               : function ( to_set ) {
        this.timestamp = Date.now();
    },
    setExtraParam              : function ( to_set ) {
        this.extra_params = to_set;
    },
    getExtraParam              : function () {
        return this.extra_params;
    },
    setModificationType        : function ( to_set ) {
        this.type_modification = to_set;
    },
    getUUID                    : function () {
        return this.index;
    },
    setIndex                   : function ( index ) {
        this.index = index;
    },
    isValid                    : function () {
        return this.contents.length > 0;
    },
    getAllUuidOfImpactedElement: function () {
        return this.getContents().map( last_modification_element => last_modification_element.getParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ) );
    },
    //********************************************  ACTIONS  **************************************************//
    addSpecific: function ( last_modification_element ) {
        if ( !last_modification_element.isValid() ) {
            return;
        }
        return this.add( last_modification_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.LastModification, SHINKEN.OBJECT.ShinkenObjectContainer );