//__lib__ lib_common
"use strict";

SHINKEN_LIST.HeadersFromData           = function ( headers_array ) {
    this.init(headers_array);
    
};
SHINKEN_LIST.HeadersFromData.prototype = {
    init: function (headers_array) {
        this.initContents();
        for ( var i = 0, _size_i = headers_array.length; i < _size_i; i++ ) {
            this.add( this.getChildConstructor( headers_array[i].name, headers_array[i].label ) );
        }
    },
    getChildConstructor: function (name, label) {
        return new SHINKEN_LIST.HeaderFromData(name, label);
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.dom_element = DOM.Service.createElement( "tr", { class: "shinken-header-line" } );
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].computeHtml();
            DOM.Service.addElementTo( this.contents[ i ].getDomElement(), this.dom_element );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeadersFromData, SHINKEN_LIST.Headers );