//__lib__ lib_common
"use strict";

SHINKEN_LIST.SetFromDataWithPagination           = function ( name, pagination_size ) {
    this.initSpecific( name, pagination_size );
};
SHINKEN_LIST.SetFromDataWithPagination.prototype = {
    initSpecific    : function ( name, pagination_size ) {
        this.init( name );
        this.setPagination( new SHINKEN_LIST.Pagination_V3( pagination_size, this.getName() ) );
    },
    initLinesObjects: function () {
        return new SHINKEN_LIST.LinesFromDataWithPagination();
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter: function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_selector_V3":
            case "click_on_item_selector_V3":
                param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ] = this;
                this.pagination.doActionAfter( event_name, param, param_2, param_3 );
                break;
            case "click_on_button_V3":
            case "click_on_item_selector_done":
                this.pagination.doActionAfter( event_name, param, param_2, param_3 );
                this.computeLinesHtml();
                break;
        }
        this.doActionAfterCommon( event_name, param, param_2, param_3 );
        this.doActionAfterSpecific( event_name, param, param_2, param_3 );
    },
    applyFilter  : function ( params_filter_by_line ) {
        this.applyFilterCommon( params_filter_by_line );
        this.pagination.setTotalElement( this.lines.getSizeNotFiltered() );
        this.computeLinesHtml();
        this.setSelectAllStatus();
    },
    onClick      : function ( event ) {
        this.pagination.onClick( event );
        this._onClick( event );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setPagination    : function ( to_set ) {
        this.pagination = to_set;
        this.pagination.addParamsForEvents( this.getParamForEvents() );
    },
    getPagination    : function () {
        return this.pagination;
    },
    setPageSize      : function ( to_set ) {
        this.pagination.setPageSize( to_set );
    },
    addParamForEvents: function ( key, value ) {
        this.addParamForEventsCommon( key, value );
        if ( this.pagination ) {
            this.pagination.addParamForEvents( key, value );
        }
    },
    //********************************************  HTML  *****************************************************//
    computeSpecificHtml      : function () {
        this.pagination.setTotalElement( this.lines.getSize() );
        this.pagination.computeHtml();
        this.addDomElement( this.pagination.getDomElement() );
        this.computeSpecificHtml_lvl_1();
        this.getDomElement().classList.add( "shinken-list-has-pagination" );
    },
    computeSpecificHtml_lvl_1: function () {
    },
    computeLinesHtml         : function () {
        if ( this.lines ) {
            this.lines.computeHtml( this.pagination );
        }
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetFromDataWithPagination, SHINKEN_LIST.SetFromDataWithFixHeaderFilter );


SHINKEN_LIST.SetForPropertyResearch           = function ( name, pagination_size ) {
    this.initSpecific( name, pagination_size );
};
SHINKEN_LIST.SetForPropertyResearch.prototype = {
    initSpecific    : SHINKEN_LIST.SetFromDataWithPagination.prototype.initSpecific,
    initLinesObjects: function () {
        return new SHINKEN_LIST.LinesForPropertyResearch();
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetForPropertyResearch, SHINKEN_LIST.SetFromDataWithPagination );
