//__lib__ lib_common
//priority 100

"use strict";

SHINKEN_LIST.LineCell           = function () {
    this.init();
};
SHINKEN_LIST.LineCell.prototype = {
    init      : function () {
        this.initCommon();
    },
    initCommon: function () {
        this.initCounterCommon();
        this.setUUID( this.name );
    },
    initCounterCommon           : function () {
        this.counters = {};
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter      : function ( event_name, param_1, param_2, param_3 ) {
        this.doActionAfterCommon( event_name, param_1, param_2, param_3 );
    },
    doActionAfterCommon: function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "compute_html_done":
                this.addCountersTargetDomElement( this.getDomElement() );
                break;
        }
    },
    //********************************************  GETTER SETTER  **************************************************//
    getUUID               : function () {
        return this.name;
    },
    getForFilter          : function () {
        return this.value || SHINKEN_LIST.CONST.FILTER.EMPTY;
    },
    getValue              : function () {
        return this.value;
    },
    getValueForSum        : function () {
        return this.value || 0;
    },
    getDataToExport       : function () {
        let to_return;
        if ( this.getDomElement() ) {
            to_return = this.getDomElement().innerText.replaceAll( "\n", " " );
        } else {
            to_return = this.value || "";
        }
        to_return = to_return.replace(/<\/?(span|div)[^>]*>/g, '');
        return to_return;
    },
    getLabel              : function () {
        return this.label;
    },
    setUUID               : function ( to_set ) {
        this.uuid = to_set;
        this.addParamForEvents( SHINKEN_LIST.CONST.PARAM.CELL_UUID, this.uuid );
    },
    setValue              : function ( to_set ) {
        this.value = to_set;
        if ( this.getDomElement() ) {
            this.changeDomElementContent();
        }
    },
    getValueForApplyFilter: function () {
        return this.getValue();
    },
    setSortingValue       : function ( value ) {
        this.sorting_value = value;
    },
    getSortingValue       : function () {
        return this.sorting_value;
    },
    //********************************************  OTHER  *****************************************************//
    cleanCellIfHasProblem: function ( line_object ) {
        if ( this.hasCounterProblems() ) {
            this.cleanCellWithProblem( line_object );
        }
    },
    cleanCellWithProblem : function ( line_object ) {
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function () {
        return this.getValue();
    },
    //********************************************  HTML  *****************************************************//
    changeDomElementContent: function () {
        this.computeLabel();
        this.dom_element_content.innerHTML = this.getLabel();
    },
    computeLabel           : function () {
        this.label = this.getValue();
        if ( this.label === SHINKEN_LIST.CONST.FILTER.EMPTY ) {
            this.label = "";
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineCell, SHINKEN.OBJECT.CounterInterfaceV2LinkWithParentAndDomElement );
