//priority 21
//__lib__ lib_common
"use strict";

SHINKEN.OBJECT.NotificationsOfChange = {};

SHINKEN.OBJECT.NotificationsOfChange._interface = function () {
};

SHINKEN.OBJECT.NotificationsOfChange._interface.prototype = {
    init     : function ( data ) {
        this.timeout_ask_play_notification = null;
        if ( data ) {
            this.updateData( data );
        }
    },
    initPhase: function () {
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].doActionAfter( "init_phase" );
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].doActionAfter( "reset_object" );
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].initPhase();
    },
    //**************************************    EVENT LISTENER     **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "ask_play_notifications":
                if ( this.timeout_ask_play_notification ) {
                    clearTimeout( this.timeout_ask_play_notification );
                }
                this.timeout_ask_play_notification = setTimeout(  () => {
                    this.doActionAfter( "ask_play_notification_visual_blink", param );
                    this.doActionAfter( "ask_play_notification_of_sound", param );
                }, 200 );
                break;
            case "notification-configuration-set-dom-element-with-data":
            case "init_with_dom_element":
            case "click_done":
                this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].doActionAfter( event_name, param );
                this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].doActionAfter( event_name, param );
                break;
            case "change_value_notification_of_change_visual_blink":
            case "user_has_disabled_blink_notification":
            case "ask_play_notification_visual_blink":
            case "shinken_view_has_disabled_blink_notification":
            case "set_phase_blink_depending_number_of_change":
                this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].doActionAfter( event_name, param );
                break;
            case "ask_play_notification_of_sound":
            case "change_value_notification_of_change_sound":
            case "shinken_view_has_disabled_sound_notification":
            case "user_has_volume_muted_notification":
            case "set_phase_sound_depending_number_of_change":
                this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].doActionAfter( event_name, param );
                break;
            default:
                console.log( "[_interface - doActionAfter]", "[not managed case]", event_name, param );
                break;
        }
    },
    //**************************************    DATAS         **************************************************//
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND:
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL:
                this[ key ].updateData( value );
                break;
            case "timeout_ask_play_notification":
                break;
            default:
                console.warn( "[NotificationsOfChange]", "[IGNORED DATA]", "[" + key + "]", value );
        }
    },
    //**************************************    GETTER SETTER         **************************************************//
    getSoundValue : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].getValue();
    },
    getVolumeValue: function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].getValue();
    },
    getBlinkValue : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].getBlinkValue();
    },
    //**************************************    SAVE         **************************************************//
    getDataToSave: function () {
        var _to_return                                                         = {};
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ]  = this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.SOUND ].getDataToSave();
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ] = this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.VISUAL ].getDataToSave();
        return _to_return;
    }
};