//priority 20
//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.CONST.PHASE                  = {
    RUNNING                 : 0,
    REFRESHING              : 1,
    REFRESHING_TO_STRING    : "REFRESHING",
    INIT                    : 2,
    EDITING                 : 3,
    EDITING_TO_STRING       : "EDITING",
    SAVING                  : 4,
    WAITING_FOR_START_IMPORT: 5,
    WAITING_FOR_IMPORT      : 6,
    WAITING_FOR_MERGE       : 7,
    WAITING_FOR_UPDATE      : 8,
    READY                   : "READY",
    WAITING_FOR_READY       : 10,
    STOPPING                : "STOPPING",
    SLEEPING                : "SLEEPING",
    RUNNING_TO_STRING       : "RUNNING",
    STARTING                : 12,
    STUCK                   : 13,
    STUCK_TO_STRING         : "STUCK",
    HIDDEN                  : 14,
    HIDDEN_TO_STRING        : "HIDDEN_TO_STRING",
    ASKING_ENTER_PREVIEWING : 15,
    PREVIEWING              : 16,
    ASKING_ENTER_EDITING    : 17,
    ASKING_SHOW_FORM        : 171,
    ASK_FOR_REFRESH         : 18,
    RUNNING_OK              : 19,
    RUNNING_OK_WITH_WARNING : 191,
    RUNNING_NOK             : 20,
    SAVING_AFTER_PREVIEWING : 21,
    TO_BE_DELETED           : 22,
    ASK_FOR_SAVING          : 23,
    ASK_FOR_CANCEL          : 24,
    CANCEL                  : 25,
    SAVE_DONE               : 26,
    RUNNING_WITH_WARNING    : 27,
    ASK_FOR_CLOSE           : 28,
    TO_BE_DELETED_FOREVER   : 29,
    TO_BE_RESTORED          : 30,
    DELETED                 : "PHASE_DELETED",
    CREATING                : "CREATING",
    ADDING                  : "ADDING",
    CLONING                 : "CLONING",
    DISCREET_USER           : "DISCREET_USER",
    DISCREET_VIEW           : "DISCREET_VIEW",
    DISCREET_NAVIGATOR      : "DISCREET_NAVIGATOR",
    PUBLISHING              : "PUBLISHING",
    SELECTED                : "SELECTED",
    EDITING_SINGLE_GRID_CELL: "EDITING_SINGLE_GRID_CELL",
    HOVER                   : "HOVER",
    LOADING_DATA            : "LOADING_DATA",
    RESET                   : "RESET"
};
SHINKEN.OBJECT.CONST.CALLBACK_PHASE_TIMEOUT = 0;

SHINKEN.OBJECT.Phase = function ( parent_object ) {
    this.previous_phase                 = null;
    this.current_phase                  = SHINKEN.OBJECT.CONST.PHASE.INIT;
    this.next_phase                     = null;
    this.parent_object                  = parent_object;
    this.timeout_set_phase_callback     = null;
    this.timeout_phase                  = null;
    this.synchrnonized_phase_object     = [];
    this.action_to_do_on_phase          = new SHINKEN.OBJECT.DoActionsAfter();
    this.action_to_do_callback_on_phase = new SHINKEN.OBJECT.DoActionsAfter();
};

SHINKEN.OBJECT.Phase.prototype = {
    setPhase                       : function ( to_set ) {
        if ( this.timeout_phase ) {
            clearTimeout( this.timeout_phase );
        }
        this.previous_phase = this.current_phase;
        this.current_phase  = to_set;
        if ( this.dom_element ) {
            this._setPhaseInDomElement();
        }
        this.next_phase = null;
        if ( this.parent_object ) {
            if ( this.timeout_set_phase_callback ) {
                clearTimeout( this.timeout_set_phase_callback );
            }
            this.timeout_set_phase_callback = setTimeout( () => {
                this.parent_object.callbackForPhase();
                this.action_to_do_callback_on_phase.doActionAfter( this.current_phase );
                this.timeout_set_phase_callback = null;
            }, SHINKEN.OBJECT.CONST.CALLBACK_PHASE_TIMEOUT );
        }
        if ( this.synchrnonized_phase_object.length ) {
            for ( let i = 0, _size_i = this.synchrnonized_phase_object.length; i < _size_i; i++ ) {
                this.synchrnonized_phase_object[ i ].setPhase( to_set );
            }
        }
        this.action_to_do_on_phase.doActionAfter( this.current_phase );
    },
    _setPhaseInDomElement          : function () {
        if ( this.dom_element_data_name ) {
            DOM.Service.setDataSet( this.dom_element, this.dom_element_data_name + 'CurrentPhase', this.current_phase );
            DOM.Service.setDataSet( this.dom_element, this.dom_element_data_name + 'PreviousPhase', this.previous_phase );
        }
        else {
            DOM.Service.setDataSet( this.dom_element, 'currentPhase', this.current_phase );
            DOM.Service.setDataSet( this.dom_element, 'previousPhase', this.previous_phase );
        }
    },
    setPhaseIfPhase                : function ( to_set, if_is ) {
        if ( !this.isPhase( if_is ) ) {
            return;
        }
        this.setPhase( to_set );
        return true;
    },
    setPhaseWithTimeOut            : function ( to_set, timeout ) {
        if ( !timeout ) {
            timeout = 0;
        }
        this.timeout_phase = setTimeout( () => {
            this.setPhase( to_set );
        }, timeout );
    },
    isPhase                        : function ( to_test ) {
        return this.current_phase === to_test;
    },
    togglePhase                    : function ( phase_1, phase_2 ) {
        if ( this.isPhase( phase_1 ) ) {
            this.setPhase( phase_2 );
        }
        else {
            this.setPhase( phase_1 );
        }
    },
    isPreviousPhase                : function ( to_test ) {
        if ( this.previous_phase === undefined ) {
            return false;
        }
        return this.previous_phase === to_test;
    },
    setParent                      : function ( parent_object ) {
        this.parent_object = parent_object;
    },
    addSynchronizedPhase           : function ( to_add, clean_before ) {
        if ( clean_before ) {
            this.synchrnonized_phase_object = [];
        }
        this.synchrnonized_phase_object.push( to_add );
    },
    haveSamePreviousAndCurrentPhase: function () {
        return this.previous_phase === this.current_phase;
    },
    setDomElement                  : function ( to_set, data_name ) {
        this.dom_element           = to_set;
        this.dom_element_data_name = data_name;
        this._setPhaseInDomElement();
    }
};

SHINKEN.OBJECT.PhaseInterface           = function () {
};
SHINKEN.OBJECT.PhaseInterface.prototype = {
    initPhase                          : function ( phase_value, dom_element ) {
        this.phase = new SHINKEN.OBJECT.Phase( this );
        if ( dom_element ) {
            this.phase.setDomElement( dom_element );
        }
        if ( phase_value ) {
            this.setPhase( phase_value );
        }
    },
    addSynchronizedPhase               : function ( to_add, clean_before ) {
        this.phase.addSynchronizedPhase( to_add, clean_before );
    },
    isPhase                            : function ( to_test ) {
        return this.phase.isPhase( to_test );
    },
    isInPhase                          : function ( array_to_test ) {
        for ( let i = 0, _size_i = array_to_test.length; i < _size_i; i++ ) {
            if ( this.phase.isPhase( array_to_test[ i ] ) ) {
                return true;
            }
        }
        return false;
    },
    setPhase                           : function ( to_set ) {
        this.phase.setPhase( to_set );
    },
    setPhaseOrPhase                    : function ( boolean, to_set_true, to_set_false ) {
        this.setPhase( boolean ? to_set_true : to_set_false );
    },
    setPhaseIfDifferent                : function ( to_set ) {
        if ( to_set !== this.getCurrentPhase() ) {
            this.phase.setPhase( to_set );
        }
    },
    addDoActionAfterCallBackPhaseIs    : function ( phase_to_test, event_name, param_1, param_2, param_3 ) {
        if ( this.isPhase( phase_to_test ) ) {
            this.doActionAfter( event_name, param_1, param_2, param_3 );
        }
        else {
            this.addDoActionAfterCallBackPhaseBecome( phase_to_test, event_name, param_1, param_2, param_3 );
        }
    },
    addDoActionAfterCallBackPhaseBecome: function ( phase_to_test, event_name, param_1, param_2, param_3 ) {
        this.phase.action_to_do_callback_on_phase.add( new SHINKEN.OBJECT.DoActionAfter( this, phase_to_test, event_name, param_1, param_2, param_3 ) );
    },
    togglePhase                        : function ( phase_1, phase_2 ) {
        this.phase.togglePhase( phase_1, phase_2 );
    },
    setPhaseParent                     : function ( to_set ) {
        this.phase.setParent( to_set );
    },
    setPhaseDomElement                 : function ( to_set, data_name ) {
        this.phase.setDomElement( to_set, data_name );
    },
    setPhaseIfPhase                    : function ( to_set, if_is ) {
        return this.phase.setPhaseIfPhase( to_set, if_is );
    },
    setPhaseWithTimeOut                : function ( to_set, timeout ) {
        this.phase.setPhaseWithTimeOut( to_set, timeout );
    },
    getCurrentPhase                    : function () {
        return this.phase.current_phase;
    },
    getPreviousPhase                   : function () {
        return this.phase.previous_phase;
    },
    setPreviousPhaseForced             : function ( to_set ) {
        this.phase.previous_phase = to_set;
    },
    isPreviousPhase                    : function ( to_test ) {
        return this.phase.isPreviousPhase( to_test );
    },
    isPreviousPhaseInPhase             : function ( array_to_test ) {
        for ( let i = 0, _size_i = array_to_test.length; i < _size_i; i++ ) {
            if ( this.phase.isPreviousPhase( array_to_test[ i ] ) ) {
                return true;
            }
        }
        return false;
    },
    callbackForPhase                   : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.PhaseInterface, SHINKEN.OBJECT.ShinkenObject );