//__lib__ lib_common
"use strict";

SHINKEN.SlaQualityService = (function ( self ) {
    "use strict";
    self.templates            = {};
    self.getTemplateInnerHtml = function ( sla_quality ) {
        var _name = sla_quality.name;
        if ( !self.templates[ _name ] ) {
            var _dom = document.querySelector( "#id-shinken-template-view #id-shinken-sla-quality-template-" + _name );
            if ( _dom ) {
                self.templates[ _name ] = _dom.innerHTML;
            }
            else {
                self.templates[ _name ] = "";
                console.warn("[StatusService - getTemplateInnerHtml]", "Missing resources template : " + _name );
            }
        }
        return self.templates[ _name ];
    };
    
    return self;
})( SHINKEN.StatusService || {} );
