//__lib__ lib_common_V02_01
"use strict";

PROPERTY.StringInputAbstract           = function () {
};
PROPERTY.StringInputAbstract.prototype = {
    init: function () {
    },
    //********************************************  EVENT LISTENER  **************************************************//
    askComputeAfterChange: function () {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input.askComputeAfterChange( null, this );
    },
    doActionAfterChange  : function ( args ) {
    },
    onFocus              : function () {
    },
    ___onFocusOut        : function () {
    },
    doActionAfter        : function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_button":
                switch ( param ) {
                    case "clean_input_value":
                        this.component_input.setValueFromJs( "" );
                        break;
                }
                break;
        }
    },
    //********************************************  SETTER GETTER   **************************************************//
    setValueFromUser     : function ( value ) {
        this.component_input.setValueFromJs( value );
    },
    setStatus            : function ( _to_set ) {
        this.status = _to_set;
        this.component_input.setStatus( _to_set );
    },
    getValue             : function () {
        return this.component_input.getValue();
    },
    setDefaultKeyAndValue: function ( to_set ) {
        this.default_value = to_set;
    },
    getDefaultValue      : function () {
        return this.default_value;
    },
    setPlaceholder       : function ( _to_set ) {
        return this.component_input.setPlaceholder( _to_set );
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSave: function () {
        return SHINKEN.TOOLS.STRING.trimExtented( this.getValue() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputAbstract, PROPERTY.InterfaceCommon );

PROPERTY.StringInputAbstract_V3           = function () {
};
PROPERTY.StringInputAbstract_V3.prototype = {
    init: function () {
        this.initContents();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter      : function ( event_name, param ) {
        return this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon: function ( event_name, param ) {
        switch ( event_name ) {
            case "click_on_button_V3":
            case "onchange_in_input_V3":
                param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ] = this;
                if ( this.getContentByUUID( param[ COMPONENT.INPUT.PARAM.NAME ] ) ) {
                    this.getContentByUUID( param[ COMPONENT.INPUT.PARAM.NAME ] ).doActionAfter( event_name, param );
                }
                break;
            case "set_placeholder_input_V3":
                this.setPlaceholder( param[ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ] );
                break;
        }
    },
    //********************************************  SETTER GETTER   **************************************************//
    setValueFromUser: function ( value ) {
        this.getContentByUUID( PROPERTY.COMMON.INPUT.MAIN_INPUT ).setValueFromJs( value );
    },
    setStatus       : function ( _to_set ) {
        this.status = _to_set;
        this.getContentByUUID( PROPERTY.COMMON.INPUT.MAIN_INPUT ).setStatus( _to_set );
    },
    getValue        : function () {
        return this.getContentByUUID( PROPERTY.COMMON.INPUT.MAIN_INPUT ).getValue();
    },
    setPlaceholder  : function ( _to_set ) {
        return this.getContentByUUID( PROPERTY.COMMON.INPUT.MAIN_INPUT ).setPlaceholder( _to_set );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputAbstract_V3, PROPERTY.StringInputAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputAbstract_V3, SHINKEN.OBJECT.ShinkenObjectContainerHtml );

PROPERTY.StringInputFromData           = function ( property_name, value ) {
    this.__class_name__ = 'PROPERTY.StringInputFromData';
    this.initSpecific( property_name, value );
};
PROPERTY.StringInputFromData.prototype = {
    initSpecific: function ( property_name, value ) {
        this.name = property_name;
        this.init();
        this.component_input = new COMPONENT.InputFromDataV2( value, this.name );
    },
    //********************************************  HTML    **********************************************************//
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
    },
    computeHtml_getType                 : function () {
        return PROPERTY_V2.COMMON.TYPES.STRING_INPUT;
    },
    computeHtml_getCellPropActionContent: function () {
        this.component_input.computeHtml();
        DOM.Service.addElementTo( this.component_input.getDomElement(), this.dom_cell_action );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputFromData, PROPERTY.StringInputAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputFromData, PROPERTY.InterfaceCommonFromData );

PROPERTY.StringInputFromData_V3           = function ( property_name, value, label ) {
    this.__class_name__ = 'PROPERTY.StringInputFromData_V3';
    this.initSpecific( property_name, value, label );
};
PROPERTY.StringInputFromData_V3.prototype = {
    initSpecific     : function ( property_name, value, label ) {
        this.name = property_name;
        this.init();
        this.addParamForEvents( PROPERTY.COMMON.PARAM.PROPERTY_NAME, this.name );
        this.add( new COMPONENT.InputFromData_V3( PROPERTY.COMMON.INPUT.MAIN_INPUT, value, this.getParamForEvents() ) );
        this.setLabel( label || property_name );
        this.initCounterCommon();
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.USER );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    askComputeAfterChange: function () {
        if ( this.is_disabled ) {
            return;
        }
        this.getContentByUUID( PROPERTY.COMMON.INPUT.MAIN_INPUT ).askComputeAfterChange( null, this );
    },
    doActionAfterChange  : function ( args ) {
        this.getContentByUUID( PROPERTY.COMMON.INPUT.MAIN_INPUT ).doActionAfter( "clean_validation_error" );
        CONTROLLER.Form.doActionAfter( "onchange_in_input_V3_done", { [ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ]: this, [ PROPERTY.COMMON.PARAM.PROPERTY_NAME ]: this.getName() } );
    },
    onFocus              : function () {
    },
    ___onFocusOut        : function () {
    },
    setTypeComponent     : function ( to_set ) {
        this.getContentByUUID( PROPERTY.COMMON.INPUT.MAIN_INPUT ).setType__20241003( to_set );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "property_value__set__by_data":
            case "property_value__set__by_js":
                this.getContentByUUID( PROPERTY.COMMON.INPUT.MAIN_INPUT ).setValueFromJs( param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] );
                return;
            case "property_visibility__set":
                this.setVisibilityState( param[ PROPERTY.COMMON.PARAM.PROPERTY_VISIBILITY ] );
                break;
            case "add_message_validation":
                this.getContentByUUID( PROPERTY.COMMON.INPUT.MAIN_INPUT ).doActionAfter( event_name, param );
                return;
        }
        return this.doActionAfterCommon( event_name, param );
    },
    //********************************************  HTML    **********************************************************//
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
    },
    computeHtml_getType                 : function () {
        return PROPERTY_V2.COMMON.TYPES.STRING_INPUT;
    },
    computeHtml_getCellPropActionContent: function () {
        this.getContentByUUID( PROPERTY.COMMON.INPUT.MAIN_INPUT ).computeHtml();
        DOM.Service.addElementTo( this.getContentByUUID( PROPERTY.COMMON.INPUT.MAIN_INPUT ).getDomElement(), this.dom_cell_action );
    },
    //********************************************  SAVE    **********************************************************//
    getDataToSave__20241127: function ( type_save ) {
        let to_return = this.getDataToSave();
        switch ( type_save ) {
            case SHINKEN.OBJECT.FORM.TYPE_SAVE.VALUE_AND_DEFAULT_FOR_GRID:
                to_return = SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.parseValueToDict_withValueKey( to_return, to_return );
                break;
        }
        return to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputFromData_V3, PROPERTY.StringInputAbstract_V3 );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputFromData_V3, PROPERTY.InterfaceCommonFromData_V3 );

