//priority 21
//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.RADIOMODE = {
    PARAM         : {
        NAME                          : "radio_mode_name",
        PARENT_OBJECT                 : "radio_parent_object_name",
        RADIO_MODE_IS_DISABLE         : "radio_mode_is_disable",
        IS_RADIO_MODE_ALREADY_IN_PHASE: "is_radio_mode_already_in_phase"
    },
    RADIO_SELECTOR: "radio_selector",
    RADIO_INPUT   : "radio_input"
};

SHINKEN.OBJECT.RadioModes           = function ( name ) {
    this.init( name );
};
SHINKEN.OBJECT.RadioModes.prototype = {
    init           : function ( name ) {
        this.name = name;
        this.initContents();
        this.initPhase( SHINKEN.OBJECT.CONST.PHASE.READY );
    },
    initListContent: function ( data_radios ) {
        var _current;
        for ( var i = 0, _size_i = data_radios.length; i < _size_i; i++ ) {
            _current = this.add( this.getChildConstructor( data_radios[ i ].name, data_radios[ i ].label ) );
            _current.addParamsForEvents( this.getParamForEvents() );
            if ( data_radios[ i ][ PROPERTY_V2.COMMON.PARAM.IS_DEFAULT ] ) {
                _current.addClass( "shinken-is-default" );
                this.setDefaultKeyAndValue( data_radios[ i ].name, data_radios[ i ][ PROPERTY_V2.COMMON.PARAM.DEFAULT_VALUE ] );
            }
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter      : function ( event_name, param ) {
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon: function ( event_name, param ) {
        switch ( event_name ) {
            case "change_radio_mode_by_js":
            case "change_radio_mode":
                if ( param[ SHINKEN.OBJECT.RADIOMODE.PARAM.RADIO_MODE_IS_DISABLE ] ) {
                    return;
                }
                param[ SHINKEN.OBJECT.RADIOMODE.PARAM.IS_RADIO_MODE_ALREADY_IN_PHASE ] = this.isPhase( param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] );
                this.setPhase( param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] );
                for ( let j = 0, _size_j = this.contents.length; j < _size_j; j++ ) {
                    this.contents[ j ].doActionAfter( event_name, param );
                }
                if ( param[ SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME ] ) {
                    CONTROLLER.Form.doActionAfter( "change_radio_mode_done", param );
                }
                break;
            case "property_value__set__by_data":
            case "property_value__set__by_js":
                if ( !this.getContentByUUID( param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] ) ) {
                    let _current = this.add( this.getChildConstructor( param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ], param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] ) );
                    _current.addParamsForEvents( this.getParamForEvents() );
                    _current.addParamForEvents( SHINKEN.OBJECT.RADIOMODE.PARAM.RADIO_MODE_IS_DISABLE, true );
                }
                this.setPhase( param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] );
                for ( let j = 0, _size_j = this.contents.length; j < _size_j; j++ ) {
                    this.contents[ j ].doActionAfter( event_name, param );
                }
                break;
            case "change_radio_mode_if_not_set":
                if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.READY ) ) {
                    this.doActionAfter( "change_radio_mode", {
                            [ SHINKEN.OBJECT.RADIOMODE.PARAM.PARENT_OBJECT ]: this.getName(),
                            [ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ]         : this.getContent( 0 ).getUUID()
                        }
                    );
                }
                break;
            case "add_message_validation":
                this.getContentByUUID( param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] ).doActionAfter( event_name, param );
                break;
            default:
                for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
                    this.contents[ i ].doActionAfter( event_name, param );
                }
                break;
        }
    },
    getChildConstructor: function ( name, label ) {
        return new SHINKEN.OBJECT.RadioMode( name, label );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID : function () {
        return this.name;
    },
    getName : function () {
        return this.getUUID();
    },
    getClass: function ( to_add ) {
        return "shinken-radio-modes-content";
    },
    //********************************************  ACTION  *****************************************************//
    add: function ( to_add ) {
        let to_return = this.addCommon( to_add );
        to_add.addParamForEvents( SHINKEN.OBJECT.RADIOMODE.PARAM.PARENT_OBJECT, this.getName() );
        return to_return;
    },
    //********************************************  HTML  *****************************************************//
    computeHtml        : function () {
        this.computeCommonHtml();
        this.computeSpecificHtml();
        this.setPhaseIfPhase( SHINKEN.OBJECT.CONST.PHASE.READY, SHINKEN.OBJECT.CONST.PHASE.INIT );
        this.doActionAfter( "compute_html_done" );
    },
    computeCommonHtml  : function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: this.getClass() } ) );
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            this.addDomElement( this.getContent( i ).getDomElement() );
        }
        this.computeHtmlExtra();
    },
    computeSpecificHtml: function () {
    },
    //********************************************  VALIDATION  *****************************************************//
    getDataToSave: function () {
        return this.getValue();
    },
    getValue     : function () {
        return this.getCurrentPhase();
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.RadioModes, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.RadioModes, SHINKEN.OBJECT.PhaseInterface );

SHINKEN.OBJECT.CheckBoxRadioModes           = function ( name ) {
    this.init( name );
};
SHINKEN.OBJECT.CheckBoxRadioModes.prototype = {
    init: SHINKEN.OBJECT.RadioModes.prototype.init,
    //********************************************  GETTER SETTER  *****************************************************//
    getChildConstructor: function ( name, label ) {
        return new SHINKEN.OBJECT.CheckBoxRadioMode( name, label );
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CheckBoxRadioModes, SHINKEN.OBJECT.RadioModes );

SHINKEN.OBJECT.CheckBoxRadioModes__WithSelector           = function ( name ) {
    this.initSpecific( name );
};
SHINKEN.OBJECT.CheckBoxRadioModes__WithSelector.prototype = {
    initSpecific   : function ( name ) {
        this.init( name );
    },
    initListContent: function ( data_radios ) {
        var _current;
        for ( var i = 0, _size_i = data_radios.length; i < _size_i; i++ ) {
            if ( data_radios[ i ][ PROPERTY_V2.COMMON.PARAM.IS_DEFAULT ] ) {
                _current = this.add( this.getChildConstructor( data_radios[ i ].name, data_radios[ i ].label ) );
                _current.addParamsForEvents( this.getParamForEvents() );
                _current.addClass( "shinken-is-default" );
                this.setDefaultKeyAndValue( data_radios[ i ].name, data_radios[ i ][ PROPERTY_V2.COMMON.PARAM.DEFAULT_VALUE ] );
            }
            else {
                let radio_selector = this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_SELECTOR );
                if ( !radio_selector ) {
                    _current = this.add( this.getChildConstructorForSelect( SHINKEN.OBJECT.RADIOMODE.RADIO_SELECTOR ) );
                    _current.addParamsForEvents( this.getParamForEvents() );
                }
                _current.addOption( data_radios[ i ] );
            }
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "set_default_value_in_selector":
                this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_SELECTOR ).doActionAfter( event_name, param );
                break;
            case "ask_hide_pop_up":
            case "click_done":
                param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ] = this;
                this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_SELECTOR ).doActionAfter( event_name, param );
                this.doActionAfter( "change_radio_mode_to_default_value_if_value_not_set" );
                break;
            case "change_radio_mode_to_default_value_if_value_not_set":
                if ( !this.getValue() ) {
                    this.doActionAfter( "change_radio_mode", { [ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ]: this.getDefaultKey() } );
                }
                return;
            case "click_on_selector_V3":
                param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ] = this;
                param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] = SHINKEN.OBJECT.RADIOMODE.RADIO_SELECTOR;
                this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_SELECTOR ).doActionAfter( event_name, param );
                return;
            case "click_on_item_selector_V3":
                param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ] = this;
                param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] = SHINKEN.OBJECT.RADIOMODE.RADIO_SELECTOR;
                this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_SELECTOR ).doActionAfter( event_name, param );
                this.doActionAfter( "change_radio_mode_by_js", param );
                return;
            case "click_on_item_selector_done":
                this.setPhase( param.getLastSelectedElementName() );
                return;
            case "property_value__set__by_data":
            case "property_value__set__by_js":
                let btn_radio                                = this.getContentByValue( param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] );
                param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ] = this;
                param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] = btn_radio.getName();
                btn_radio.doActionAfter( event_name, param );
                this.doActionAfter( "change_radio_mode", param );
                return;
            case "add_message_validation":
                this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_SELECTOR ).doActionAfter( event_name, param );
                return;
        }
        this.doActionAfterCommon( event_name, param );
    },
    setPhase     : function ( to_set ) {
        this.phase.setPhase( to_set );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getValue                    : function () {
        return this.getContentByValue( this.getCurrentPhase() ).getValue();
    },
    getContentByValue           : function ( value ) {
        let to_return = this.getContentByUUID( value );
        if ( !to_return ) {
            to_return = this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_SELECTOR );
        }
        return to_return;
    },
    getChildConstructor         : function ( name, label ) {
        return new SHINKEN.OBJECT.CheckBoxRadioMode( name, label );
    },
    getChildConstructorForSelect: function ( name ) {
        return new SHINKEN.OBJECT.CheckBoxRadioMode__WithSelector( name );
    },
    // ******************************************* LAST MODIFICATIONS ************************************************
    doActionAfterLastModification: function ( event_name, param ) {
        this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_SELECTOR ).doActionAfterLastModification(event_name, param);
    },
    getDataForLastModification: function ( params ) {
        return this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_SELECTOR ).getDataForLastModification();
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CheckBoxRadioModes__WithSelector, SHINKEN.OBJECT.CheckBoxRadioModes );

SHINKEN.OBJECT.CheckBoxRadioModes__WithStringInput           = function ( name ) {
    this.initSpecific( name );
};
SHINKEN.OBJECT.CheckBoxRadioModes__WithStringInput.prototype = {
    initSpecific   : function ( name ) {
        this.init( name );
    },
    initListContent: function ( data_radios ) {
        var _current;
        for ( var i = 0, _size_i = data_radios.length; i < _size_i; i++ ) {
            switch ( data_radios[ i ].name ) {
                case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.WIDTH.OPTIONS.STRING_INPUT:
                    _current = this.add( this.getChildConstructorForInput( SHINKEN.OBJECT.RADIOMODE.RADIO_INPUT ) );
                    break;
                default:
                    _current = this.add( this.getChildConstructor( data_radios[ i ].name, data_radios[ i ].label ) );
                    if ( data_radios[ i ][ PROPERTY_V2.COMMON.PARAM.IS_DEFAULT ] ) {
                        _current.addClass( "shinken-is-default" );
                        this.setDefaultKeyAndValue( data_radios[ i ].name, data_radios[ i ][ PROPERTY_V2.COMMON.PARAM.DEFAULT_VALUE ] );
                    }
                    break;
            }
            _current.addParamsForEvents( this.getParamForEvents() );
        }
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "property_value__set__by_data":
            case "property_value__set__by_js":
                param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ] = this;
                const btn_radio                              = this.getContentByValue( param[ PROPERTY.COMMON.PARAM.PROPERTY_VALUE ] );
                param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] = btn_radio.getName();
                btn_radio.doActionAfter( event_name, param );
                this.doActionAfter( "change_radio_mode", param );
                return;
            case "add_message_validation":
            case "onchange_in_input_V3":
            case "click_on_button_V3":
            case "onclick_in_input_V3":
            case "clean_validation_error":
                //param[ PROPERTY.COMMON.PARAM.PARENT_OBJECT ] = this;
                param[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] = SHINKEN.OBJECT.RADIOMODE.RADIO_INPUT;
                this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_INPUT ).doActionAfter( event_name, param );
                return;
            case "update_radio_mode_using_input_value":
                let value = this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_INPUT ).getValue();
                if ( value === "" ) {
                    value = this.getDefaultKey();
                }
                const btn_radio_2 = this.getContentByValue( value );
                this.setPhase( btn_radio_2.getValue() );
                this.doActionAfter( "change_radio_mode", { [ PROPERTY.COMMON.PARAM.PARENT_OBJECT ]: this, [ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ]: btn_radio_2.getName() } );
                break;
        }
        this.doActionAfterCommon( event_name, param );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getValue                   : function () {
        return this.getContentByValue( this.getCurrentPhase() ).getValue();
    },
    getContentByValue          : function ( value, is_forced ) {
        let to_return = this.getContentByUUID( value );
        if ( !to_return ) {
            to_return = this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_INPUT );
        }
        return to_return;
    },
    getChildConstructor        : function ( name, label ) {
        return new SHINKEN.OBJECT.CheckBoxRadioMode( name, label );
    },
    getChildConstructorForInput: function ( name ) {
        return new SHINKEN.OBJECT.CheckBoxRadioMode__WithStringInput( name );
    },
    // ******************************************* LAST MODIFICATIONS ************************************************
    doActionAfterLastModification: function ( event_name, param ) {
        this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_INPUT ).doActionAfterLastModification(event_name, param);
    },
    getDataForLastModification: function ( params ) {
        return this.getContentByUUID( SHINKEN.OBJECT.RADIOMODE.RADIO_INPUT ).getDataForLastModification();
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CheckBoxRadioModes__WithStringInput, SHINKEN.OBJECT.CheckBoxRadioModes );
