//priority 10
//__lib__ lib_common
"use strict";

var CLIPBOARD_SERVICE = (function ( self ) {
    self.PARAM            = {
        EVENT_NAME_COPY: "copy_to_clipboard",
        EVENT_NAME_EDIT: "edit_to_clipboard_target"
    };
    self.dom_textarea     = null;
    self.dom_parent       = null;
    self.dom_button       = null;
    self.dom_text_to_copy = null;
    self.type             = null;
    
    self.TYPE      = {};
    self.TYPE.TEXT = 'text';
    self.TYPE.HTML = 'html';
    
    self.setContent       = function ( dom_event, value, displayResultCallBack ) {
        var _dom_button = DOM.Service.findParentElementWithClass( dom_event, 'shinken-button', 10 );
        setValueTextArea( value );
        self.dom_textarea.select();
        
        var status = false;
        try {
            status = document.execCommand( 'copy' );
            displayResultCallBack ? displayResultCallBack( status, _dom_button ) : displayResult( status, _dom_button );
            setValueTextArea( '' );
        }
        catch ( err ) {
            console.log( 'Unable to copy.' );
        }
    };
    self.buildHtmlButtons = function ( hasCopyButton, hasEditButton, event_name, param ) {
        var table_buttons = DOM.Service.createElement( "table", { class: "shinken-copy-buttons-container" } );
        var line_buttons  = DOM.Service.createElement( "tr", {} );
        if ( hasCopyButton ) {
            var button_copy_cell = DOM.Service.createElement( "td", { class: "shinken-btn-copy-cell" } );
            var button_copy      = DOM.Service.createElement( "td", {
                class             : "shinken-button shinken-btn-copy shinken-btn-copy-text",
                onclick           : 'MANAGER.EventManager.clickOnButton(event)',
                'data-status-copy': '0',
                'data-name'       : event_name ? event_name : '',
                'data-param'      : param ? param : '',
                onmouseenter      : 'SHINKEN_TOOLTIP.showTooltip(this);',
                onmouseleave      : 'SHINKEN_TOOLTIP.hideTooltip();',
                'shi-tip-html'    : _( 'copy_service.tooltip_text_copy' )
            } );
            var icon_button_copy = DOM.Service.createElement( "span", { class: "shinken-copy-default-message shinicon-copy" } );
            
            button_copy.appendChild( icon_button_copy );
            button_copy_cell.appendChild( button_copy );
            line_buttons.appendChild( button_copy_cell );
        }
        if ( hasEditButton ) {
            var button_edit_cell = DOM.Service.createElement( "td", { class: "shinken-btn-edit-cell" } );
            var button_edit      = DOM.Service.createElement( "td", {
                class             : "shinken-btn-copy",
                onclick           : 'MANAGER.EventManager.clickOnPaste(event)',
                'data-status-copy': '0',
                onmouseenter      : 'SHINKEN_TOOLTIP.showTooltip(this);',
                onmouseleave      : 'SHINKEN_TOOLTIP.hideTooltip();',
                'shi-tip-html'    : _( 'copy_service.tooltip_edition' )
            } );
            var icon_button_edit = DOM.Service.createElement( "span", { class: "shinken-copy-default-message shinken-icons-url shinken-icons-url-write" } );
            
            button_edit.appendChild( icon_button_edit );
            button_edit_cell.appendChild( button_edit );
            line_buttons.appendChild( button_edit_cell );
        }
        table_buttons.appendChild( line_buttons );
        return table_buttons;
    };
    
    self.buildHtmlButtons_V3 = function ( has_copy_button, has_edit_button, params ) {
        let to_return = DOM.Service.createElement( "div", { class: "shinken-clipboard-container shinken-layout-inline-center-h-v" } );
        if ( has_copy_button ) {
            let copy_button = new COMPONENT.ButtonFromData_V3( CLIPBOARD_SERVICE.PARAM.EVENT_NAME_COPY, "<span class='shinicon shinicon-copy'></span>" );
            copy_button.addParamsForEvents( params );
            copy_button.addClass( "shinken-btn-copy shinken-btn-copy-text" );
            copy_button.computeHtml();
            copy_button.setTooltipHtml( _( 'copy_service.tooltip_text_copy', [DICTIONARY_COMMON_UI] ) );
            DOM.Service.addElementTo( copy_button.getDomElement(), to_return );
        }
        if ( has_edit_button ) {
            let edit_button = new COMPONENT.ButtonFromData_V3( CLIPBOARD_SERVICE.PARAM.EVENT_NAME_EDIT, "<span class='shinken-icons-url shinken-icons-url-write'></span>" );
            edit_button.addParamsForEvents( params );
            edit_button.addClass( "shinken-btn-copy" );
            edit_button.computeHtml();
            edit_button.setTooltipHtml( _( 'copy_service.tooltip_edition' ) );
            DOM.Service.addElementTo( edit_button.getDomElement(), to_return );
        }
        return to_return;
    };
    
    self.doPaste = function ( event ) {
        event.preventDefault();
        var clipboardData = event.clipboardData || window.clipboardData;
        var to_return     = window.clipboardData ? clipboardData.getData( 'Text' ) : clipboardData.getData( "text/plain" );
        to_return         = to_return.trim();
        document.execCommand( "insertHTML", false, SHINKEN.TOOLS.STRING.cleanXss( to_return ) );
        return to_return;
    };
    
    init();
    
    //private
    function init () {
        setTimeout( function () {
            createDomTextArea();
        }, 1000 );
    }
    
    function createDomTextArea () {
        var _body = document.querySelector( 'body' );
        if ( !_body ) {
            setTimeout( function () {
                createDomTextArea();
            }, 1000 );
            return;
        }
        self.dom_textarea               = document.createElement( 'textarea' );
        self.dom_textarea.id            = 'id-shinken-copy-clipboard-container';
        self.dom_textarea.style.opacity = '0';
        _body.appendChild( self.dom_textarea );
    }
    
    
    function setValueTextArea ( to_set ) {
        self.dom_textarea.value = to_set;
    }
    
    
    function displayResult ( status, dom_button ) {
        var _text     = status ? _( 'copy_service.copySuccess', [DICTIONARY_COMMON_UI] ) : _( 'copy_service.copyFail', [DICTIONARY_COMMON_UI] );
        var _state    = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_FAILED;
        var _position = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_FAILED;
        SHINKEN.TOOLS.NOTIFICATION.addNotification( _text, _state, dom_button, _position, 2000 );
    }
    
    function pasteHtmlForIE ( text_to_paste ) {
        var sel,
            range;
        
        if ( window.getSelection ) {
            sel = window.getSelection();
            if ( sel.getRangeAt && sel.rangeCount ) {
                range = sel.getRangeAt( 0 );
                range.deleteContents();
                
                var _div = DOM.Service.createElement( "div", {}, text_to_paste );
                
                var frag = document.createDocumentFragment(),
                    node,
                    lastNode;
                
                while ( (node = _div.firstChild) ) {
                    lastNode = frag.appendChild( node );
                }
                range.insertNode( frag );
                
                // Preserve the selection
                if ( lastNode ) {
                    range = range.cloneRange();
                    range.setStartAfter( lastNode );
                    range.collapse( true );
                    sel.removeAllRanges();
                    sel.addRange( range );
                }
            }
        }
    }
    //********************************************  USED IN ANGULAR  ************************************************//
    //********************************************   DON'T DELETE    ************************************************//
    self.setContent__Angular_Old = function ( dom_element, type ) {
        self.initDomElement_old( dom_element );
        if ( !self.dom_parent || !self.dom_text_to_copy ) {
            displayResult( false );
            return;
        }
        var _value;
        switch ( type ) {
            case self.TYPE.TEXT:
                _value = self.dom_text_to_copy.innerText;
                break;
            case self.TYPE.HTML:
                _value = self.dom_text_to_copy.outerHTML;
                break;
        }
        
        setValueTextArea( _value );
        self.dom_textarea.select();
        var status = false;
        try {
            status = document.execCommand( 'copy' );
            displayResult( status );
            setValueTextArea( '' );
        }
        catch ( err ) {
            console.log( 'Unable to copy.' );
        }
    };
    
    self.initDomElement_old = function ( dom_element ) {
        self.dom_button = dom_element;
        self.dom_parent = DOM.Service.findParentElementWithClass( dom_element, "shinken-parent-text-to-copy", 5 );
        if ( !self.dom_parent ) {
            return;
        }
        self.dom_text_to_copy = self.dom_parent.querySelector( ".shinken-text-to-copy" );
    };
    return self;
    
})( {} );