//__lib__ lib_common
"use strict";
var SHINKEN_GRID                      = {};
SHINKEN_GRID.CONST                    = {
    PARAM        : {
        GRID     : {
            SHINKEN_GRID_UUID              : "shinken_grid_uuid",
            TYPE                           : "type",
            GRID_ELEMENTS                  : "grid_elements",
            ORDERING                       : "ordering",
            TILES_MAX_X                    : "nb_tiles_in_width",
            TILES_MAX_Y                    : "nb_tiles_in_height",
            SEPARATION_GRID_ELEMENT_MIN    : "separation_grid_element_min",
            SEPARATION_GRID_ELEMENT_MAX    : "separation_grid_element_max",
            SEPARATION_GRID_ELEMENT_PERCENT: "separation_grid_element_percent",
            LAYOUTS                        : "layouts",
            RESIZE_HEIGHT                  : "resize_height",
            ZOOM_PERCENT_FOR_WIDGET        : "zoom_percent_for_widget"
        },
        GRID_CELL: {
            POSITION_X : "position_x",
            POSITION_Y : "position_y",
            HEIGHT     : "height",
            WIDTH      : "width",
            UUID       : "uuid",
            CONTENT    : "content",
            INDEX_LABEL: "index_label",
            INDEX      : "index",
            MIN_WIDTH  : 2,
            MIN_HEIGHT : 1
        },
        EVENT    : {
            FOCUSED_WIDGET           : "focused_widget__20240816",
            GRIDS_UUID               : "grids_uuid",
            GRID_OBJECT              : "grid_object",
            GRID_UUID                : "grid_uuid",
            GRID_CELLS_OBJECT        : "grid_cells_object",
            GRID_CELLS_UUID          : "grid_cells_uuid",
            GRID_LIST_CELL_OBJECT    : "grid_list_cell_object",
            GRID_LIST_CELL_UUID      : "grid_list_cell_uuid_param",
            GRID_LIST_CELL_INDEXES   : "grid_list_cell_indexes",
            GRID_CELL_OBJECT         : "grid_cell_object",
            GRID_CELL_UUID           : "grid_cell_uuid_param",
            GRID__LAYOUTS__CHILD_NAME: "grid__layouts__child_name",
            ADD_DIRECTLY_TO_GRID     : "add_directly_to_grid"
        }
    },
    SPECIAL_VALUE: {
        SEPARATION_GRID_ELEMENT_MAX_UNLIMITED: "unlimited",
        ALL                                  : "all"
    }
};
SHINKEN_GRID.BelongGridCell           = {};
SHINKEN_GRID.BelongGridCell.prototype = {
    is_belonging_to_grid_cell_object: true
};

SHINKEN_GRID.CONST.PARAM.isSizesProperty = function ( property_name ) {
    property_name = SHINKEN.TOOLS.STRING.splitForGetLastOne( property_name, "." );
    switch ( property_name ) {
        case SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH:
        case SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT:
        case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X:
        case SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y:
            return true;
    }
    return false;
};