//__lib__ lib_common_V02_01
"use strict";

SHINKEN_GRID.Grid           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Grid.prototype = {
    init             : function ( data ) {
        this.setUUID();
        this.zoom_percent            = 100;
        this.zoom_percent_for_widget = 100;
        this.initPhase();
        this.initCounterCommon();
        this.initInternal();
        this.tile_pixel_size = 0;
        this.class           = "shinken-grid";
        if ( data ) {
            this.updateData( data );
            this.max_nb_tiles = this.grid_elements.getMaxTileInHeight();
        }
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WIDGET_TOTAL );
    },
    //********************************************  JSON  *****************************************************//
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE],
            [SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE],
            [SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE],
            [SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX, SHINKEN_VALIDATION.CONST.OTHERS.DEFINE_STRING_OR_INTEGER_POSITIVE, [SHINKEN_GRID.CONST.SPECIAL_VALUE.SEPARATION_GRID_ELEMENT_MAX_UNLIMITED, this.getDefaultValueLabel()]],
            [SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT, SHINKEN_VALIDATION.CONST.NUMBER.FLOAT_POSITIVE],
            [SHINKEN_GRID.CONST.PARAM.GRID.TYPE, SHINKEN_VALIDATION.CONST.LIST.INCLUDE_IN, ["grid"], true]
        ] );
    },
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS, "WEATHER.Cells"],
            [SHINKEN_GRID.CONST.PARAM.GRID.LAYOUTS, "SHINKEN.OBJECT.DefaultConfigurationGridLayouts"]
        ] );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter             : function ( event_name, params ) {
        switch ( event_name ) {
            case "compute_html_done":
                break;
            case "delete_selected_grid_cell":
                params[ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ]     = this.getController();
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]         = this;
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_UUID ] = this.selected_grid_cell.extractContentUuidIfHasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED );
                this.grid_elements.doActionAfter( event_name, params );
                SHINKEN.OBJECT.ConfirmationPopup_V3.getInstance().hide();
                break;
            case "on_scroll":
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]       = this;
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_OBJECT ] = this.grid_elements;
                this.grid_elements.doActionAfter( event_name, params );
                if ( this.overlayed_frame ) {
                    this.overlayed_frame.doActionAfter( event_name, params );
                    switch ( this.overlayed_frame.getObjectClassName() ) {
                        case "SHINKEN.OBJECT.OverlayFrameMove":
                            this.selected_grid_cell.doActionAfterContentChildren( "move_selected_grid_cell", this.overlayed_frame.getDelta__parseToParams( params ) );
                            this.computeOverlappingOfSelectedCells();
                            break;
                    }
                }
                break;
            case "change_zoom_percent_for_widget":
                this.zoom_percent_for_widget = params[ SHINKEN_GRID.CONST.PARAM.GRID.ZOOM_PERCENT_FOR_WIDGET ];
                this.doActionAfter( "reset_grid_cell_to_add" );
                break;
            case "update_grid__highlighted_tile":
                this.computeCursorGridPosition( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ] );
                this.updateHighLightedTile();
                break;
            case "reset_action_in_progress":
                this.resetActionInProgress();
                break;
            case "unselect_single_shinken_grid_cell":
                this.selected_grid_cell.getContentByUUID( params ).setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                this.selected_grid_cell.removeContent( params, null, true );
                break;
            case "is_an_action_overlay_frame_in_progress_in":
                return this.actionOverlayFrameCurrentlyInProgress();
            case "unselect_all_other_shinken_grid_cell":
                if ( !this.selected_grid_cell ) {
                    return;
                }
                for ( let i = this.selected_grid_cell.getSize() - 1; i >= 0; i-- ) {
                    if ( params && this.selected_grid_cell.getContent( i ).getUUID() === params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ] ) {
                        continue;
                    }
                    this.selected_grid_cell.getContent( i ).setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                    this.selected_grid_cell.getContent( i ).resetCounterByType( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED );
                    this.selected_grid_cell.getContent( i ).resetCounterByType( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING );
                    this.selected_grid_cell.removeContentByIndex( i, true );
                }
                break;
            case "open_form_for_widget_configuration":
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_OBJECT ].forEach( current_grid_cell => {
                    current_grid_cell.doActionAfter( "open_form_for_widget_configuration" );
                } );
                break;
            case "value__param__configured__from_form":
            case "change__shinken_element__from_form":
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_OBJECT ].doActionAfterContentChildren( event_name, params );
                break;
            case "redo_last_modification":
            case "undo_last_modification":
                if ( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_UUID ) ) {
                    params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ] = this;
                    this.grid_elements.doActionAfter( event_name, params );
                    return;
                }
                else if ( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID__LAYOUTS__CHILD_NAME ) ) {
                    const layout_name = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID__LAYOUTS__CHILD_NAME );
                    this[ SHINKEN_GRID.CONST.PARAM.GRID.LAYOUTS ][ layout_name ].doActionAfter( event_name, params );
                }
                else { // resize of grid
                    const modification_element = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ];
                    this.updateData( modification_element.getNextOrPrevious( event_name ) );
                    this.updateStyle();
                }
                return;
            case "on_key_up":
                switch ( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].keyCode ) {
                    case SHINKEN.CONST.KEY_CODE.SUPPR:
                        if ( !this.selected_grid_cell.isEmpty() ) {
                            this.computeConfirmationPopup( "delete_selected_grid_cell", "delete_selected_grid_cell" );
                        }
                        break;
                    case SHINKEN.CONST.KEY_CODE.ENTER:
                        if ( SHINKEN.OBJECT.ConfirmationPopup_V3.getInstance().getName() === "delete_selected_grid_cell" ) {
                            this.doActionAfter( "delete_selected_grid_cell", params );
                        }
                        break;
                    case SHINKEN.CONST.KEY_CODE.ESCAPE:
                        switch ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.WIDGET_MODE__PHASE__OBJECT ].current_phase ) {
                            case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_ADD:
                            case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_CREATE:
                            case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_DELETE:
                                if ( this.actionCurrentlyInProgress() ) {
                                    this.resetActionInProgress();
                                }
                                break;
                            case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT:
                                if ( this.actionCurrentlyInProgress() ) {
                                    this.selected_grid_cell.doActionAfterContentChildren( "apply_move_reset__manually", params );
                                    this.resetActionInProgress();
                                }
                                else {
                                    this.doActionAfter( "unselect_all_other_shinken_grid_cell" );
                                }
                                break;
                        }
                        break;
                }
                break;
            case "update_focus_from_json_action":
                if ( this.last_plusated_element_uuid === params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ] ) {
                    return;
                }
                this.last_plusated_element_uuid = params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ];
                const grid_cell                 = this.grid_elements.getContentByUUID( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ] );
                if ( grid_cell ) {
                    this.doActionAfter( "unselect_all_other_shinken_grid_cell" );
                    grid_cell.setPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED );
                    this.updateSelectedList( [grid_cell] );
                    DOM.Service.focusOnAnchor_withDom( grid_cell.getDomElement(), this.dom_parent_with_scroll, new DOM.Service.Animation( "shinken-pulsate", 1600 ), 5 );
                }
                break;
            case "change_size_of_grid":
                params[ SHINKEN.OBJECT.CONST.PARAM.PARAM_EVENT.PARAM_LIST_KEY ] = [SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y];
                this.setPreviousModificationElement( params );
                this.applyResizeOfGrid( params[ SHINKEN_GRID.CONST.PARAM.GRID.RESIZE_HEIGHT ] );
                params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].addSpecific( this.getLastModificationElement( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.EDIT_PARAMS, params ) );
                break;
            case "reset_grid_cell_to_add":
                if ( this.grid_cell_to_add ) {
                    this.grid_cell_to_add.remove( { [ SHINKEN.CONST.PARAM.EVENT_PARAM.AVOID_DO_ACTION_AFTER ]: true } );
                    this.grid_cell_to_add = null;
                }
                break;
            case "pulsate_widgets":
                let widget_uuids = params.split( ',' );
                widget_uuids.forEach( ( uuid ) => {
                    const _grid_cell = this.grid_elements.getContentByUUID( uuid );
                    if ( _grid_cell ) {
                        DOM.Service.focusOnAnchor_withDom( grid_cell.getDomElement(), this.dom_parent_with_scroll, new DOM.Service.Animation( "shinken-pulsate", 1600 ), 5 );
                    }
                } );
                
                break;
            case "get_default_values_of_grid":
                return this.getDefaultValueOfGrid();
            case "change_virtual_add_grid_cell":
                if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) ) {
                    return;
                }
                this.moveGridCellToAdd( null, params[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] );
                break;
            case "default__param__configured__from_form":
                let current_widget_default_layout_name;
                let current_widget_default_layout;
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]           = this;
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_LIST_CELL_OBJECT ] = new SHINKEN.OBJECT.ShinkenObjectContainer();
                for ( let i = 0; i < params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ].length; i++ ) {
                    params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ]   = params[ PROPERTY.COMMON.PARAM.PROPERTY_LIST__COMPOSED_KEY ][ i ];
                    params[ WIDGET.CONST.PARAM_EVENT.WIDGET_TYPE ] = SHINKEN.TOOLS.STRING.splitForGetFirstOne( params[ PROPERTY.COMMON.PARAM.COMPOSED_KEY ], "." );
                    
                    current_widget_default_layout = this.getLayoutFromTypeWidget( params[ WIDGET.CONST.PARAM_EVENT.WIDGET_TYPE ] );
                    current_widget_default_layout.addParamsForEvents( this.getParamForEvents() );
                    current_widget_default_layout.addParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID__LAYOUTS__CHILD_NAME, params[ WIDGET.CONST.PARAM_EVENT.WIDGET_TYPE ] + "_layout" );
                    current_widget_default_layout.doActionAfter( event_name, params );
                    
                    this.grid_elements.doActionAfter( event_name, params );
                }
                this.grid_elements.doActionAfter( "default__param__configured__from_form__done", params );
                break;
            case "move_selected_grid_cell":
                switch ( this.overlayed_frame.getObjectClassName() ) {
                    case "SHINKEN.OBJECT.GridCellResizer":
                        this.selected_grid_cell.getContent( 0 ).resetSquare();
                        this.computeOverlappingOfSelectedCells();
                        break;
                    case "SHINKEN.OBJECT.OverlayFrameMove":
                        this.selected_grid_cell.doActionAfterContentChildren( "move_selected_grid_cell", this.overlayed_frame.getDelta__parseToParams( params ) );
                        this.computeOverlappingOfSelectedCells();
                        break;
                }
                break;
            case "mouse_leave":
            case "mouse_wheel":
            case "mouse_move":
            case "mouse_up":
            case "mouse_down":
            case "mouse_move_on_grid_with_add_widget":
            case "mouse_down_on_grid_cell":
            case "mouse_up_on_grid_cell":
                this.doActionAfter_mouse( event_name, params );
                break;
            default:
                this.grid_elements.doActionAfter( event_name, params );
                break;
            
        }
    },
    doActionAfter_mouse       : function ( event_name, params ) {
        switch ( event_name ) {
            case "mouse_down":
                switch ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.WIDGET_MODE__PHASE__OBJECT ].current_phase ) {
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_CREATE:
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_DELETE:
                        this.doActionAfter( "unselect_all_other_shinken_grid_cell" );
                        this.initOverlayFrame( event_name, params );
                        break;
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT:
                        if ( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].target === this.getDomElement() && !params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].ctrlKey ) {
                            this.doActionAfter( "unselect_all_other_shinken_grid_cell" );
                        }
                        this.initOverlayFrame( event_name, params );
                        break;
                }
                break;
            case "mouse_down_on_grid_cell":
                const _dom_resize_icon        = DOM.Service.findParentElementWithClass( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].target, "shinken-resize-cursor", 50 );
                const _dom_delete_widget_icon = DOM.Service.findParentElementWithClass( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].target, "shinken-delete-button", 50 );
                const _dom_config_widget_icon = DOM.Service.findParentElementWithClass( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].target, "shinken-config-button", 50 );
                
                
                const _cell_ = this.grid_elements.doActionAfter( event_name, params );
                if ( !_dom_delete_widget_icon &&
                     this.selected_grid_cell &&
                     !params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].ctrlKey &&
                     !this.selected_grid_cell.containsUUID( _cell_.getUUID() ) ) {
                    this.doActionAfter( "unselect_all_other_shinken_grid_cell", params );
                }
                else if ( _dom_delete_widget_icon ) {
                    _cell_.setPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED );
                }
                else if ( _dom_config_widget_icon ) {
                    this.doActionAfter( "unselect_all_other_shinken_grid_cell", params );
                }
                
                this.updateSelectedList( [_cell_] );
                
                if ( _dom_resize_icon ) {
                    this.overlayed_frame = new SHINKEN.OBJECT.GridCellResizer( _dom_resize_icon.dataset.position, _cell_, this.tile_pixel_size );
                    this.overlayed_frame.init( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].clientX, params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].clientY, params[ "dom_relative_position_container_2024_07_18" ] );
                }
                else if ( _dom_delete_widget_icon ) {
                    params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].stopPropagation();
                    this.computeConfirmationPopup( "delete_selected_grid_cell", "delete_selected_grid_cell" );
                    return;
                }
                else if ( _dom_config_widget_icon ) {
                    params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].stopPropagation();
                    if ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] ) {
                        this.getController().doActionAfter( "focus-on-json-forced", { [ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ]: _cell_ } );
                    }
                    else {
                        this.getController().doActionAfter( "show_form_for_widget_configuration", { [ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ]: _cell_, [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]: this } );
                    }
                    return;
                }
                else {
                    if ( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].ctrlKey ) {
                        this.doActionAfter( "mouse_down", params ); //MULTIPLE SELECTION
                        return;
                    }
                    this.overlayed_frame = new SHINKEN.OBJECT.OverlayFrameMove();
                    this.overlayed_frame.init( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].clientX, params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].clientY, params[ "dom_relative_position_container_2024_07_18" ] );
                }
                this.getController().doActionAfter( "ask_close_form_for_widget_configuration__if_needed", { [ SHINKEN_GRID.CONST.PARAM.EVENT.FOCUSED_WIDGET ]: _cell_ } );
                switch ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.WIDGET_MODE__PHASE__OBJECT ].current_phase ) {
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_CREATE:
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_DELETE:
                        this.doActionAfter( "mouse_down", params );
                        break;
                }
                break;
            case "mouse_leave":
                this.updateHighLightedTile( true );
                this.doActionAfter( "reset_grid_cell_to_add" );
                SHINKEN.TOOLS.MOUSE.unsetLastMouseEvent();
                break;
            case "mouse_wheel":
                this.updateHighLightedTile( true );
                break;
            case "mouse_move":
                SHINKEN.TOOLS.MOUSE.setLastMouseEvent( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ] );
                if ( !this.actionOverlayFrameCurrentlyInProgress() ) {
                    return;
                }
                this.scrollWhenAtEdgeOfView( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ] );
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]       = this;
                params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_OBJECT ] = this.grid_elements;
                this.overlayed_frame.doActionAfter( event_name, params );
                switch ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.WIDGET_MODE__PHASE__OBJECT ].current_phase ) {
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT:
                        this.doActionAfter( "move_selected_grid_cell", params );
                        break;
                }
                break;
            case "mouse_up":
                var last_modification_mouse_up;
                switch ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.WIDGET_MODE__PHASE__OBJECT ].current_phase ) {
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_ADD:
                        if ( !this.grid_cell_to_add ) { // CLICK ON FORM
                            return;
                        }
                        if ( this.grid_cell_to_add.hasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING ) ) {
                            return;
                        }
                        params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]          = this;
                        params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ]     = this.grid_cell_to_add;
                        params[ SHINKEN_GRID.CONST.PARAM.EVENT.ADD_DIRECTLY_TO_GRID ] = true;
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] = new SHINKEN.OBJECT.LastModification();
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].setModificationType( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.CREATE );
                        
                        this.grid_elements.doActionAfter( "add_new_widget__manually", params );
                        this.grid_cell_to_add = null;
                        this.resetActionInProgress();
                        this.getController().doActionAfter( "add_last_modification", params );
                        this.getController().doActionAfter( "confirm_add_new_widget_done", params );
                        return;
                    default:
                        if ( !this.overlayed_frame ) {
                            return; //HAPPENS WHEN DROP OUTSIDE THE GRID
                        }
                }
                switch ( this.overlayed_frame.getObjectClassName() ) {
                    case "SHINKEN.OBJECT.OverlayFrameMove":
                        this.doActionAfter( "mouse_up_on_grid_cell", { [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ]: this.selected_grid_cell.getContent( 0 ).getUUID(), [ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ]: params } );
                        return;
                    case "SHINKEN.OBJECT.OverlayFrameZoneSelection":
                        this.updateSelectedList( this.overlayed_frame.makeMouseUpAction( this.grid_elements ) );
                        this.resetActionInProgress();
                        return;
                    case "SHINKEN.OBJECT.GridCellResizer":
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] = new SHINKEN.OBJECT.LastModification();
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].setModificationType( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.RESIZE );
                        let _action_done = this.overlayed_frame.makeMouseUpAction( params );
                        this.computeOverlappingOfSelectedCells();
                        this.resetActionInProgress();
                        if ( _action_done ) {
                            this.getController().doActionAfter( "add_last_modification", params );
                        }
                        break;
                    case "SHINKEN.OBJECT.SpaceBoxDeletion":
                    case "SHINKEN.OBJECT.SpaceBoxCreation":
                        params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]          = this;
                        params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELLS_OBJECT ]    = this.grid_elements;
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] = new SHINKEN.OBJECT.LastModification();
                        params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].setModificationType( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.MOVE );
                        this.overlayed_frame.makeMouseUpAction( params );
                        this.resetActionInProgress();
                        this.getController().doActionAfter( "add_last_modification", params );
                        return;
                }
                //this.computeOverlappingOfSelectedCells();
                this.resetActionInProgress();
                break;
            
            case "mouse_move_on_grid_with_add_widget":
                DOM.BodyService.addOrRemoveClasses( true, "shinken-has-drag-in-progress-overlay-frame-move" );
                DOM.BodyService.addOrRemoveClasses( true, "shinken-has-drag-in-progress-overlay-frame" );
                SHINKEN.TOOLS.MOUSE.setLastMouseEvent( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ] );
                
                this.scrollWhenAtEdgeOfView( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ] );
                this.moveGridCellToAdd( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ], params[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] );
                break;
            
            case "mouse_up_on_grid_cell":
                if ( !this.overlayed_frame ) {
                    return;
                }
                this.updateSelectedList( [this.grid_elements.doActionAfter( event_name, params )] );
                switch ( this.overlayed_frame.getObjectClassName() ) {
                    case "SHINKEN.OBJECT.GridCellResizer":
                    case "SHINKEN.OBJECT.OverlayFrameZoneSelection":
                    case "SHINKEN.OBJECT.SpaceBoxDeletion":
                    case "SHINKEN.OBJECT.SpaceBoxCreation":
                        return this.doActionAfter( "mouse_up", params );
                }
                this.computeOverlappingOfSelectedCells();
                if ( this.selected_grid_cell.getContentUuidIfHasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.OVERLAPPING ).length ) {
                    this.selected_grid_cell.doActionAfterContentChildren( "apply_move_reset__manually", params );
                }
                else {
                    params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ] = new SHINKEN.OBJECT.LastModification();
                    params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].setModificationType( SHINKEN.OBJECT.CONST.LAST_MODIFICATION.HISTORY.MOVE );
                    this.selected_grid_cell.doActionAfterContentChildren( "apply_move__manually", params );
                    this.getController().doActionAfter( "add_last_modification", params );
                }
                this.resetActionInProgress();
                break;
        }
    },
    getLastModificationElement: function ( type_modification, params ) {
        let to_return;
        let data_last_modification;
        let element_modified = this;
        let previous         = null;
        let next             = null;
        switch ( type_modification ) {
            case SHINKEN.OBJECT.CONST.LAST_MODIFICATION.ACTION.EDIT_PARAMS:
                previous = this.previous_modication_data;
                next     = this.getDataForLastModification( params );
                break;
        }
        to_return                     = new SHINKEN.OBJECT.LastModificationElement( type_modification, element_modified, previous, next );
        this.previous_modication_data = null;
        return to_return;
    },
    initOverlayFrame          : function ( event_name, params ) {
        this.resetActionInProgress();
        switch ( event_name ) {
            case "mouse_down":
                switch ( params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.WIDGET_MODE__PHASE__OBJECT ].current_phase ) {
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_CREATE:
                        this.overlayed_frame = new SHINKEN.OBJECT.SpaceBoxCreation( this );
                        break;
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_DELETE:
                        this.overlayed_frame = new SHINKEN.OBJECT.SpaceBoxDeletion( this );
                        break;
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT:
                        this.overlayed_frame = new SHINKEN.OBJECT.OverlayFrameZoneSelection( this.tile_pixel_size );
                        break;
                }
                this.overlayed_frame.init( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].clientX, params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].clientY, params[ "dom_relative_position_container_2024_07_18" ] );
                this.overlayed_frame.computeHtml();
                this.addDomElement( this.overlayed_frame.getDomElement() );
        }
    },
    //********************************************  SELECTED GRID CELL  *****************************************************//
    updateSelectedList: function ( cell_array ) {
        if ( !cell_array ) {
            return;
        }
        if ( !this.selected_grid_cell ) {
            this.selected_grid_cell = new SHINKEN.OBJECT.ShinkenObjectContainer();
        }
        let current;
        for ( let i = 0, _size_i = cell_array.length; i < _size_i; i++ ) {
            current = cell_array[ i ];
            if ( current.isPhase( SHINKEN.OBJECT.CONST.PHASE.SELECTED ) ) {
                this.selected_grid_cell.add( current );
            }
            else {
                this.selected_grid_cell.removeContent( current.getUUID(), null, true );
            }
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setUUID          : function ( to_set ) {
        this.uuid = to_set || SHINKEN.TOOLS.STRING.buildUUID();
        this.addParamForEvents( SHINKEN_GRID.CONST.PARAM.EVENT.GRID_UUID, this.uuid );
    },
    getUUID          : function () {
        return this.uuid;
    },
    getController    : function () {
        return CONTROLLER.CommonUI;
    },
    addParamForEvents: function ( key, value ) {
        this.addParamForEventsCommon( key, value );
        if ( this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ] ) {
            this[ SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS ].addParamForEvents( key, value );
        }
    },
    //********************************************  COMPUTE  *****************************************************//
    computeMapping                   : function ( mapping ) {
        if ( this.grid_elements instanceof SHINKEN_GRID.Cells ) {
            this.grid_elements.computeMapping( mapping );
        }
    },
    computeOverlappingOfSelectedCells: function () {
        this.selected_grid_cell.getContents().forEach( cell => {
            this.grid_elements.computeOverlapping( cell );
        } );
    },
    computeSizes                     : function () {
        this.computeTileSize();
        this.computeFontSize();
        this.updateStyle();
        this.grid_elements.computeSizes( this );
    },
    computeTileSize                  : function () {
        this.tile_pixel_size = DOM.Service.getBoundingClientRect( this.getDomElement(), DOM.CONST.STYLE.WIDTH ) / this.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ) * 100 / this.zoom_percent;
    },
    computeContentWithChange         : function () {
        return this.grid_elements.computeContentWithChange();
    },
    computeCursorGridPosition        : function ( event ) {
        let _x             = event.clientX - DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.LEFT );
        let _y             = event.clientY - DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.TOP );
        let _on_one_widget = false;
        if ( !event.target.classList.contains( "shinken-grid" ) ) {
            let _dom_parent = DOM.Service.findParentElementWithClass( event.target, "shinken-grid-cell", 50 );
            if ( _dom_parent ) {
                _on_one_widget = true;
            }
        }
        this.mouse_position = {
            x            : Math.floor( _x / this.tile_pixel_size ),
            y            : Math.floor( _y / this.tile_pixel_size ),
            on_one_widget: _on_one_widget,
            is_out_grids : event.target.querySelector( ".shinken-grids" )
        };
    },
    //********************************************  POPUP DELETE GRID CELL  *****************************************************//
    updateComputeConfirmationPopupValidButton: function () {
        this.button_validate_deleted = new COMPONENT.ButtonWithCounter( "valid_popup__20240904", _( "confirmation_popup.delete_button", [DICTIONARY_COMMON_UI] ) );
        SHINKEN.OBJECT.ConfirmationPopup_V3.getInstance().setValidButton( this.button_validate_deleted );
    },
    buildHtmlTitleDeletePopup                : function () {
        return _( "confirmation_popup.deletable_content.grid.title", [DICTIONARY_COMMON_UI] );
    },
    buildHtmlDeleteConfirmationPopup         : function () {
        this.selected_grid_cell.sortContentByClassName();
        let to_return = DOM.Service.createElement( "div", { "class": "shinken-grid-delete-confirmation-popup shinken-user-select-none" } );
        let container = DOM.Service.addElementTo( DOM.Service.createElement( "div", { "class": "shinken-container" } ), to_return );
        let header    = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-layout-center-h-v shinken-layout-justify-between" } ), container );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-header shinken-type-cell" }, _( "confirmation_popup.deletable_content.grid.type_column", [DICTIONARY_COMMON_UI] ) ), header );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-header shinken-title-cell shinken-layout-expand-1" }, _( "confirmation_popup.deletable_content.grid.title_column", [DICTIONARY_COMMON_UI] ) ), header );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-header shinken-action-cell" } ), header );
        let _table_element_to_delete_body = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-container" } ), container );
        for ( let i = 0; i < this.selected_grid_cell.getSize(); i++ ) {
            DOM.Service.addElementTo( this.selected_grid_cell.getContent( i ).computeHtmlDeletePopup(), _table_element_to_delete_body );
            this.selected_grid_cell.getContent( i ).getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.DELETED ).setParent( this.button_validate_deleted.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ) );
        }
        return to_return;
    },
    //********************************************  ADDING CELL  *****************************************************//
    createGridCellToAdd: function ( type ) {
        this.grid_cell_to_add = this.grid_elements.getChildConstructor();
        this.grid_cell_to_add.setPhase( SHINKEN.OBJECT.CONST.PHASE.ADDING );
        this.grid_cell_to_add.setData( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X, { [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: "" } );
        this.grid_cell_to_add.setData( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y, { [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: "" } );
        this.grid_cell_to_add.setData( SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH, { [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: this.getDefaultValueForElementToAdd( type, SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ) } );
        this.grid_cell_to_add.setData( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT, { [ SHINKEN.OBJECT.CONST.PARAM.VALUE ]: this.getDefaultValueForElementToAdd( type, SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ) } );
        this.grid_cell_to_add.setData( SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT, this.getContentByTypeForElementToAdd( type ) );
        this.grid_cell_to_add.computeHtml( this, this.dom_parent_with_scroll, true );
        DOM.Service.addElementTo( this.grid_cell_to_add.getDomElement(), this.getDomElement() );
        this.grid_cell_to_add.last_modication_data = type;
    },
    moveGridCellToAdd  : function ( event, type ) {
        const mouse_event = event || SHINKEN.TOOLS.MOUSE.getLastMouseEvent();
        if ( !mouse_event ) {
            return;
        }
        this.computeCursorGridPosition( mouse_event );
        if ( this.mouse_position.is_out_grids ) {
            this.doActionAfter( "reset_grid_cell_to_add" );
            return;
        }
        if ( !this.grid_cell_to_add ) {
            this.createGridCellToAdd( type );
        }
        let position_x = Math.round( this.mouse_position.x - this.grid_cell_to_add[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ].getValue() / 2 );
        let position_y = Math.round( this.mouse_position.y - this.grid_cell_to_add[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].getValue() / 2 );
        
        position_x = Math.min( Math.max( position_x, 0 ), this.nb_tiles_in_width.getValue() - this.grid_cell_to_add[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ].getValue() );
        position_y = Math.min( Math.max( position_y, 0 ), this.nb_tiles_in_height.getValue() - this.grid_cell_to_add[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT ].getValue() );
        
        this.grid_cell_to_add[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X ].setUserValueAndValue( position_x );
        this.grid_cell_to_add[ SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y ].setUserValueAndValue( position_y );
        this.grid_cell_to_add.updateSize();
        this.grid_cell_to_add.computeSquare();
        this.grid_elements.computeOverlapping( this.grid_cell_to_add );
    },
    //********************************************  EDITION CELLS OVER      ***********************************//
    initDomElementHighlightCell: function () {
        if ( this.dom_element_highlight_cell ) {
            return;
        }
        this.dom_element_highlight_cell = DOM.Service.createElement( "div", {
            class         : "shinken-grid-highlight-cell-container",
            "shi-tip-type": SHINKEN_TOOLTIP.TYPE.OFF_WHITE_ON_BLACK
        } );
        DOM.Service.addElementTo( this.dom_element_highlight_cell, this.getDomElement() );
    },
    updateHighLightedTile      : function ( force_hidden ) {
        if ( !this.mouse_position ) {
            return;
        }
        if ( this.mouse_position.is_out_grids ) {
            force_hidden = true;
        }
        this.initDomElementHighlightCell();
        if ( force_hidden ) {
            this.dom_element_highlight_cell.classList.add( "shinken-hidden" );
            SHINKEN_TOOLTIP.hideTooltip();
            return;
        }
        const _styles                     = {};
        _styles[ DOM.CONST.STYLE.TOP ]    = this.tile_pixel_size * this.mouse_position.y + DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.TOP );
        _styles[ DOM.CONST.STYLE.LEFT ]   = this.tile_pixel_size * this.mouse_position.x + DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.LEFT );
        _styles[ DOM.CONST.STYLE.HEIGHT ] = this.tile_pixel_size;
        _styles[ DOM.CONST.STYLE.WIDTH ]  = this.tile_pixel_size;
        
        
        DOM.Service.setStyles( this.dom_element_highlight_cell, _styles );
        let _tooltip_html = (this.mouse_position.on_one_widget) ? _( 'grid.mode_edition.form_visual.tooltip_on_hover_widget', [DICTIONARY_COMMON_UI] ) + " <br>" : '';
        _tooltip_html += "x = " + this.mouse_position.x + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; & &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;y = " + this.mouse_position.y;
        
        DOM.Service.addAttribute( this.dom_element_highlight_cell, 'shi-tip-html', _tooltip_html );
        this.dom_element_highlight_cell.classList.remove( 'shinken-hidden' );
        SHINKEN_TOOLTIP.updateTooltip( this.dom_element_highlight_cell );
        
    },
    //********************************************  HTML   **************************************************//
    initGridDomElement             : function () {
        this.setDomElement( DOM.Service.createElement( "div", {
            id                     : "id-shinken-" + this.uuid,
            class                  : this.getClass(),
            style                  : "font-size:" + this.font_size + "px;",
            "data-visibility-state": this.visibility_state || ""
        } ) );
        if ( __has_edit_mode__ ) {
            DOM.Service.addClasses( this.dom_element, "shinken-parent-mouse-move-listener shinken-parent-mouse-leave-listener" );
        }
        this.computeTileSize();
    },
    computeHtml                    : function ( dom_parent_with_scroll ) {
        this.dom_parent_with_scroll = dom_parent_with_scroll;
        let to_return               = !this.getDomElement();
        if ( to_return ) {
            this.initGridDomElement();
            DOM.Service.setDataSet( this.dom_element, "gridUuid", this.uuid );
        }
        this.grid_elements.computeHtml( this, dom_parent_with_scroll );
        this.addCounterTargetDomElement( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED, this.getDomElement() );
        this.doActionAfter( "compute_html_done" );
        return to_return;
    },
    updateStyle                    : function () {
        DOM.Service.setStyles( this.dom_element, this.getComputedStyle() );
    },
    getComputedStyle               : function () {
        const _nb_tiles                         = this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) ? this.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ) : this.max_nb_tiles;
        const _to_return                        = {};
        _to_return[ DOM.CONST.STYLE.HEIGHT ]    = this.tile_pixel_size * _nb_tiles;
        _to_return[ DOM.CONST.STYLE.FONT_SIZE ] = this.font_size;
        return _to_return;
    },
    computeFontSize                : function () {
        this.font_size = Math.round( DOM.Service.getBoundingClientRect( this.dom_element, DOM.CONST.STYLE.WIDTH ) / 85.7 );
    },
    resetActionInProgress          : function () {
        this.updateHighLightedTile( true );
        DOM.BodyService.addOrRemoveClasses( false, "shinken-has-drag-in-progress-overlay-frame-move" );
        DOM.BodyService.addOrRemoveClasses( false, "shinken-has-drag-in-progress-overlay-frame" );
        if ( this.grid_cell_to_add ) {
            this.grid_cell_to_add.resetHTML();
            this.grid_cell_to_add = null;
        }
        if ( !this.overlayed_frame ) {
            return;
        }
        this.overlayed_frame.addOrRemoveDragInProgress( false );
        this.overlayed_frame.resetZoneToRemove();
        this.overlayed_frame.remove();
        this.overlayed_frame = null;
    },
    getDefaultValueForElementToAdd : function ( type, key ) {
        switch ( type ) {
            case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.ADD_WIDGET.WEATHER_ADD:
                return this.getDefaultValueFor( WIDGET.CONST.TYPE.WEATHER, key );
            case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.ADD_WIDGET.SEPARATOR_ADD:
                return this.getDefaultValueFor( WIDGET.CONST.TYPE.SEPARATOR, key );
        }
    },
    getLayoutFromTypeWidget        : function ( type_widget ) {
        return this[ SHINKEN_GRID.CONST.PARAM.GRID.LAYOUTS ][ type_widget + "_layout" ];
    },
    getDefaultCfgValueFor          : function ( type_widget, key ) {
        let dict = this.getLayoutFromTypeWidget( type_widget ).getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_DEFAULT_AND_CFG );
        return SHINKEN.TOOLS.DICT.getValueWithComposedKey( dict, key ).cfg_value;
    },
    getDefaultValueFor             : function ( type_widget, key ) {
        let dict      = this.getLayoutFromTypeWidget( type_widget ).getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_DEFAULT );
        let to_return = SHINKEN.TOOLS.DICT.getValueWithComposedKey( dict, key ).value;
        if ( key === SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ) {
            to_return = this.getComputedWidth( to_return );
        }
        return to_return;
    },
    getComputedWidth               : function ( width_to_compute ) {
        return width_to_compute === SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL ? this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ].getValue() : Math.min( width_to_compute, this.nb_tiles_in_width.getValue() );
    },
    getContentByTypeForElementToAdd: function ( type ) {
        let to_return;
        switch ( type ) {
            case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.ADD_WIDGET.WEATHER_ADD:
                to_return = {
                    [ WIDGET.CONST.PARAM.TYPE._KEY ]                  : WIDGET.CONST.TYPE.WEATHER,
                    [ WIDGET.CONST.PARAM.ITEM._KEY ]                  : {
                        [ WIDGET.CONST.PARAM.ITEM.TYPE._KEY ]: "",
                        [ WIDGET.CONST.PARAM.ITEM.UUID._KEY ]: "",
                        [ WIDGET.CONST.PARAM.ITEM.NAME._KEY ]: ""
                    },
                    [ WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT._KEY ]: this[ SHINKEN_GRID.CONST.PARAM.GRID.LAYOUTS ][ WEATHER.Grid.CONST.PARAM.DEFAULT_CONFIGURATION.WEATHER_WIDGET_LAYOUT._KEY ].content[ WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT._KEY ].getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_FORCE_DEFAULT )
                };
                break;
            case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.ADD_WIDGET.SEPARATOR_ADD:
                to_return                                                                                                                                                                                                                                                                                                                  = {
                    [ WIDGET.CONST.PARAM.TYPE._KEY ]                    : WIDGET.CONST.TYPE.SEPARATOR,
                    [ WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT._KEY ]: this[ SHINKEN_GRID.CONST.PARAM.GRID.LAYOUTS ][ WEATHER.Grid.CONST.PARAM.DEFAULT_CONFIGURATION.SEPARATOR_WIDGET_LAYOUT._KEY ].content[ WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT._KEY ].getDataForJson( SHINKEN.OBJECT.JSON_EDITOR.FORMAT_DATA.VALUE_AND_FORCE_DEFAULT )
                };
                to_return[ WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT._KEY ][ WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY._KEY ][ WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA._KEY ][ WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL._KEY ] = _( "edit_mode.widget.new_widget_separator" );
                break;
        }
        return SHINKEN.OBJECT.DefaultConfigurationWithOwnPropertyGridPage.prototype.parseDictToDict_withValueKey( to_return );
    },
    getDefaultValueOfGrid          : function () {
    },
    //********************************************  UPDATE DATA   **************************************************//
    setData                              : function ( key, value ) {
        switch ( key ) {
            case SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y:
            case SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X:
            case SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN:
            case SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX:
            case SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT:
            case SHINKEN_GRID.CONST.PARAM.GRID.TYPE:
                this.setDataKey( key, value );
                break;
            case SHINKEN_GRID.CONST.PARAM.GRID.GRID_ELEMENTS:
                this[ key ] = this.getChildConstructor( value );
                this[ key ].setCountersParent( this );
                this[ key ].getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL ).setParent( this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WIDGET_TOTAL ) );
                this.addSynchronizedPhase( this[ key ] );
                this.own_children_keys.push( key );
                this[ key ].addParamsForEvents( this.getParamForEvents() );
                break;
            case SHINKEN_GRID.CONST.PARAM.GRID.LAYOUTS:
                this[ key ] = new SHINKEN.OBJECT.DefaultConfigurationGridLayouts( value );
                this.own_children_keys.push( key );
                break;
            default:
                this.setDataAsUnknownProperty( key, value );
                break;
        }
    },
    updateContentData                    : function ( data ) {
        this.grid_elements.updateContentData( data );
    },
    getChildConstructor                  : function ( data ) {
        return new SHINKEN_GRID.Cells( data );
    },
    actionCurrentlyInProgress            : function () {
        return this.actionOverlayFrameCurrentlyInProgress() || this.grid_cell_to_add;
    },
    actionOverlayFrameCurrentlyInProgress: function () {
        return !!this.overlayed_frame;
    },
    //********************************************  PHASE  *****************************************************//
    callbackForPhase: function () {
        if ( this.getCurrentPhase() !== this.getPreviousPhase() ) {
            this.updateStyle();
        }
        if ( this.getCurrentPhase() === SHINKEN.OBJECT.CONST.PHASE.EDITING ) {
            this.selected_grid_cell = new SHINKEN.OBJECT.ShinkenObjectContainer();
        }
    },
    //********************************************  SCROLLING  **************************************************//
    scrollWhenAtEdgeOfView: function ( mouse_event ) {
        let dom_scrollable_container      = DOM.Service.findParentElementWithClass( this.getDomElement(), "shinken-grid-container", 50 );
        const mouse_position_y_in_grid    = this.parseRelativePixelY( mouse_event, dom_scrollable_container );
        const max_tile_in_height_in_pixel = this.parseGridToPixel_y( this.nb_tiles_in_height.getValue() );
        const position_y_visible          = this.getPositionYVisible( dom_scrollable_container );
        let scroll_height                 = 0;
        const delta                       = 20;
        
        if ( position_y_visible.max - mouse_position_y_in_grid < delta && mouse_position_y_in_grid + delta < max_tile_in_height_in_pixel ) {
            scroll_height = delta;
        }
        else if ( mouse_position_y_in_grid - position_y_visible.min < delta && mouse_position_y_in_grid - delta > 0 ) {
            scroll_height = -delta;
        }
        if ( scroll_height !== 0 ) {
            DOM.ScrollService.scrollVertically( dom_scrollable_container, scroll_height );
        }
    },
    parseGridToPixel_y    : function ( pos_grid ) {
        return pos_grid * this.tile_pixel_size;
    },
    parseRelativePixelY   : function ( mouse_event, dom_scrollable_container ) {
        return mouse_event.clientY - dom_scrollable_container.getBoundingClientRect().top + dom_scrollable_container.scrollTop;
    },
    getPositionYVisible   : function ( dom_scrollable_container ) {
        return {
            max: dom_scrollable_container.scrollTop + dom_scrollable_container.getBoundingClientRect().height,
            min: dom_scrollable_container.scrollTop
        };
    },
    applyResizeOfGrid     : function ( resize_height ) {
        if ( resize_height && resize_height !== 0 ) {
            const new_grid_height = Math.max( this.nb_tiles_in_height.getCfgValue(), this.nb_tiles_in_height.getValue() + resize_height );
            this.nb_tiles_in_height.setUserValueAndValue( new_grid_height );
            this.getController().doActionAfter( "change_grid_size_in_json", { new_grid_height_value: new_grid_height } );
            this.grid_elements.doActionAfter( "update_nb_tiles_in_height", { new_nb_tiles_in_height: new_grid_height } );
            this.updateStyle();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grid, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grid, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grid, SHINKEN.OBJECT.ConfirmationPopupInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Grid, SHINKEN.OBJECT.EditableElementInterface );
