//priority 1048
//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.SeparatorWidgetFormInterface = function () {
};

SHINKEN.OBJECT.SeparatorWidgetFormInterface.prototype = {
    initSeparatorWidgetDefault: function ( user_prefs ) {
        let widget_cf = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderFromData_V3( SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.SEPARATOR._KEY, _( "form.collapse_folder.label." + SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.SEPARATOR._KEY ) ), true );
        if ( !user_prefs || !user_prefs.getValueByKey( [widget_cf.getUUID(), SHINKEN.OBJECT.COLLAPSE.PARAM.IS_OPEN] ) ) {
            widget_cf.addClass( "shinken-close" );
        }
        
        let current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetSeparator__sizes(), widget_cf, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetSeparator__content(), widget_cf, true, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetSeparator__leftArea(), widget_cf, true, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetSeparator__rightArea(), widget_cf, true, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetSeparator__titleArea(), widget_cf, true, true );
        current_cf.addClass( "shinken-collapse-disabled" );
    },
    // ************************************* COLLAPSE FOLDERS *******************************************//
    getCollapseFolder__widgetSeparator__sizes    : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.DEFAULTFORM.WIDGET.COLLAPSE_FOLDER.DIMENSION_AREA._KEY, _( "grid.mode_edition.form_widget.cf_common.cf_size.title", [DICTIONARY_COMMON_UI] ) );
        this.addSpecificToChild( this.getProperty__widgetSeparator__width(), to_return );
        this.addSpecificToChild( this.getProperty__widgetSeparator__height(), to_return );
        return to_return;
    },
    getCollapseFolder__widgetSeparator__content  : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.AREAS._KEY, _( "grid.mode_edition.form_widget.separator_widget.cf_area.title", [DICTIONARY_COMMON_UI] ) );
        this.addSpecificToChild( this.getProperty__widgetSeparator__displayLeftArea(), to_return );
        this.addSpecificToChild( this.getProperty__widgetSeparator__displayRightArea(), to_return );
        return to_return;
    },
    getCollapseFolder__widgetSeparator__leftArea : function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.LEFT_AREA._KEY, _( "grid.mode_edition.form_widget.separator_widget.cf_left_area.title", [DICTIONARY_COMMON_UI] ) );
        this.addSpecificToChild( this.getProperty__widgetSeparator__widthLeftArea(), to_return );
        return to_return;
    },
    getCollapseFolder__widgetSeparator__rightArea: function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.RIGHT_AREA._KEY, _( "grid.mode_edition.form_widget.separator_widget.cf_right_area.title", [DICTIONARY_COMMON_UI] ) );
        this.addSpecificToChild( this.getProperty__widgetSeparator__widthRightArea(), to_return );
        return to_return;
    },
    getCollapseFolder__widgetSeparator__titleArea: function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TITLE_AREA._KEY, _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.title", [DICTIONARY_COMMON_UI] ) );
        this.addSpecificToChild( this.getProperty__widgetSeparator__align(), to_return );
        this.addSpecificToChild( this.getProperty__widgetSeparator__color(), to_return );
        this.addSpecificToChild( this.getProperty__widgetSeparator__zoom(), to_return );
        return to_return;
    },
    // ******************************************** PROPERTIES ***********************************************//
    getProperty__widgetSeparator__label           : function () {
        const to_return = new PROPERTY.StringInputFromData_V3( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.LABEL.COMPOSED_KEY, "", _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.label._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.label.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
    },
    getProperty__widgetSeparator__displayLeftArea : function () {
        return new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.DISPLAYED.COMPOSED_KEY, this.getConfigurationForSeparatorPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.DISPLAYED ), _( "grid.mode_edition.form_widget.separator_widget.cf_left_area.properties.displayed._key", [DICTIONARY_COMMON_UI] ) );
    },
    getProperty__widgetSeparator__displayRightArea: function () {
        return new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.DISPLAYED.COMPOSED_KEY, this.getConfigurationForSeparatorPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.DISPLAYED ), _( "grid.mode_edition.form_widget.separator_widget.cf_right_area.properties.displayed._key", [DICTIONARY_COMMON_UI] ) );
    },
    
    getProperty__widgetSeparator__widthLeftArea : function () {
        const to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.WIDTH_PERCENT.COMPOSED_KEY, this.getConfigurationForSeparatorPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.WIDTH_PERCENT ), _( "grid.mode_edition.form_widget.separator_widget.cf_left_area.properties.width_percent._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.separator_widget.cf_left_area.properties.width_percent.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
    },
    getProperty__widgetSeparator__widthRightArea: function () {
        const to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.WIDTH_PERCENT.COMPOSED_KEY, this.getConfigurationForSeparatorPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA.WIDTH_PERCENT ), _( "grid.mode_edition.form_widget.separator_widget.cf_right_area.properties.width_percent._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.separator_widget.cf_right_area.properties.width_percent.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
    },
    getProperty__widgetSeparator__align         : function () {
        return new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN.COMPOSED_KEY, this.getConfigurationForSeparatorPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN ), _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.text_align._key", [DICTIONARY_COMMON_UI] ) );
    },
    getProperty__widgetSeparator__color         : function () {
        const to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR.COMPOSED_KEY, this.getConfigurationForSeparatorPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR ), _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.text_color._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.text_color.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
    },
    getProperty__widgetSeparator__zoom          : function () {
        const to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT.COMPOSED_KEY, this.getConfigurationForSeparatorPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT ), _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.font_zoom_percent._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.font_zoom_percent.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
    },
    getProperty__widgetSeparator__width         : function () {
        const to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.WIDTH.COMPOSED_KEY, this.getConfigurationForSeparatorPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.WIDTH ), _( "grid.mode_edition.form_widget.cf_common.cf_size.width._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.cf_common.cf_size.width.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
    },
    getProperty__widgetSeparator__height        : function () {
        const to_return = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.HEIGHT.COMPOSED_KEY, this.getConfigurationForSeparatorPropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.HEIGHT ), _( "grid.mode_edition.form_widget.cf_common.cf_size.height._key", [DICTIONARY_COMMON_UI] ) );
        to_return.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.cf_common.cf_size.height.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return to_return;
        
    },
    
    // ************************************* GETTER *****************************************************
    getConfigurationForSeparatorPropertiesRadioList: function ( property_structure ) {
        const to_return = [];
        let dict_key;
        switch ( property_structure._KEY ) {
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.WIDTH._KEY:
                dict_key = "grid.mode_edition.form_widget.separator_widget.cf_sizes.properties.width.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA.DISPLAYED._KEY:
                dict_key = "grid.mode_edition.form_widget.separator_widget.cf_left_area.properties.displayed.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN._KEY:
                dict_key = "grid.mode_edition.form_widget.separator_widget.cf_title_area.properties.text_align.radio";
                break;
        }
        return this.parseConfigurationToArray( property_structure.OPTIONS, dict_key, property_structure, WIDGET.CONST.TYPE.SEPARATOR );
    }
};