//priority 1048
//__lib__ lib_common_V02_01
"use strict";

SHINKEN.OBJECT.TitleWidgetFormInterface = function () {
};

SHINKEN.OBJECT.TitleWidgetFormInterface.prototype = {
    initTitleWidgetDefault: function ( user_prefs ) {
        let widget_cf = this.addSpecific( new SHINKEN.OBJECT.CollapseFolderFromData_V3( SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.TITLE._KEY, _( "form.collapse_folder.label." + SHINKEN_PAGE.DEFAULTFORM.COLLAPSE_FOLDER.TITLE._KEY ) ), true );
        if ( !user_prefs || !user_prefs.getValueByKey( [widget_cf.getUUID(), SHINKEN.OBJECT.COLLAPSE.PARAM.IS_OPEN] ) ) {
            widget_cf.addClass( "shinken-close" );
        }
        let current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetTitle__sizes(), widget_cf, true );
        current_cf.addClass( "shinken-collapse-disabled" );
        current_cf = this.addSpecificToChild( this.getCollapseFolder__widgetTitle__titleArea(), widget_cf, true, true );
        current_cf.addClass( "shinken-collapse-disabled" );
    },
    // ************************************* COLLAPSE FOLDERS *******************************************//
    getCollapseFolder__widgetTitle__sizes: function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.DEFAULTFORM.WIDGET.COLLAPSE_FOLDER.DIMENSION_AREA._KEY, _( "grid.mode_edition.form_widget.cf_common.cf_size.title", [DICTIONARY_COMMON_UI] ) );
        this.addSpecificToChild( this.getProperty__widgetTitle__width(), to_return );
        this.addSpecificToChild( this.getProperty__widgetTitle__height(), to_return );
        return to_return;
    },
    // ******************************************** PROPERTIES ***********************************************//
    getProperty__widgetTitle__color          : function () {
        let _color = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR.COMPOSED_KEY, this.getConfigurationForTitlePropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_COLOR ), _( "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.text_color._key", [DICTIONARY_COMMON_UI] ) );
        _color.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.text_color.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return _color;
    },
    getProperty__widgetTitle__align          : function () {
        return new PROPERTY.CheckBoxRadioPropFromData_V3( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN.COMPOSED_KEY, this.getConfigurationForTitlePropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN ), _( "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.text_align._key", [DICTIONARY_COMMON_UI] ) );
    },
    getProperty__widgetTitle__fontZoom       : function () {
        let _font_zoom = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT.COMPOSED_KEY, this.getConfigurationForTitlePropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.FONT_ZOOM_PERCENT ), _( "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.font_zoom_percent._key", [DICTIONARY_COMMON_UI] ) );
        _font_zoom.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.font_zoom_percent.radio.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return _font_zoom;
    },
    getProperty__widgetTitle__width          : function () {
        const property = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.TITLE.WIDTH.COMPOSED_KEY, this.getConfigurationForTitlePropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.TITLE.WIDTH ), _( "grid.mode_edition.form_widget.cf_common.cf_size.width._key", [DICTIONARY_COMMON_UI] ) );
        property.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.cf_common.cf_size.width.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return property;
    },
    getProperty__widgetTitle__height         : function () {
        const property = new PROPERTY.CheckBoxRadioProp__WithStringInput__FromData( WIDGET.CONST.PARAM.LAYOUTS.TITLE.HEIGHT.COMPOSED_KEY, this.getConfigurationForTitlePropertiesRadioList( WIDGET.CONST.PARAM.LAYOUTS.TITLE.HEIGHT ), _( "grid.mode_edition.form_widget.cf_common.cf_size.height._key", [DICTIONARY_COMMON_UI] ) );
        property.doActionAfter( "set_placeholder_input_V3", { [ COMPONENT.CONST.PARAM.TEXT_PLACEHOLDER_INPUT ]: _( "grid.mode_edition.form_widget.cf_common.cf_size.height.message_placeholder", [DICTIONARY_COMMON_UI] ) } );
        return property;
        
    },
    getCollapseFolder__widgetTitle__titleArea: function () {
        const to_return = new SHINKEN.OBJECT.CollapseFolderForProperties( SHINKEN_PAGE.VISUALFORM.WIDGET.COLLAPSE_FOLDER.TITLE_AREA._KEY, _( "grid.mode_edition.form_widget.separator_widget.cf_title_area.title", [DICTIONARY_COMMON_UI] ) );
        this.addSpecificToChild( this.getProperty__widgetTitle__align(), to_return );
        this.addSpecificToChild( this.getProperty__widgetTitle__color(), to_return );
        this.addSpecificToChild( this.getProperty__widgetTitle__fontZoom(), to_return );
        return to_return;
    },
    // ************************************* GETTER *****************************************************
    getConfigurationForTitlePropertiesRadioList: function ( property_structure ) {
        let to_return = [];
        let dict_key;
        switch ( property_structure._KEY ) {
            case WIDGET.CONST.PARAM.LAYOUTS.TITLE.WIDTH._KEY:
                dict_key = "grid.mode_edition.form_widget.title_widget.cf_sizes.properties.width.radio";
                break;
            case WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA.TEXT_ALIGN._KEY:
                dict_key = "grid.mode_edition.form_widget.title_widget.cf_title_area.properties.text_align.radio";
                break;
        }
        return this.parseConfigurationToArray( property_structure.OPTIONS, dict_key, property_structure, WIDGET.CONST.TYPE.TITLE );
    }
};
