//__lib__ lib_common_V02_01
"use strict";
SHINKEN.OBJECT.GridPageEdit           = function ( uuid ) {
    this.__class_name__ = "SHINKEN.OBJECT.GridPageEdit";
    this.init( uuid );
};
SHINKEN.OBJECT.GridPageEdit.prototype = {
    //********************************************  INIT  *****************************************************//
    init                  : function ( uuid ) {
        this.initCommon( uuid );
        this.initEditMode();
    },
    initEditMode          : function () {
        this.timeout_before_show_tooltip_preview_button = null;
        this.window_group_edition                       = null;
        this.button_back_to_previous_preview            = null;
        this.synchronized_phase_with_widget_mode        = new SHINKEN.OBJECT.Phase();
        this.grid_page_history_view                     = this.getViewHistoryInstance();
        this.slide_panel_edition                        = new SHINKEN.OBJECT.GridPageEditionSlidePanel();
        this.slide_panel_problems                       = new SHINKEN.OBJECT.SlidePanelProblem();
        this.window_group_edition                       = new SHINKEN.OBJECT.GridPageWindowGroupEditPart();
        this.user_pref                                  = new SHINKEN.UserPrefs_V3();
        this.initCounterCommon();
        this.initButtonsPositions();
        this.initLastModifications();
        this.initButtonsEdition();
    },
    getViewHistoryInstance: function () {
        throw new TypeError( "getViewHistoryInstance in SHINKEN.OBJECT.GridPageEdit have to be override" );
    },
    initCounterCommon     : function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WIDGET_TOTAL );
    },
    initPhaseEditing      : function () {
        if ( !this.window_group_edition.getDomElement() ) {
            let window_container = document.querySelector( ".shinken-container-visual-or-json" );
            this.window_group_edition.setPhaseDomElement( this.dom_element, "tabEditionName" );
            this.window_group_edition.computeHtml();
            DOM.Service.addElementTo( this.window_group_edition.getDomElement(), window_container );
            this.window_group_edition.computeHtmlTargets( window_container );
            this.window_group_edition.computeHtmlSpecific( window_container );
        }
    },
    initButtonsEdition    : function () {
        this.button_enter_edit_mode = new COMPONENT.ButtonFromData_V3( "enter_in_edit_mode", _( 'edit_mode.buttons.edit_mode' ) );
        this.button_enter_edit_mode.computeHtml();
        DOM.Service.addElementToAfterEmpty( this.button_enter_edit_mode.getDomElement(), document.querySelector( ".shinken-weather-edit-mode-button-cell .shinken-button-container" ) );
        //DOM.Service.addElementTo( this.button_enter_edit_mode.getDomElement(), document.querySelector( ".shinken-buttons-container" ) );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    clickOnButton              : function ( event, event_name, param ) {
        this.clickOnButtonCommon( event, event_name, param );
    },
    clickOnButtonCommon        : function ( event, event_name, param ) {
        switch ( event_name ) {
            case "toggle-display-of-widgets-with-issues":
                this.dom_element.classList.contains( "shinken-hide-widgets-with-issues" ) ? this.doActionAfter( "show-widgets-with-issues" ) : this.doActionAfter( "hide-widgets-with-issues" );
                break;
            case "enter_in_edit_mode":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_EDITING );
                break;
            case "enter_in_save_mode":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.SAVING );
                break;
            case "publish_view":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.PUBLISHING );
                break;
            case "cancel_edit_mode_grid_page":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CANCEL );
                break;
            case "preview_grid_page":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_PREVIEWING );
                break;
        }
    },
    askOnKeyUpJson             : function ( event ) {
        if ( this.timeout_onkeyup ) {
            clearTimeout( this.timeout_onkeyup );
        }
        this.timeout_onkeyup = setTimeout( () => {
            this.onKeyUpJson( event );
            this.timeout_onkeyup = null;
        }, 200 );
    },
    onKeyUpJson                : function ( event, key_code ) {
        if ( event.target.id !== "id-shinken-output-json" ) {
            return;
        }
        key_code = key_code || event.keyCode;
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.SHIFT:
            case SHINKEN.CONST.KEY_CODE.CTRL:
            case SHINKEN.CONST.KEY_CODE.ALT:
            case SHINKEN.CONST.KEY_CODE.PAUSE:
            case SHINKEN.CONST.KEY_CODE.CAPS_LOCK:
            case SHINKEN.CONST.KEY_CODE.ESCAPE:
            case SHINKEN.CONST.KEY_CODE.PAGE_UP:
            case SHINKEN.CONST.KEY_CODE.PAGE_DOWN:
            case SHINKEN.CONST.KEY_CODE.END:
            case SHINKEN.CONST.KEY_CODE.HOME:
            case SHINKEN.CONST.KEY_CODE.LEFT:
            case SHINKEN.CONST.KEY_CODE.RIGHT:
            case SHINKEN.CONST.KEY_CODE.UP:
            case SHINKEN.CONST.KEY_CODE.DOWN:
            case SHINKEN.CONST.KEY_CODE.F1:
                return;
            default:
                break;
        }
        this.setEditionJsonManually( true );
        if ( !this.json_form.isValid() ) {
            this.closeSavingPopUp();
            this.computeJsonForm();
        }
        else {
            SHINKEN_TOOLTIP.hideTooltip();
            this.json_form.askComputeLineNumber( 200 );
            this.json_editor.cleanHtmlAfterEdition();
        }
        if ( this.timeout_before_show_tooltip_preview_button ) {
            return;
        }
        setTimeout( () => {
            this.timeout_before_show_tooltip_preview_button = setTimeout( () => {
                this.timeout_before_show_tooltip_preview_button = null;
            }, 10000 );
            SHINKEN_TOOLTIP.showTooltip( document.querySelector( ".shinken-button[data-name='preview_grid_page']" ) );
        }, 500 );
    },
    onPasteAfterAction         : function ( text_pasted ) {
        this.setEditionJsonManually( true );
        setTimeout( function () {
            SHINKEN_TOOLTIP.showTooltip( document.querySelector( ".shinken-button[data-name='preview_grid_page']" ) );
        }, 200 );
    },
    copyJsonCallbackJSONInvalid: function ( status, dom_button ) {
        const _text  = status ? _( "copy_service.copySuccess", [DICTIONARY_COMMON_UI] ) : _( "copy_service.copyFail", [DICTIONARY_COMMON_UI] );
        const _state = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_FAILED;
        SHINKEN.TOOLS.NOTIFICATION.addNotification( _text, _state, dom_button, SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.SPECIFIC_COPY_GRID_PAGE_JSON, 2000 );
    },
    // *************************************** DO ACTION AFTER **************************************
    doActionAfter              : function ( event_name, params ) {
        this.doActionAfterCommon( event_name, params );
    },
    doActionAfterCommon        : function ( event_name, params ) {
        switch ( event_name ) {
            case "default__param__configured__from_form":
            case "value__param__configured__from_form":
            case "change__shinken_element__from_form":
                params[ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ] = this.getController();
                if ( params[ SHINKEN.OBJECT.FORMSET.PARAM.IS_VALID ] ) {
                    this.content.doActionAfter( event_name, params );
                }
                this.doActionAfter( "add_last_modification", params );
                break;
            case "change_radio_mode_done":
                this.doActionAfter( "show-widgets-with-issues" );
                this.content.doActionAfter( "reset_action_in_progress" );
                break;
            case "back_to_previous_preview":
                this.json_editor = null;
                this.closeSavingPopUp();
                this.getController().askShowLoadingPage();
                this.updateObject( this._preview_historics.getLastValid().getData(), true );
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASKING_SHOW_FORM );
                this.doActionAfter( "previous_button_status_change" );
                break;
            case "slide_panel__size__has_changed":
                params [ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ] = this;
                this.slide_panel_edition.doActionAfter( event_name, params );
                this.window_group_edition.doActionAfter( event_name, params );
                this.slide_panel_problems.doActionAfter( event_name, params );
                this.doActionAfterInForm( event_name, params );
                if ( params[ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.DRAG_N_DROP ] ) {
                    this.askComputeSizes( params );
                    return;
                }
                this.computeSizes( params );
                break;
            case "slide-panel-restore-structure-done":
                this.computeSizes( params );
                break;
            case "grid_cell_has_been_deleted":
            case "clean_widget_with_problem":
                this.slide_panel_problems.doActionAfter( "clean_widget_with_problem", params );
                break;
            case "update_style_dom_element__without_buttons__done":
            case "add_object__with_problems__from_user_action":
            case "add_object_with_problems__to__window_problem":
            case "before__update_object__grid_page":
                this.slide_panel_problems.doActionAfter( event_name, params );
                break;
            case "click_on_selector_V3":
            case "click_on_item_selector_V3":
            case "click_on_button_V3":
                if ( params[ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.NAME ] ) {
                    params [ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ] = this;
                    switch ( params[ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.NAME ] ) {
                        case SHINKEN_PAGE.CONST.SLIDE_PANEL.PROBLEMS.NAME:
                            this.slide_panel_problems.doActionAfter( event_name, params );
                            break;
                        case SHINKEN_PAGE.CONST.SLIDE_PANEL.EDITION.NAME:
                            this.slide_panel_edition.doActionAfter( event_name, params );
                            break;
                    }
                }
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "copy_to_clipboard":
                        if ( params[ SHINKEN.OBJECT.JSON_EDITOR.PARAM.JSON_OBJECT ] ) {
                            this.computeJsonForm();
                            this.json_form.doActionAfter( event_name, params );
                        }
                        if ( params[ SHINKEN.OBJECT.VIEW_HISTORY.PARAM.NAME ] === this.grid_page_history_view.getName() ) {
                            return this.grid_page_history_view.doActionAfter( event_name, params );
                        }
                        break;
                    case "enter_in_edit_mode":
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_EDITING );
                        break;
                    case "external_links_weather":
                        this[ WEATHER.CONST.PARAM.PAGE.EXTERNAL_LINKS ].doActionAfter( event_name, params );
                        break;
                    default:
                        if ( params[ WINDOW_V2.CONST.PARAM.WINDOW_GROUP_NAME ] ) {
                            const _parent_window = MANAGER.__instance_window_distributor.findParentWindow( params[ WINDOW_V2.CONST.PARAM.WINDOW_GROUP_NAME ] );
                            return _parent_window.doActionAfter( event_name, params );
                        }
                        if ( params[ SHINKEN.OBJECT.VIEW_HISTORY.PARAM.NAME ] === this.grid_page_history_view.getName() ) {
                            return this.grid_page_history_view.doActionAfter( event_name, params );
                        }
                        if ( params[ SHINKEN.OBJECT.JSON_EDITOR.PARAM.JSON_OBJECT ] ) {
                            return this.doActionAfter( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ], params );
                        }
                        this.content.doActionAfter( event_name, params );
                        break;
                }
                break;
            case "on_click_2024_07_31":
                this.notifications_of_change.doActionAfter( "click_done", params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ] );
                this.doActionAfterInForm( event_name, params );
                switch ( this.synchronized_phase_with_widget_mode.current_phase ) {
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_CREATE:
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_DELETE:
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.SELECT_WIDGET.SELECT_BY_ZONE:
                        this.doActionAfter( "mouse_up", params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ] );
                        break;
                }
                break;
            case "click_on_button":
                switch ( params[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "preview_grid_page":
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_PREVIEWING );
                        break;
                }
                break;
            case "on_key_down":
                if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) ) {
                    return;
                }
                this.doActionAfterInForm( event_name, params );
                break;
            case "on_key_up":
                params[ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ]             = this.getController();
                params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.WIDGET_MODE__PHASE__OBJECT ] = this.synchronized_phase_with_widget_mode;
                this.doActionAfter_keyUp( event_name, params );
                break;
            case "confirm_add_new_widget_done":
                this.form__visual_mode.doActionAfter( "change_radio_mode", {
                    [ SHINKEN.OBJECT.RADIOMODE.PARAM.PARENT_OBJECT ]: SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES._KEY,
                    [ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ]         : SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT
                } );
                this.doActionAfter( "window_problem__update__grid_cell__after__manual_action", params );
                break;
            case "on_drag_move":
                switch ( params[ MANAGER.DragNDropManager.EVENT_PARAM.ELEMENT_NAME ] ) {
                    case SHINKEN_PAGE.CONST.SLIDE_PANEL.EDITION.NAME:
                        this.slide_panel_edition.doActionAfter( event_name, params );
                        break;
                    case SHINKEN_PAGE.CONST.SLIDE_PANEL.PROBLEMS.NAME:
                        this.slide_panel_problems.doActionAfter( event_name, params );
                        break;
                }
                break;
            case "on_drag_stop":
                switch ( params[ MANAGER.DragNDropManager.EVENT_PARAM.ELEMENT_NAME ] ) {
                    case "grid-page-edit-buttons-container":
                        DOM.Service.parsePositionToPercent( this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.EDIT_BUTTONS_CONTAINER ), true );
                        break;
                    case SHINKEN_PAGE.CONST.SLIDE_PANEL.EDITION.NAME:
                        this.slide_panel_edition.doActionAfter( event_name );
                        this.computeSizes();
                        break;
                    case SHINKEN_PAGE.CONST.SLIDE_PANEL.PROBLEMS.NAME:
                        this.slide_panel_problems.doActionAfter( event_name );
                        this.slide_panel_problems.computeSizes__20240926();
                        break;
                    default:
                        break;
                }
                this.saveUserPrefs();
                break;
            case "click_on_selector":
            case "click_on_item_selector":
                this.doActionAfterInForm( event_name, params );
                break;
            case "click-on-window-group-problem":
            case "click-on-window-group-problem-go-previous":
            case "click-on-window-group-problem-go-next":
            case "click-on-window-group-problem-focus-current":
                if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) ) {
                    params[ "phase_not_ready__20240816" ] = true;
                    this.addDoActionAfterCallBackPhaseIs( SHINKEN.OBJECT.CONST.PHASE.EDITING, event_name, params );
                    return;
                }
                //this.message_container.doActionAfter( event_name, params );
                break;
            case "focus-on-anchor-json":
                if ( this.json_form ) { // USEFUL to avoid traceback when click on cogwheel with a lot of widgets
                    this.json_form.doActionAfter( event_name, params );
                }
                break;
            case "focus-on-json-forced":
                if ( !this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON ) ) {
                    this.window_group_edition.setActiveWindow( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON );
                    this.doActionAfter( "click_on__window_navigation__done", {
                        [ WINDOW_V2.CONST.PARAM.WINDOW_GROUP_NAME ]: this.window_group_edition.getName(), [ WINDOW_V2.CONST.PARAM.WINDOW_NAME ]: SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON
                    } );
                    setTimeout( () => {
                        this.doActionAfter( "focus-on-anchor-json", params );
                    }, 0 );
                    return;
                }
                this.doActionAfter( "focus-on-anchor-json", params );
                break;
            case "focus-on-json-if-existing":
                if ( !this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON ) ) {
                    return;
                }
                this.doActionAfter( "focus-on-anchor-json", params );
                break;
            case "undo_last_modification":
            case "redo_last_modification":
                params[ CONTROLLER.CONST.PARAM_EVENT.CONTROLLER_OBJECT ]             = this.getController();
                params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] = this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON );
                for ( let i = 0, _size_i = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].getSize(); i < _size_i; i++ ) {
                    params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ] = params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT ].getContent( i );
                    if ( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_CONTENT_UUID ) ) {
                        this.content.doActionAfter( event_name, params );
                    }
                    else if ( params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.OBJECT_ELEMENT ].getParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME ) ) {
                        this.doActionAfterInForm( event_name, params );
                    }
                }
                this.doActionAfterInForm( "compute_form_after_undo_or_redo_last_modification", params );
                this.grid_page_history_view.doActionAfter( event_name, params );
                if ( !this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON ) ) {
                    this.json_editor = null; // USEFUL to force recompute of JSON
                }
                break;
            case "show-widgets-with-issues":
                this.dom_element.classList.remove( "shinken-hide-widgets-with-issues" );
                if ( this.display_of_widgets_button ) {
                    this.display_of_widgets_button.setState( COMPONENT.CONST.BTN_STATE.OFF );
                }
                break;
            case "hide-widgets-with-issues":
                this.dom_element.classList.add( "shinken-hide-widgets-with-issues" );
                if ( this.display_of_widgets_button ) {
                    this.display_of_widgets_button.setState( COMPONENT.CONST.BTN_STATE.ON );
                }
                break;
            case "previous_button_status_change":
                this.button_back_to_previous_preview = this.button_back_to_previous_preview || new COMPONENT.Button( this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.ACTION_BAR.BACK_TO_PREVIOUS_PREVIEW ).parentNode );
                const _state                         = this._preview_historics.hasValidPreview() ? COMPONENT.CONST.BTN_STATE.ON : COMPONENT.CONST.BTN_STATE.DISABLED;
                this.button_back_to_previous_preview.setState( _state );
                DOM.Service.addOrRemoveClasses( DOM.BodyService.getDomElement(), _state === COMPONENT.CONST.BTN_STATE.ON, "shinken-previewing-is-on" );
                break;
            case "show-tooltip-on-grid-cell":
                if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ) {
                    SHINKEN_TOOLTIP.showTooltip( params );
                }
                break;
            case "ask_play_notifications":
            case "ask_play_notification_visual_blink":
                this.notifications_of_change.doActionAfter( event_name, params );
                break;
            case "history_backend_loaded_done":
                this.grid_page_history_view.computeHtml();
                DOM.Service.addElementToAfterEmpty( this.grid_page_history_view.getDomElement(), this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.HISTORY_CONTAINER_VIEW ) );
                break;
            case "click_on__window_navigation__done":
                if ( params[ WINDOW_V2.CONST.PARAM.WINDOW_GROUP_NAME ] === this.window_group_edition.getName() ) {
                    switch ( params[ WINDOW_V2.CONST.PARAM.WINDOW_NAME ] ) {
                        case SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.VISUAL:
                            if ( !this.form__visual_mode ) {
                                this.form__visual_mode = this.getVisualFormInstance(); //  new SHINKEN.OBJECT.GridPageVisualForm ( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.VISUAL );
                                this.form__visual_mode.computeHtml();
                                this.window_group_edition.setContentDomElementTarget( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.VISUAL, this.form__visual_mode.getDomElement() );
                                this.form__visual_mode.doActionAfter( "action_for_page_edit_when_object_is_compute", { [ SHINKEN_PAGE.CONST.EVENTS.PARAM.PAGE_OBJECT ]: this } );
                            }
                            this.form__visual_mode.doActionAfter( "compute_linked_objects" );
                            CONTROLLER.Form.setCurrentForm( this.form__visual_mode );
                            break;
                        case SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.HISTORY:
                            if ( this.grid_page_history_view.getCurrentPhase() === SHINKEN.OBJECT.CONST.PHASE.INIT ) {
                                this.grid_page_history_view.initSpecific( this, this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.HISTORY_CONTAINER_VIEW ) );
                            }
                            CONTROLLER.Form.setCurrentForm( this.form__visual_mode );
                            break;
                        case SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON:
                            this.computeJsonEditor();
                            this.content.doActionAfter( "unselect_all_other_shinken_grid_cell" );
                            //this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                            CONTROLLER.Form.setCurrentForm( this.form__visual_mode );
                            break;
                        case SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.DEFAULT:
                            if ( !this.form__default_values ) {
                                this.form__default_values = this.getDefaultFormInstance();
                                this.form__default_values.computeHtml();
                                this.window_group_edition.setContentDomElementTarget( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.DEFAULT, this.form__default_values.getDomElement() );
                            }
                            else {
                                this.form__default_values.doActionAfter( "make_compute_after_0ms" );
                            }
                            CONTROLLER.Form.setCurrentForm( this.form__default_values );
                            this.form__default_values.doActionAfter( "make_validation" );
                            break;
                    }
                }
                break;
            case "navigate_on_window_edition_group":
                if ( this.json_form && this.json_form.message_invalid ) {
                    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_PREVIEWING );
                    return;
                }
                if ( this.is_json_modified_manually ) {
                    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_PREVIEWING );
                    this.addDoActionAfterCallBackPhaseIs( SHINKEN.OBJECT.CONST.PHASE.EDITING, "navigate_on_window_edition_group", params );
                    return;
                }
                MANAGER.EventManagerV2.clickOnWindowNavigation( params[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ], params );
                break;
            case "add_last_modification":
                params[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.PARENT_OBJECT ] = this;
                if ( this.last_modifications.doActionAfter( event_name, params ) ) {
                    this.grid_page_history_view.doActionAfter( event_name, params );
                }
                break;
            case "update_focus_from_json_action_and_key_up":
                this.doActionAfter( "update_focus_from_json_action", params );
                this.doActionAfter( "on_key_up", params );
                break;
            case "update_focus_from_json_action":
                let dom_parent_element = DOM.Service.findParentElementWithDataSet( this.json_editor.getCurrentElementOfJsonEditor(), 'jsonUuidPart', 50 );
                if ( dom_parent_element && dom_parent_element.getAttribute( 'data-json-uuid-part' ) ) {
                    this.content.doActionAfter( event_name, { [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_UUID ]: dom_parent_element.getAttribute( 'data-json-uuid-part' ) } );
                }
                break;
            case "remove_error_class_form_json":
                if ( this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON ) ) {
                    this.json_form.doActionAfter( event_name, params );
                }
                break;
            case "window_problem__update__grid_cell__after__manual_action":
                if ( params[ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_CELL_OBJECT ].hasCounterProblems() ) {
                    this.doActionAfter( "add_object__with_problems__from_user_action", params );
                }
                else {
                    this.doActionAfter( "clean_widget_with_problem", params );
                }
                break;
            case "update_grid_element_in_json":
                if ( this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON ) ) {
                    this.json_editor.updateGridElementWithNewData( params );
                }
                break;
            case "change_grid_size_in_json":
                if ( this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON ) ) {
                    const default_nb_tiles_in_height = this.getDefaultValueOfGrids()[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y ].getCfgValue();
                    this.json_editor.changeGridHeightValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_Y, params.new_grid_height_value, default_nb_tiles_in_height );
                }
                break;
            case "show_form_for_widget_configuration":
                params[ SHINKEN.ELEMENT.USER.PARAM.PREFS.NAME ] = this.user_pref;
                this.form__visual_mode.doActionAfter( event_name, params );
                break;
            case "close_form_for_widget_configuration":
                this.form__visual_mode.doActionAfter( event_name, params );
                CONTROLLER.Form.setCurrentForm( this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.DEFAULT ) ? this.form__default_values : this.form__visual_mode );
                this.slide_panel_edition.computeSizes__20240926( true );
                this.slide_panel_problems.computeSizes__20240926( true );
                break;
            case "ask_close_form_for_widget_configuration__if_needed":
                this.doActionAfterInForm( event_name, params );
                break;
            case "mouse_down_on_grid_cell":
            case "mouse_up_on_grid_cell":
            case "mouse_down":
            case "mouse_move":
            case "mouse_up":
            case "mouse_wheel":
            case "mouse_leave":
                this.doActionAfter_mouse( event_name, params );
                break;
            case "set__user_pref__data":
                this.user_pref.addPref( params[ SHINKEN.USER_PREFS.PARAM_EVENT.DATA ] );
                break;
            default:
                params                                                               = params || {};
                params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] = this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON );
                this.content.doActionAfter( event_name, params );
                break;
        }
        this.doActionAfterSpecific( event_name, params );
    },
    doActionAfterSpecific      : function ( event_name, param ) { // TO OVERRIDE
    },
    doActionAfter_keyUp        : function ( event_name, param ) {
        if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) ) {
            return;
        }
        if ( DOM.Service.isActiveElementEditable() ) {
            if ( document.activeElement.id === "id-shinken-output-json" ) {
                this.askOnKeyUpJson( param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ] );
            }
            return;
        }
        
        let current_key_code                  = param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].keyCode;
        param[ SHINKEN.CONST.PARAM.KEY_CODE ] = current_key_code;
        if ( this.content.doActionAfter( "is_an_action_overlay_frame_in_progress_in" ) ) {//you can't use keyboard shortcut if something is ongoing on the grid
            switch ( current_key_code ) {
                case SHINKEN.CONST.KEY_CODE.ESCAPE:
                    this.content.doActionAfter( event_name, param );
                    break;
            }
            return;
        }
        switch ( current_key_code ) {
            case SHINKEN.CONST.KEY_CODE.Z:
            case SHINKEN.CONST.KEY_CODE.Y:
                if ( !param[ MANAGER.EVENT_MANAGER_V2.PARAM.EVENT ].ctrlKey ) {
                    return;
                }
                param[ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.PARENT_OBJECT ] = this;
                return this.last_modifications.doActionAfter( event_name, param );
            case SHINKEN.CONST.KEY_CODE.SUPPR:
                this.doActionAfter( "show-widgets-with-issues" );
                this.content.doActionAfter( event_name, param );
                break;
            case SHINKEN.CONST.KEY_CODE.ENTER:
                param[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] = this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON );
                this.content.doActionAfter( event_name, param );
                break;
            case SHINKEN.CONST.KEY_CODE.ESCAPE:
                if ( SHINKEN.OBJECT.ConfirmationPopup_V3.getInstance().isVisible() ) {
                    SHINKEN.OBJECT.ConfirmationPopup_V3.getInstance().hide();
                    SHINKEN.OBJECT.ConfirmationPopup_V3.getInstance().init();
                    return;
                }
                this.content.doActionAfter( event_name, param );
                this.doActionAfterInForm( event_name, param );
                return;
            case SHINKEN.CONST.KEY_CODE.A:
                if ( !SHINKEN.OBJECT.ConfirmationPopup_V3.getInstance().isVisible() ) {
                    this.doActionAfter( "reset_grid_cell_to_add" );
                    this.doActionAfterInForm( event_name, param );
                }
                break;
            case SHINKEN.CONST.KEY_CODE.V:
            case SHINKEN.CONST.KEY_CODE.C:
            case SHINKEN.CONST.KEY_CODE.S:
                this.doActionAfterInForm( event_name, param );
                break;
        }
    },
    doActionAfter_mouse        : function ( event_name, params ) {
        if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING ) ) {
            return;
        }
        switch ( event_name ) {
            case "mouse_down":
            case "mouse_down_on_grid_cell":
                this.doActionAfter( "show-widgets-with-issues" );
                this.doActionAfter( "ask_close_form_for_widget_configuration__if_needed" );
                if ( this.is_json_modified_manually ) {
                    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_PREVIEWING );
                    return;
                }
                break;
        }
        if ( params ) {
            params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.WIDGET_MODE__PHASE__OBJECT ] = this.synchronized_phase_with_widget_mode;
            params[ SHINKEN_PAGE.CONST.EVENTS.PARAM.ACTIVE_WINDOW_NAME_IS_JSON ] = this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON );
        }
        switch ( event_name ) {
            case "mouse_up":
            case "mouse_down":
                this.content.doActionAfter( event_name, params );
                break;
            case "mouse_down_on_grid_cell":
                switch ( this.synchronized_phase_with_widget_mode.current_phase ) {
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT:
                        this.content.doActionAfter( event_name, params );
                        this.doActionAfter( "focus-on-json-if-existing", params );
                        break;
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_CREATE:
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_DELETE:
                        this.content.doActionAfter( event_name, params );
                        break;
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_ADD:
                        return;
                }
                break;
            case "mouse_move":
                switch ( this.synchronized_phase_with_widget_mode.current_phase ) {
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT:
                        this.content.doActionAfter( event_name, params );
                        switch ( this.window_group_edition.getCurrentPhase() ) {
                            case SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON:
                            case SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.HISTORY:
                                //this.content.doActionAfter( "drag_n_drop_widget_stop_update_json", params );
                                this.content.doActionAfter( "update_grid__highlighted_tile", params );
                                break;
                        }
                        break;
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.SELECT_WIDGET.SELECT_BY_ZONE:
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_CREATE:
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.SPACE_DELETE:
                        this.content.doActionAfter( event_name, params );
                        break;
                    case SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_ADD:
                        this.content.doActionAfter( event_name, params );
                        params[ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ] = this.form__visual_mode.getPropertyByName( SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.ADD_WIDGET.RADIOS._KEY ).getCurrentPhase();
                        this.content.doActionAfter( "mouse_move_on_grid_with_add_widget", params );
                        break;
                    default:
                        break;
                }
                break;
            case "mouse_up_on_grid_cell":
            case "mouse_wheel":
            case "mouse_leave":
                this.content.doActionAfter( event_name, params );
                break;
        }
    },
    doActionAfterInForm        : function ( event_name, params ) {
        if ( this.form__visual_mode ) {
            this.form__visual_mode.doActionAfter( event_name, params );
        }
        if ( this.form__default_values ) {
            this.form__default_values.doActionAfter( event_name, params );
        }
    },
    setEditionJsonManually     : function ( to_set ) {
        this.is_json_modified_manually = to_set;
        this.content.doActionAfter( "set_edition_json_manually", { "is_json_modified_manually": this.is_json_modified_manually } );
    },
    computeJsonEditor          : function () {
        if ( !this.json_editor || !this.isSameViewData( this._preview_historics.getOriginal().getData() ) ) {
            this.json_editor = this.getJsonEditorInstance( this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.FORM_VALUE ), this.getDataForJson(), SHINKEN_PAGE.CONST.DEFAULT_VALUE );
            this.json_editor.dom_element.addEventListener( "scroll", () => {
                const _container           = document.querySelector( ".shinken-textarea-line-nums" );
                _container.style.transform = "translateY(-" + this.json_editor.dom_element.scrollTop + "px)";
            } );
            document.querySelector( ".shinken-json-div" ).appendChild( CLIPBOARD_SERVICE.buildHtmlButtons_V3( true, false, { [ SHINKEN.OBJECT.JSON_EDITOR.PARAM.JSON_OBJECT ]: true } ) );
            this.json_form = new SHINKEN.OBJECT.JsonForm( this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.FORM_VALUE ) );
            this.json_editor.updateHtml();
            this.json_form.askComputeLineNumber();
        }
    },
    getController              : function () { // TO OVERRIDE
        throw new Error( "getController in page-edit.js have to be override" );
    },
    getBackendDataUrl__20241008: function ( need_user_value ) { // TO OVERRIDE
        throw new Error( "getBackendDataUrl in page-edit.js have to be override" );
    },
    saveJsHistory              : function ( data ) {
        const _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_EDITING:
                this._preview_historics = new SHINKEN.OBJECT.DataHistoric();
                this._preview_historics.setOriginal( data );
                this._visual_edition_historics = new SHINKEN.OBJECT.DataHistoric();
                this._visual_edition_historics.setOriginal( this.content.grids );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.SAVING:
            case SHINKEN.OBJECT.CONST.PHASE.PUBLISHING:
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_REFRESH:
                this._preview_historics.getOriginal().updateData( data );
                this._preview_historics.resetPreviews();
                this._visual_edition_historics.resetPreviews();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_PREVIEWING:
                this._preview_historics.addValidPreview( data );
                this._visual_edition_historics.addValidPreview( this.content.grids );
                this.doActionAfter( "previous_button_status_change" );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CANCEL:
                break;
            default:
                console.warn( "[Page - saveJsHistory]", "[NOT MANAGED]", _current, data );
                break;
        }
    },
    onTimeoutError             : function () {
        const _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
            case SHINKEN.OBJECT.CONST.PHASE.REFRESHING:
            case SHINKEN.OBJECT.CONST.PHASE.INIT:
            case SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_EDITING:
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                this.refresh_object.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
                if ( !this.dom_element ) {
                    this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.BACKEND_RETURN_TREATMENT, SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK, "", _( "common.broker_unreachable" ), _( "progress_bar.previewing_failed", [DICTIONARY_COMMON_UI] ) );
                }
                break;
            case SHINKEN.OBJECT.CONST.PHASE.SAVING:
            case SHINKEN.OBJECT.CONST.PHASE.PUBLISHING:
                this.grid_page_history_view.reset();
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.BACKEND_RETURN_TREATMENT, SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK, "", _( "common.broker_unreachable" ), _( "edit_mode.saving_popup.saving_error" ) );
                break;
            default:
                break;
        }
    },
    getDataForPreview          : function () {
        //this.message_container.reset();
        this.saving_popup = new SHINKEN.OBJECT.Progressbar( this, SHINKEN_PAGE.CONST.STEP.END, 500, this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.SLIDE_PANEL_SAVING_POPUP_CONTAINER ) );
        this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.JS_JSON_VERIFICATION, SHINKEN.OBJECT.CONST.PHASE.RUNNING, "", "", _( "progress_bar.previewing_in_progress", [DICTIONARY_COMMON_UI] ) );
        const checkPreviewSuccess = ( _status, _data ) => {
            switch ( _data.rc ) {
                case COMMUNICATION.CODE.SUCCESS:
                    this.updateObject( _data[ "output" ] );
                    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASKING_SHOW_FORM );
                    this.saving_popup.setTitleStep( SHINKEN_PAGE.CONST.STEP.END, _( "progress_bar.previewing_succeed", [DICTIONARY_COMMON_UI] ) );
                    this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.BACKEND_RETURN_TREATMENT, SHINKEN.OBJECT.CONST.PHASE.RUNNING_OK );
                    break;
                case COMMUNICATION.CODE.ERROR:
                    this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.BACKEND_RETURN_TREATMENT, SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK, _data[ "output" ], _( "edit_mode.saving_popup.saving_error_detail_json" ), _( "progress_bar.previewing_succeed_with_error", [DICTIONARY_COMMON_UI] ) );
                    this.updateObject( _data[ "output" ], true );
                    this._preview_historics.setInvalidPreview( _data[ "output" ] );
                    break;
                case COMMUNICATION.CODE.NOT_FOUND:
                    this.saving_popup.setTitleStep( SHINKEN_PAGE.CONST.STEP.END, _( "progress_bar.previewing_failed", [DICTIONARY_COMMON_UI] ) );
                    this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.BACKEND_RETURN_TREATMENT, SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK, "", _( "edit_mode.saving_popup.saving_error_detail_404" ), _( "progress_bar.previewing_failed", [DICTIONARY_COMMON_UI] ) );
                    break;
                case COMMUNICATION.CODE.FORBIDDEN:
                    this.getController().doActionAfter403();
                    break;
            }
        };
        let data_json_format      = this.getDataToSaveJsonFormat();
        if ( data_json_format ) {
            const url = this.getUrlPreview();
            this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.CALL_BACKEND_VERIFICATION );
            this.getController().requestPost( url, data_json_format, checkPreviewSuccess );
            this.json_editor = null;
        }
    },
    getUrlPreview              : function () {
        throw new Error( "getUrlPreview in grid-page-edit have to be override" );
    },
    computeSizes               : function ( param ) {
        this.content.computeSizes();
        if ( param && param[ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.OBJECT ] ) {
            if ( param[ SHINKEN.OBJECT.SLIDE_PANEL.PARAM.OBJECT ] === SHINKEN_PAGE.CONST.SLIDE_PANEL.EDITION.NAME ) {
                this.slide_panel_problems.computeSizes__20240926();
            }
        }
        else {
            this.slide_panel_edition.computeSizes__20240926();
            this.slide_panel_problems.computeSizes__20240926();
        }
    },
    //********************************************  SAVE  *****************************************************//
    
    getDataToSaveSpecific  : function ( to_return ) {
        return to_return;
    },
    getDataToSave          : function () {
        const _to_return = this.content.getDataToSave();
        this.getDataToSaveSpecific( _to_return );
        if ( this[ SHINKEN_PAGE.CONST.PARAM.PAGE.USERS._KEY ] ) {
            _to_return[ SHINKEN_PAGE.CONST.PARAM.PAGE.USERS._KEY ] = this[ SHINKEN_PAGE.CONST.PARAM.PAGE.USERS._KEY ].getDataToSave();
        }
        _to_return[ SHINKEN_PAGE.CONST.PARAM.PAGE.NOTIFICATIONS._KEY ] = this[ SHINKEN_PAGE.CONST.PARAM.PAGE.NOTIFICATIONS._KEY ].getDataToSave();
        _to_return[ SHINKEN.OBJECT.VIEW.PARAM.VIEW_BEHAVIOUR ]         = this.view_behaviour.getDataToSave();
        return _to_return;
    },
    getDataToSaveJsonFormat: function () {
        let to_return;
        if ( this.window_group_edition.isPhase( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.JSON ) ) {
            to_return = this.json_editor.getCurrentContent();
            this.computeJsonForm();
            if ( !this.json_form.isValid() ) {
                if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_PREVIEWING ) ) {
                    this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.CALL_BACKEND_VERIFICATION, SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK, "", _( "edit_mode.saving_popup.saving_error_detail_json" ), _( "progress_bar.previewing_failed", [DICTIONARY_COMMON_UI] ) );
                }
                else {
                    this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.CALL_BACKEND_VERIFICATION, SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK, "", _( "edit_mode.saving_popup.saving_error_detail_json" ), _( "edit_mode.saving_popup.saving_error" ) );
                }
                return;
            }
            if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_PREVIEWING ) ) { //WHY IS IT DIFFERENT ??
                to_return                                             = JSON.parse( to_return );
                to_return[ SHINKEN.OBJECT.VIEW.PARAM.VIEW_BEHAVIOUR ] = this.view_behaviour.getDataToSave();
                to_return                                             = JSON.stringify( to_return );
            }
        }
        else {
            to_return = this.getDataToSave();
            to_return = JSON.stringify( to_return );
        }
        return to_return;
    },
    askSave                : function () {
        this.saving_popup = new SHINKEN.OBJECT.Progressbar( this, SHINKEN_PAGE.CONST.STEP.END, 500, this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.SLIDE_PANEL_SAVING_POPUP_CONTAINER ) );
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.PUBLISHING ) ) {
            this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.JS_JSON_VERIFICATION, SHINKEN.OBJECT.CONST.PHASE.RUNNING, "", "", _( "progress_bar.publishing_in_progress", [DICTIONARY_COMMON_UI] ) );
            //this.view_behaviour.changePhaseAction( SHINKEN.OBJECT.VIEW.BEHAVIOUR.PHASE.RUNNING );
        }
        else {
            this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.JS_JSON_VERIFICATION, SHINKEN.OBJECT.CONST.PHASE.RUNNING, "", "", _( "progress_bar.saving_in_progress", [DICTIONARY_COMMON_UI] ) );
        }
        const saveSuccess    = ( _status, _data ) => {
            switch ( _data.rc ) {
                case COMMUNICATION.CODE.SUCCESS:
                    this.saving_popup.setParamStep( SHINKEN_PAGE.CONST.STEP.END, _data[ "output" ] );
                    this.saving_popup.setTitleStep( SHINKEN_PAGE.CONST.STEP.END, _( "progress_bar.saving_succeed", [DICTIONARY_COMMON_UI] ) );
                    this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.BACKEND_RETURN_TREATMENT, SHINKEN.OBJECT.CONST.PHASE.RUNNING_OK );
                    this.grid_page_history_view.initSpecific( this, this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.HISTORY_CONTAINER_VIEW ), true );
                    this.json_editor = null;
                    break;
                case COMMUNICATION.CODE.ERROR:
                    this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.BACKEND_RETURN_TREATMENT, SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK, _data[ "output" ], _( "edit_mode.saving_popup.saving_error_detail_json" ), _( "edit_mode.saving_popup.saving_error" ) );
                    this.json_editor = null;
                    break;
                case COMMUNICATION.CODE.NOT_FOUND:
                    this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.BACKEND_RETURN_TREATMENT, SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK, "", _( "edit_mode.saving_popup.saving_error_detail_404" ), _( "edit_mode.saving_popup.saving_error" ) );
                    break;
                case COMMUNICATION.CODE.FORBIDDEN:
                    this.getController().doActionAfter403();
                    break;
            }
            SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "save-view-done" );
        };
        let data_json_format = this.getDataToSaveJsonFormat();
        if ( data_json_format ) {
            const url = this.getUrlSave();
            this.saving_popup.doProgress( SHINKEN_PAGE.CONST.STEP.CALL_BACKEND_VERIFICATION );
            this.getController().requestPost( url, data_json_format, saveSuccess );
        }
    },
    getUrlSave             : function () { // TO OVERRIDE
        throw new Error( "getUrlSave in page-edit have to be overridden" );
    },
    
    //********************************************  SAVE USER  *****************************************************//
    saveUserPrefs       : function () {
        const _to_save = SHINKEN.TOOLS.IFRAME_PARENT_COMMUNICATION.getUserPref( SHINKEN_PAGE.CONST.USER_PREFS.NAME );
        if ( !_to_save ) {
            return;
        }
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ) {
            _to_save[ SHINKEN_PAGE.CONST.USER_PREFS.ACTION_BUTTON_POSITION ] = DOM.Service.getPositionsForSaveInPercent( this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.EDIT_BUTTONS_CONTAINER ), [
                DOM.CONST.STYLE.TOP, DOM.CONST.STYLE.LEFT
            ] );
        }
        if ( !this.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ) {
            if ( this.slide_panel_edition.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ) {
                _to_save[ this.slide_panel_edition.getName() ] = this.slide_panel_edition.getCurrentRatio();
            }
            if ( this.slide_panel_problems.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING ) ) {
                _to_save[ this.slide_panel_problems.getName() ] = this.slide_panel_problems.getCurrentRatio();
            }
        }
        SHINKEN.TOOLS.IFRAME_PARENT_COMMUNICATION.askSaveUserPrefs( SHINKEN_PAGE.CONST.USER_PREFS.NAME, _to_save );
    },
    initButtonsPositions: function () {
        let _position_buttons;
        const _to_set = SHINKEN.TOOLS.IFRAME_PARENT_COMMUNICATION.getUserPref( SHINKEN_PAGE.CONST.USER_PREFS.NAME );
        if ( _to_set && Object.keys( _to_set ).length ) {
            const transformPositionInInset = function ( position ) {
                const _top    = position[ DOM.CONST.STYLE.TOP ] ? position[ DOM.CONST.STYLE.TOP ] : "auto";
                const _right  = position[ DOM.CONST.STYLE.RIGHT ] ? position[ DOM.CONST.STYLE.RIGHT ] : "auto";
                const _bottom = position[ DOM.CONST.STYLE.BOTTOM ] ? position[ DOM.CONST.STYLE.BOTTOM ] : "auto";
                const _left   = position[ DOM.CONST.STYLE.LEFT ] ? position[ DOM.CONST.STYLE.LEFT ] : "auto";
                return _top + " " + _right + " " + _bottom + " " + _left;
            };
            _position_buttons              = { inset: transformPositionInInset( _to_set[ SHINKEN_PAGE.CONST.USER_PREFS.ACTION_BUTTON_POSITION ] ) };
        }
        else {
            _position_buttons                          = {};
            _position_buttons[ DOM.CONST.STYLE.TOP ]   = "15%";
            _position_buttons[ DOM.CONST.STYLE.RIGHT ] = "1%";
        }
        DOM.Service.setStyles( this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.EDIT_BUTTONS_CONTAINER ), _position_buttons );
    },
    isSameViewData      : function ( data ) {
        throw new Error( "isSameViewData in grid-page-edit.js have to be override" );
    },
    //********************************************  HTML  *****************************************************//
    
    getPageEditDomElement       : function ( name ) {
        return this.getPageEditDomElementCommon( name );
    },
    getPageEditDomElementCommon : function ( name ) {
        if ( !this.dom_elements ) {
            this.dom_elements = [];
        }
        if ( !this.dom_elements[ name ] ) {
            switch ( name ) {
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.SHINKEN_BOX_MODE_RUNNING:
                    this.dom_elements[ name ] = document.querySelector( ".shinken-box-mode-running" );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.SHINKEN_BOX_MODE_EDITING:
                    this.dom_elements[ name ] = document.querySelector( ".shinken-box-mode-editing" );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.FORM_VALUE:
                    this.dom_elements[ name ] = document.getElementById( "id-shinken-output-json" );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.FORM_CONTAINER:
                    this.dom_elements[ name ] = document.querySelector( ".shinken-weather-form-container" );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.ACTION_BAR.BACK_TO_PREVIOUS_PREVIEW:
                    this.dom_elements[ name ] = document.querySelector( '.shinken-weather-form-container .shinken-form-action-bar-container .shinken-button[data-name="back_to_previous_preview"]' );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.LOADING_MESSAGE:
                    this.dom_elements[ name ] = document.querySelector( ".shinken-weather-form-container .shinken-weather-form-loading-message" );
                    break;
                //case WEATHER.CONST.DOM_ELEMENT.HISTORY_LOADING_MESSAGE:
                //    this.dom_elements[ name ] = document.querySelector( ".shinken-weather-form-container .shinken-view-history-container .shinken-weather-form-loading-message" );
                //    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.EDIT_BUTTONS_CONTAINER:
                    this.dom_elements[ name ] = document.getElementById( "id-shinken-weather-edit-buttons-container" );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.EDIT_MODE_BTN_PUBLISH_VIEW:
                    this.dom_elements[ name ] = document.querySelector( ".shinken-weather-publish-button-cell .shinken-button-container" );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.FORM_ACTION_BAR:
                    this.dom_elements[ name ] = document.querySelector( ".shinken-weather-form-container .shinken-action-bar-container" );
                    break;
                case WEATHER.CONST.DOM_ELEMENT.EXTERNAL_LINKS_CONTAINER:// TODO TO MOVE
                    this.dom_elements[ name ] = document.querySelector( "#id-shinken-weather-edit-buttons-container .shinken-weather-external-links-container" );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.SAVING_POPUP_CONTAINER:
                    this.dom_elements[ name ] = document.querySelector( "#id-shinken-weather-edit-buttons-container .shinken-weather-popup-progress-bar-container" );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.SLIDE_PANEL_SAVING_POPUP_CONTAINER:
                    this.dom_elements[ name ] = document.querySelector( ".shinken-weather-edit-popup-progress-bar-container" );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.INFO_BAR_CONTAINER:
                    this.dom_elements[ name ] = document.querySelector( ".shinken-info-bar-container" );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.CURSOR_POSITION_LABEL:
                    this.dom_elements[ name ] = document.querySelector( ".shinken-action-bar-cursor-position-label" );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.HISTORY_CONTAINER_VIEW:
                    this.dom_elements[ name ] = document.querySelector( ".shinken-view-history-container" );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.HISTORY_VIEW_HISTORY:
                    this.dom_elements[ name ] = document.querySelector( ".shinken-view-history" );
                    break;
                case SHINKEN_PAGE.CONST.DOM_ELEMENT.CURRENT_CHANGES_CONTAINER_VIEW:
                    this.dom_elements[ name ] = document.querySelector( ".shinken-view-current-changes" );
                    break;
                default:
                    this.dom_elements[ name ] = document.querySelector( name );
                    break;
            }
        }
        return this.dom_elements[ name ];
    },
    closeSavingPopUp            : function () {
        if ( this.saving_popup ) {
            this.saving_popup.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
        }
    },
    closeSavingPopUpAfterTimeout: function ( timeout ) {
        setTimeout( () => {
            if ( this.saving_popup ) {
                
                this.saving_popup.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
            }
        }, timeout );
        
    },
    //********************************************  ERROR CONFIGURATION  *****************************************************//
    computeJsonForm: function () {
        if ( !this.json_form ) {
            return;
        }
        this.json_form = new SHINKEN.OBJECT.JsonForm( this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.FORM_VALUE ) );
        this.json_form.computeIsValid();
        this.json_form.askComputeLineNumber();
        if ( this.json_form.isValid() ) {
            return;
        }
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
        this.slide_panel_problems.doActionAfter( "before__update_object__grid_page" );
        this.slide_panel_problems.doActionAfter( "add_object_json_fail", { [ SHINKEN.OBJECT.JSON_EDITOR.PARAM_EVENT.JSON_FORM_OBJECT ]: this.json_form } );
    },
    //********************************************  PHASE  *****************************************************//
    getTypeEdition          : function () {
        return this.window_group_edition.getActiveWindow().getName();//TODO TO REMOVE
    },
    updateData__20240926    : function ( data ) {
        this.updateObject( data[ "output" ] );
    },
    getVisualFormInstance   : function () {
        return new SHINKEN.OBJECT.GridPageVisualForm( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.VISUAL );
    },
    getJsonEditorInstance   : function ( dom_element, json, default_tag ) {
        return new SHINKEN.OBJECT.JsonEditor( dom_element, json, default_tag );
    },
    getDefaultFormInstance  : function () {
        const grid = this.content.grids.getContent( 0 ); // TODO see here how to get the grid with a better way
        let params = {
            [ SHINKEN_GRID.CONST.PARAM.EVENT.GRID_OBJECT ]: grid,
            [ SHINKEN.USER_PREFS.PARAM_EVENT.DATA ]       : this.user_pref
        };
        return new SHINKEN.OBJECT.GridPageDefaultForm( SHINKEN_PAGE.CONST.WINDOW_EDIT_NAME.DEFAULT, params );
    },
    callbackForPhase        : function () {
        const _current            = this.getCurrentPhase();
        this.last_cursor_position = this.last_cursor_position || 0;
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                switch ( this.phase.previous_phase ) {
                    case SHINKEN.OBJECT.CONST.PHASE.SAVING :
                        this.refresh_object.setPhase( SHINKEN.OBJECT.CONST.PHASE.RESET );
                        break;
                    case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CANCEL :
                        this.refresh_object.setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING_TO_STRING );
                        break;
                    default :
                        this.refresh_object.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
                        break;
                }
                break;
            case SHINKEN.OBJECT.CONST.PHASE.REFRESHING:
                this.refresh_object.setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING_TO_STRING );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.HIDDEN:
                this.refresh_object.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN_TO_STRING );
                break;
            default:
                this.refresh_object.setPhase( SHINKEN.OBJECT.CONST.PHASE.STOPPING );
                break;
        }
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "update_screen_phase", _current );
                this.last_modifications.doActionAfter( "reset_all__20240909" );
                this.synchronized_phase_with_widget_mode.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
                this.content.setPhase( _current );
                this.doActionAfter( "on_drag_stop", { [ MANAGER.DragNDropManager.EVENT_PARAM.ELEMENT_NAME ]: "grid-page-edit-buttons-container" } ); // FIX PROBLEM OF BUTTON BAD MOVED AFTER RESIZE...
                if ( !this.isPreviousPhaseInPhase( [SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.INIT] ) ) {
                    this.slide_panel_problems.close__20240925();
                    this.slide_panel_edition.close__20240925();
                }
                this.getController().doActionAfter( "current_page_set_phase_to_running" );
                const _window = MANAGER.__instance_window_distributor.getParentWindow( "grid_page_window_group_problem" );
                if ( _window ) {
                    _window.resetCounters();
                }
                if ( this.getPreviousPhase() === SHINKEN.OBJECT.CONST.PHASE.RUNNING ) {
                    this.doActionAfter( "ask_play_notifications" );
                }
                break;
            case SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_EDITING:
                this.slide_panel_edition.open__20240925();
                SHINKEN.TOOLS.IFRAME_PARENT_COMMUNICATION.askEnterEditMode();
                this.slide_panel_edition.setLoading( _( "edit_mode.loading_message.get_data_in_progress" ) );
                this.getBackendData__20240926( ( _status, data ) => {
                    this.saveJsHistory( data[ "output" ] );
                    if ( !this.isSameViewData( data[ "output" ] ) ) {
                        this.getController().askShowLoadingPage();
                        this.updateData__20240926( data );
                        this.setPhaseWithTimeOut( SHINKEN.OBJECT.CONST.PHASE.ASKING_SHOW_FORM, 600 );
                    }
                    else if ( this.json_editor ) {
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.EDITING );
                    }
                    else {
                        this.slide_panel_edition.setLoading( _( "edit_mode.loading_message.get_data_in_progress" ) );
                        this.setPhaseWithTimeOut( SHINKEN.OBJECT.CONST.PHASE.ASKING_SHOW_FORM, 600 );
                    }
                }, true );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.ASKING_SHOW_FORM:
                this.setEditionJsonManually( false );
                this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.LOADING_MESSAGE ).innerHTML = _( "edit_mode.loading_message.build_json" );
                this.slide_panel_edition.setContent__20240925( this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.FORM_CONTAINER ) );
                this.initPhaseEditing();
                this.doActionAfter( "click_on__window_navigation__done", {
                    [ WINDOW_V2.CONST.PARAM.WINDOW_GROUP_NAME ]: this.window_group_edition.getName(), [ WINDOW_V2.CONST.PARAM.WINDOW_NAME ]: this.getTypeEdition()
                } );
                this.form__visual_mode.doActionAfter( "change_radio_mode", {
                    [ SHINKEN.OBJECT.RADIOMODE.PARAM.PARENT_OBJECT ]: SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES._KEY,
                    [ SHINKEN.OBJECT.RADIOMODE.PARAM.NAME ]         : SHINKEN_PAGE.VISUALFORM.COLLAPSE_FOLDER.WIDGETS.RADIO_MODES.WIDGET.WIDGET_SELECT
                } );
                this.setPhaseWithTimeOut( SHINKEN.OBJECT.CONST.PHASE.EDITING, 600 );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.EDITING:
                SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "update_screen_phase", _current );
                DOM.Service.focusAndSetCursorPosition( this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.FORM_VALUE ), this.last_cursor_position || 0 );
                this.content.setPhase( _current );
                this.getController().askCloseLoadingPage();
                this.slide_panel_problems.setPhase( SHINKEN.OBJECT.CONST.PHASE.READY );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_PREVIEWING:
                this.slide_panel_problems.setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING );
                this.closeSavingPopUp();
                this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.LOADING_MESSAGE ).innerHTML = _( "edit_mode.loading_message.checking" );
                this.getController().askShowLoadingPage();
                this.last_cursor_position = this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.FORM_VALUE ).selectionStart;
                this.getDataForPreview();
                this.setEditionJsonManually( false );
                this.last_modifications.init();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.SAVING:
            case SHINKEN.OBJECT.CONST.PHASE.PUBLISHING:
                this.form__default_values = null;
                this.slide_panel_problems.setPhase( SHINKEN.OBJECT.CONST.PHASE.REFRESHING );
                this.askSave();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_REFRESH:
                this.refresh();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CANCEL:
                this.closeSavingPopUp();
                if ( !this.isSameViewData( this._preview_historics.getOriginal().getData() ) ) {
                    this.updateObject( this._preview_historics.getOriginal().getData() );
                }
                this.grid_page_history_view.doActionAfter( "clear_all_last_modifications", { [ SHINKEN.OBJECT.CONST.LAST_MODIFICATION.PARAM.NUMBER ]: this.last_modifications.getSize() } );
                this.setEditionJsonManually( false );
                this.json_editor          = null;
                this.form__default_values = null;
                this._preview_historics.resetPreviews();
                this._visual_edition_historics.resetPreviews();
                this.doActionAfter( "previous_button_status_change" );
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                break;
        }
        this.callbackForPhaseSpecific();
    },
    callbackForPhaseSpecific: function () {
    },
    //********************************************  PROGRESS BAR  ************************************************//
    _doActionWhenProgressStart: function ( current_step, param ) {
        switch ( current_step ) {
            case SHINKEN_PAGE.CONST.STEP.END:
                switch ( this.getCurrentPhase() ) {
                    case SHINKEN.OBJECT.CONST.PHASE.SAVING:
                    case SHINKEN.OBJECT.CONST.PHASE.PUBLISHING:
                        this.saving_popup.setDomElementParent( this.getPageEditDomElement( SHINKEN_PAGE.CONST.DOM_ELEMENT.SAVING_POPUP_CONTAINER ) );
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                        this.updateObject( param );
                        this._preview_historics.resetPreviews();
                        this._visual_edition_historics.resetPreviews();
                        SHINKEN.TOOLS.IFRAME_PARENT_COMMUNICATION.listenSaveDone(); //TODO a géré quand l'appel est en failed
                        this.doActionAfter( "previous_button_status_change" );
                        SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "ask_for_refresh_after_save" );
                        break;
                }
                break;
            default:
                break;
        }
    },
    _doActionWhenProgressEnd  : function ( current_step, param ) {
        switch ( current_step ) {
            case SHINKEN_PAGE.CONST.STEP.BACKEND_RETURN_TREATMENT:
                switch ( this.saving_popup.getCurrentPhase() ) {
                    case SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK:
                        if ( this.getCurrentPhase() !== SHINKEN.OBJECT.CONST.PHASE.ASKING_ENTER_PREVIEWING ) {
                            this.updateObject( param, true );
                        }
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASKING_SHOW_FORM );
                        //this.closeSavingPopUpAfterTimeout( 5000 );
                        break;
                }
                break;
        }
    },
    getDefaultValueOfGrids    : function () {
        if ( !this.default_valud_of_grids ) {
            this.default_valud_of_grids = this.content.doActionAfter( "get_default_values_of_grid" );
        }
        return this.default_valud_of_grids;
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageEdit, SHINKEN.OBJECT.GridPage );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageEdit, SHINKEN.OBJECT.ShinkenObjectJson );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageEdit, SHINKEN.OBJECT.ProgressbarInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageEdit, SHINKEN.OBJECT.CounterInterfaceValidation );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.GridPageEdit, SHINKEN.OBJECT.LastModificationsInterface );