//__lib__ lib_common
"use strict";

WINDOW.Element           = function ( name, dom_element, is_menu ) {
    this.__class_name__ = "WINDOW.Element";
    //id
    //dom_element_target
    //counters
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.Element.prototype = {
    init          : function () {
        this.initCounters();
    },
    initDomElement: function () {
    },
    //********************************************  SETTER GETTER   **************************************************//
    getName                   : function () {
        return this.name;
    },
    getLabel                  : function () {
        return this.label || this.name;
    },
    getUUID                   : function () {
        return this.id;
    },
    setHasRequired            : function ( to_set ) {
        if ( to_set ) {
            this.dom_element.querySelector( ".shinken-required-field" ).classList.remove( "shinken-hidden" );
        }
    },
    setActive                 : function ( to_set ) {
        this.is_active = to_set;
        if ( this.getDomElement() ) {
            if ( this.is_active ) {
                this.dom_element.classList.add( "shinken-active" );
                this.dom_element_target.classList.remove( "shinken-hidden" );
            }
            else {
                this.dom_element.classList.remove( "shinken-active" );
                this.dom_element_target.classList.add( "shinken-hidden" );
            }
        }
    },
    isActive                  : function () {
        return this.is_active;
    },
    setDisabled               : function ( to_set ) {
        this.is_disabled = to_set;
        DOM.Service.addOrRemoveClasses( this.dom_element, this.is_disabled, "shinken-disabled" );
    },
    isClickable               : function ( to_set ) {
        if ( this.is_disabled ) {
            return false;
        }
        switch ( this.visibility_state ) {
            case SHINKEN.CONST.VISIBILITY_STATE.HIDDEN:
            case SHINKEN.CONST.VISIBILITY_STATE.DISABLED:
            case SHINKEN.CONST.VISIBILITY_STATE.LOCKED:
            case SHINKEN.CONST.VISIBILITY_STATE.TOTALLY_FORM_EXCLUDE:
                return false;
        }
        return true;
    },
    hasProperties             : function () {
        return false;
    },
    setContentDomElementTarget: function ( to_set ) {
        this.content_dom_element_target = to_set;
        DOM.Service.addElementToAfterEmpty( to_set, this.dom_element_target );
    },
    hasProblems               : function ( window_name ) {
        return !!(this.hasError() || this.hasWarning());
    },
    //********************************************  COUNTER MENU   **************************************************//
    updateCounter: function ( name, value ) {
        this.counters[ name ].update( "counter", value );
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function () {
        return [];
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.Element, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.Element, SHINKEN.OBJECT.ShinkenObjectHtml );

WINDOW.ElementWithProperties           = function ( name, dom_element, is_menu ) {
    this.__class_name__ = "WINDOW.ElementWithProperties";
    
    //id
    //dom_element_target
    //counters
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.ElementWithProperties.prototype = {
    hasProperties: function () {
        return true;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementWithProperties, WINDOW.Element );