#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2023:
# This file is part of Shinken Enterprise, all rights reserved.


import hashlib

BUF_SIZE = 65536  # read file in 64kb chunks!


def hash_file(file_path):
    # type: (str) -> str
    
    sha1 = hashlib.sha1()
    
    with open(file_path, 'rb') as f:
        while True:
            data = f.read(BUF_SIZE)
            if not data:
                break
            sha1.update(data)
    
    return sha1.hexdigest()


def hash_data(data):
    # type: (bytes) -> str
    
    sha1 = hashlib.sha1()
    sha1.update(data)
    
    return sha1.hexdigest()
