#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2023:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from shinkensolutions.logs.logger_abstract import LoggerAbstract

if TYPE_CHECKING:
    from typing import Optional


class LoggerSession(LoggerAbstract):
    FORMATS = [
        ('log_time', '[ %(log_time)s ]'),
        ('mode', '[ %(mode)-5s ]'),
        ('type_request', '[ %(type_request)-6s ]'),
        ('result_code', '[ RESULT:--- ]'),
        ('run_time', '[ TIME:   0ms ]'),
        ('user_info', '[ USER:%(user_info)-9s ]'),
        ('requester_ip', '[ CALL_BY:%(requester_ip)-15s ]'),
        ('requester_module', '[ BY:%(requester_module)s ]'),
        ('session_message', '[ ALREADY AUTHENTICATED USERS, START A SESSION %(session_message)s]'),
        ('error', '[ ERROR:%(error)-9s ]'),
    ]
    
    
    def start_session(self, user_uuid, user_name, requester_ip, requester_module=None):
        # type: (str, str, str, Optional[str]) -> None
        if not self.log_enable or not self._logger:
            return
        log_data = self._build_common_log_data(
            user_uuid=user_uuid,
            user_name=user_name,
            result_code=0,
            requester_ip=requester_ip,
            requester_module=requester_module,
            session_message=''
        )
        
        log_data.update({
            'type_request': 'SESSION',
        })
        
        self._log(self._build_message(log_data, self.FORMATS))
