#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024:
# This file is part of Shinken Enterprise, all rights reserved.

import cProfile
import contextlib
import sys


class Profiler(contextlib.ContextDecorator):
    def __init__(self, file_name: str):
        self.file_name = file_name
        self.pr = cProfile.Profile()
    
    
    def __enter__(self):
        self.pr.enable()
    
    
    def __exit__(self, exc_type, exc_val, exc_tb):
        self.pr.disable()
        self.pr.dump_stats(self.file_name)


def profile(file_name: str):
    return Profiler(file_name)


def get_func_name() -> str:
    # We skip this inspection because we only use CPython
    # noinspection PyUnresolvedReferences
    # noinspection PyProtectedMember
    return sys._getframe(1).f_code.co_name


def get_caller_name() -> str:
    # We skip this inspection because we only use CPython
    # noinspection PyUnresolvedReferences
    # noinspection PyProtectedMember
    return sys._getframe(2).f_code.co_name
