#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2023:
# This file is part of Shinken Enterprise, all rights reserved.

from html.parser import HTMLParser

from lxml.html.clean import Cleaner

from shinkensolutions.toolbox.box_tools_string import ToolsBoxString


class ShinkenHtmlParser(HTMLParser):
    def __init__(self):
        HTMLParser.__init__(self)
        self._has_html = False
    
    
    def handle_starttag(self, tag, attrs):
        self._has_html = True
    
    
    def handle_endtag(self, tag):
        self._has_html = True
    
    
    def has_html(self):
        return self._has_html


class ToolsBoxHTML:
    
    @staticmethod
    def prepare_thresholds_display_final_value(resolved_value, has_html):
        # type: (str, bool) -> str
        if not has_html and resolved_value:
            # If the value contains HTML, we don't want to interpret "\n".
            resolved_value = '<div style="white-space: pre-wrap;">%s</div>' % resolved_value
        
        return resolved_value
    
    
    @staticmethod
    def property_has_html(property_value):
        # type: (str) -> bool
        shinken_html_parser = ShinkenHtmlParser()
        shinken_html_parser.feed(property_value)
        return shinken_html_parser.has_html()
    
    
    @staticmethod
    def remove_script(string_html):
        # type: (str) -> str
        cleaner = Cleaner(style=False, safe_attrs_only=False)
        cleaner.kill_tags = ['img']
        try:
            return cleaner.clean_html(string_html)
        except:
            return ToolsBoxString.escape_XSS(string_html)
