
@echo off

setlocal


for /f "delims=" %%A in ('powershell -Command "Get-Date -Format 'MM/dd/yyyy/HH/mm/ss'"') do (
    set "dateTime=%%A"
)

for /f "tokens=1-6 delims=/" %%A in ("%dateTime%") do (
    set "MM=%%A"
    set "DD=%%B"
    set "YY=%%C"
    set "HH=%%D"
    set "MN=%%E"
    set "SS=%%F"
)

set "timestamp=%YY%-%DD%-%MM%__%HH%h%MN%m%SS%"



:: Log file
set LOGFILE=C:\shinken\var\versions_installations\update__shinken_enterprise.log.%timestamp%
set LOGFILE-DETAIL=C:\shinken\var\versions_installations\update__shinken_enterprise_detail.log.%timestamp%

:: Path to the file you want to check
set FILE_PATH=C:\shinken\var\context.json

mkdir C:\shinken >nul 2>&1
mkdir C:\shinken\var\ >nul 2>&1
mkdir C:\shinken\var\versions_installations >nul 2>&1


for /f "delims=" %%i in ('powershell -File InstallFiles\get_shinken_version.ps1') do set "jsonValue=%%i"

echo -------------Starting Shinken Windows Poller update-------------------------------
echo.
echo -------------Starting Shinken Windows Poller update------------------------------- >> %LOGFILE%


echo This installer is designed to update the Windows Shinken Poller to the version  %jsonValue%
echo.
echo This installer is designed to update the Windows Shinken Poller to the version  %jsonValue% >> %LOGFILE%


echo -------------System checks--------------------------------------------------------
echo.
echo -------------System checks-------------------------------------------------------- >> %LOGFILE%



echo Assert administrator rights
echo.
echo Assert administrator rights >> %LOGFILE%

net session >nul 2>&1 >>%LOGFILE-DETAIL% 2>&1
if %errorLevel% neq 0 (
    echo [ERROR] You must run this script with administrator rights.
    echo [ERROR] You must run this script with administrator rights. >> %LOGFILE%
    exit /b 1
)
echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%


echo Assert Shinken on the System
echo.
echo Assert Shinken on the System >> %LOGFILE%
if not exist %FILE_PATH% (
    echo [ERROR] Shinken Poller is not installed on your machine. Use install.cmd if you want to install Shinken.
    echo [ERROR] Shinken Poller is not installed on your machine. Use install.cmd if you want to install Shinken. >> %LOGFILE%
    exit /b 1
)
echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%



echo Assert Shinken-Poller stopped
echo.
echo Assert Shinken-Poller stopped >> %LOGFILE%
:: Query the service status and check if it is running
sc query "Shinken-Poller" | find /C "RUNNING" >nul 2>&1
if %errorlevel% equ 0 (
    echo [ERROR] Shinken-Poller is running. Stop the service before updating it.
    echo [ERROR] Shinken-Poller is running. Stop the service before updating it.  >> %LOGFILE%
    exit /b 1
)


echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%


echo -------------Updating Shinken Enterprise to version %jsonValue%-------------------
echo.
echo -------------Updating Shinken Enterprise to version %jsonValue%------------------- >> %LOGFILE%



echo Updating Python 3.11.11
echo.
echo Updating Python 3.11.11 >> %LOGFILE%

InstallFiles\python-3.11.11-amd64.exe /quiet /passive InstallAllUsers=1 Include_tcltk=0 DefaultAllUsersTargetDir=c:\Python311 SimpleInstall=1 >>%LOGFILE-DETAIL% 2>&1

if %errorlevel% neq 0 (
    echo [ERROR] Failed to update Python 3.11
	echo [ERROR] Failed to update Python 3.11 >> %LOGFILE%
    exit /b 1
)

echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%


echo Updating Shinken dependencies
echo.
echo Updating Shinken dependencies >> %LOGFILE%

dir /s /b "InstallFiles\*.whl" > InstallFiles/requirements.txt
c:\Python311\Scripts\pip.exe install -r InstallFiles\requirements.txt --no-warn-script-location --no-index --find-links=InstallFiles >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to install Python packages
	echo [ERROR] Failed to install Python packages >> %LOGFILE%
    exit /b 1
)

echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%

echo Removing previous Shinken Package
echo.
echo Removing previous Shinken Package >> %LOGFILE%


rmdir /s/q C:\shinken\shinken >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to remove shinken directory
    echo [ERROR] Failed to remove shinken directory >> %LOGFILE%
    exit /b 1
)

rmdir /s/q C:\shinken\bin >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to remove bin directory
    echo [ERROR] Failed to remove bin directory >> %LOGFILE%
    exit /b 1
)

rmdir /s/q C:\shinken\modules >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to remove modules directory
    echo [ERROR] Failed to remove modules directory >> %LOGFILE%
    exit /b 1
)

rmdir /s/q C:\Python311\Lib\site-packages\shinkensolutions >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to remove shinkensolutions directory
    echo [ERROR] Failed to remove shinkensolutions directory >> %LOGFILE%
    exit /b 1
)


echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%



echo Installing new Shinken Package
echo.
echo Installing new Shinken Package >> %LOGFILE%

:: Copy Shinken, modules ,bin and ,Shinkensolutions directories
xcopy /E /I /Y  .\shinken\shinken C:\shinken\shinken >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to copy Shinken directory
    echo [ERROR] Failed to copy Shinken directory >> %LOGFILE%
    exit /b 1
)

xcopy /E /I /Y  .\shinken\modules C:\shinken\modules >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to copy modules directory
    echo [ERROR] Failed to copy modules directory >> %LOGFILE%
    exit /b 1
)

xcopy /E /I /Y .\shinken\bin C:\shinken\bin >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to copy bin directory
    echo [ERROR] Failed to copy bin directory >> %LOGFILE%
    exit /b 1
)

xcopy /E /I /Y  .\shinkensolutions C:\Python311\Lib\site-packages\shinkensolutions >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to copy Shinken solutions directory
    echo [ERROR] Failed to copy Shinken solutions directory >> %LOGFILE%
    exit /b 1
)

echo F | xcopy /Y  .\InstallFiles\openssl.cnf C:\shinken\etc\openssl.cnf >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to copy openssl.cnf >> %LOGFILE%
    echo [ERROR] Failed to copy openssl.cnf
    exit /b 1
)

echo F | xcopy /Y  .\InstallFiles\context.json C:\shinken\var\context.json >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to copy context.json
    echo [ERROR] Failed to copy context.json >> %LOGFILE%
    exit /b 1
)


reg add "HKLM\SYSTEM\CurrentControlSet\services\Shinken-Poller\Parameters" /v Application /t REG_SZ /d "c:\Python311\python.exe" /f >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to add Application registry value
	echo [ERROR] Failed to add Application registry value >> %LOGFILE%
    exit /b 1
)

reg add "HKLM\SYSTEM\CurrentControlSet\services\Shinken-Poller\Parameters" /v AppDirectory /t REG_SZ /d "c:\shinken" /f >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to add AppDirectory registry value
	echo [ERROR] Failed to add AppDirectory registry value >> %LOGFILE%
    exit /b 1
)

reg add "HKLM\SYSTEM\CurrentControlSet\services\Shinken-Poller\Parameters" /v AppParameters /t REG_SZ /d "-X utf8 c:\shinken\bin\shinken-poller -c c:\shinken\etc\daemons\pollerd-windows.ini" /f >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to add AppParameters registry value
	echo [ERROR] Failed to add AppParameters registry value >> %LOGFILE%
    exit /b 1
)

reg add "HKLM\SYSTEM\CurrentControlSet\services\Shinken-Poller" /v Environment /t REG_MULTI_SZ /d "OPENSSL_CONF=C:\shinken\etc\openssl.cnf" /f >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
	echo [ERROR] Failed to add Environment registry value
    echo [ERROR] Failed to add Environment registry value >> %LOGFILE%
    exit /b 1
)

echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%


echo Launching sanitize
echo.
echo Launching sanitize >> %LOGFILE%

c:\Python311\python.exe c:\shinken\bin\sanitize-data.py >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
	echo [ERROR] Failed to run sanitize
    echo [ERROR] Failed to run sanitize >> %LOGFILE%
    exit /b 1
)

echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%


echo Starting Shinken Service
echo.
echo Starting Shinken Service >> %LOGFILE%


net start Shinken-Poller >>%LOGFILE-DETAIL% 2>&1
if %errorlevel% neq 0 (
    echo [ERROR] Failed to start Shinken-Poller service
	echo [ERROR] Failed to start Shinken-Poller service >> %LOGFILE%
    exit /b 1
)


echo --^> OK
echo.
echo --^> OK >> %LOGFILE%
echo. >> %LOGFILE%




echo -------------Shinken Windows Poller update completed------------------------------
echo.
echo -------------Shinken Windows Poller update completed------------------------------ >> %LOGFILE%



exit /b 0


endlocal
