#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinkensolutions.api.synchronizer.source.route.route import AbstractRoute
    from shinken.misc.type_hint import Dict


class RouteContainer:
    
    def __init__(self):
        self._routes = {}  # type: Dict[str, AbstractRoute]
    
    
    def __iter__(self):
        return iter(self._routes.values())
    
    
    def __str__(self):
        return 'RouteContainer:[routes:[%s]]' % (
            self._routes,
        )
    
    
    def __repr__(self):
        return self.__str__()
    
    
    def add(self, route_name, route):
        # type: (str, AbstractRoute) -> None
        self._routes[route_name] = route
    
    
    def get(self, route_name):
        return self._routes[route_name]
