#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.


from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict
    from shinkensolutions.api.synchronizer.source.route.route_container import RouteContainer
    from shinkensolutions.api.synchronizer.source.tab.tab import AbstractTab


class TabContainer:
    
    def __init__(self, route_container):
        # type: (RouteContainer) -> None
        self._tabs = {}  # type: Dict[str, AbstractTab]
        self._route_container = route_container
    
    
    def __iter__(self):
        return iter(self._tabs.values())
    
    
    def add(self, tab_name, tab):
        # type: (str, AbstractTab) -> None
        self._tabs[tab_name] = tab
        self._route_container.add(tab_name, tab)
    
    
    def get(self, tab_name):
        return self._tabs[tab_name]
