#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2019:
# This file is part of Shinken Enterprise, all rights reserved.

from ..component.option_select import OptionSelectAbstractComp


class OptionSelectPropertyComp(OptionSelectAbstractComp):
    def __init__(self, property_name, value, option_type, label=''):
        # type: (str, str, str, str)-> None
        super(OptionSelectPropertyComp, self).__init__(value)
        self._property_name = property_name
        self._value = value
        self._id = "%s__%s" % (self._property_name, self._value)
        self._label = label or self._value
        self._text = self._label
        self._extra_class = ''
        self._type = option_type
    
    
    # *****************************   GETTER SETTER  ************************************************************#
    def get_label(self):
        return self._label
    
    
    def get_id(self):
        return self._id
    
    
    def set_extra_class(self, to_set):
        # type: (str)-> None
        self._extra_class = to_set
    
    
    # *****************************   HTML  ************************************************************#
    def get_html(self, class_to_add=""):
        if self._is_selected:
            class_to_add = "shinken-selected shinken-select-no-events %s" % class_to_add
        _to_return = '<div class="shinken-option %s %s"' \
                     ' data-state="stagging"' \
                     ' data-key-name="%s"' \
                     ' data-key-label="%s"' \
                     ' data-type="%s"' \
                     ' onmouseenter="MANAGER.EventManager.mouseEnter(event)"' \
                     ' onmouseup="MANAGER.EventManager.clickOnItemSelector(event, \'%s\',this)" >' \
                     '<div class="shinken-selector-label shinken-space">%s</div>' \
                     '</div>' \
                     % (
                         class_to_add,
                         self._extra_class,
                         self._value,
                         self._label,
                         self._type,
                         self._property_name,
                         self._text
                     )
        return _to_return
