"use strict";
SHINKEN.TOOLS.TEST_AUTO_FILTERS = (function ( self ) {
    self.DOM                       = {};
    self.ACTION                    = {};
    self.TEST                      = {};
    //********************************************  DOM **************************************************//
    self.DOM.filters               = function ( dom_element_parent ) {
        return dom_element_parent.querySelector( '.shinken-filter-line' );
    };
    self.DOM.filter                = function ( filter_name ) {
        return document.querySelector( '.shinken-list-select-input[data-name="' + filter_name + '"]' );
    };
    self.DOM.filterInput           = function ( filter_name ) {
        return self.DOM.filter( filter_name ).querySelector( '.shinken-input' );
    };
    self.DOM.allSelector           = function ( dom_element_parent ) {
        return self.DOM.filters( dom_element_parent ).querySelectorAll( ".shinken-select-selector" );
    };
    self.DOM.allSelectorPopUp      = function ( dom_element_parent ) {
        return self.DOM.filters( dom_element_parent ).querySelectorAll( ".shinken-list-select" );
    };
    //********************************************  ACTION **************************************************//
    self.ACTION.clickOnInput       = function ( timeout, css_selector ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, document.querySelector( css_selector ) );
        }, timeout );
        return 200;
    };
    self.ACTION.moveAutoCursorDown = function ( timeout, filter_name, _avoid_next_phase ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.___dispatchKeyEvent( self.DOM.filterInput( filter_name ), "keydown", 'ArrowDown', 40 );
        }, timeout );
        return 500;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.validation_value     = function ( timeout, filter_name, nb_error_expected, nb_warning_expected, value ) {
        setTimeout( function () {
            var _filter = MANAGER.__instance_filter_distributor.getElement( filter_name );
            if ( !value ) {
                value = _filter.component.input.getDomValue();
            }
            var _input = __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ? _filter.component.input.dom_element : _filter.component.input.dom_element_input;
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _filter.component.input.getCounterError().getValue(), nb_error_expected, "Error pour <span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( value ) + "</span> => " );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _filter.component.input.getCounterWarning().getValue(), nb_warning_expected, "Warning pour <span class='shinken-data-user'>" + SHINKEN.TOOLS.STRING.cleanXss( value ) + "</span> => " );
            if ( nb_error_expected ) {
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _input, "backgroundColor", "rgb(253, 3, 0)" );
            }
            else if ( nb_warning_expected ) {
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _input, "backgroundColor", "rgb(253, 132, 3)" );
            }
        }, timeout );
        return 1000;
    };
    self.TEST.hasValue             = function ( timeout, filter_name, value ) {
        setTimeout( function () {
            var _filter = MANAGER.__instance_filter_distributor.getElement( filter_name );
            var _input  = __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ? _filter.component.input.dom_element : _filter.component.input.dom_element_input;
            SHINKEN.TOOLS.TEST_AUTO.___isVariableEqualsTo( _input, 'value', value, filter_name + " :" );
        }, timeout );
        return 200;
    };
    self.TEST.allSelectHideOrShow  = function ( timeout, dom_element_list, nb_select ) {
        setTimeout( function () {
            var _doms_selectors         = self.DOM.allSelector( dom_element_list );
            var _doms_selectors_poop_up = self.DOM.allSelectorPopUp( dom_element_list );
            for ( var i = 0; i < nb_select; i++ ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( i * 1000, _doms_selectors[ i ] );
                for ( var j = 0; j < nb_select; j++ ) {
                    SHINKEN.TOOLS.TEST_AUTO_DOM.visibility( i * 1000 + 300, _doms_selectors_poop_up[ j ], "selector " + j, i === j );
                }
            }

        }, timeout );
        return nb_select * 1400;
    };
    
    return self;
})
( SHINKEN.TOOLS.TEST_AUTO_FILTERS || {} );

