"use strict";
SHINKEN.TOOLS.TEST_AUTO_LIVEDATA = (function ( self ) {
    self.ACTION   = {};
    self.TEST     = {};
    self.COMMON   = {};
    var _INTERNAL = {};
    
    //********************************************  ACTION   **************************************************//
    
    self.ACTION.setEnableLivedata        = function ( timeout, to_set ) {
        var to_return = 0;
        if ( to_set ) {
            to_return += SHINKEN.TOOLS.TEST_AUTO_DAEMON.COMMON.ACTION.addModuleIfNotSet( timeout, "/etc/shinken/brokers/broker-master.cfg ", "broker-module-livedata" );
        }
        else {
            console.log( "FGAR", "[ - setEnableLivedata]", "TODO faire la fonction qui permet de retirer un module" );
        }
        return to_return;
    };
    self.ACTION.changeLivedataApiVersion = function ( timeout, api_version ) {
        return SHINKEN.TOOLS.TEST_AUTO_DAEMON.COMMON.ACTION.editInConfigFile( timeout, "/etc/shinken/modules/broker-module-livedata.cfg", "broker__module_livedata__api_version", api_version );
    };
    self.TEST.livedataResultContainKey   = function ( timeout, endpoint, to_test, api_version ) {
        var _command;
        if ( api_version === 1 ) {
            _command = "curl -s -S http://localhost:50100/api/v" + api_version + endpoint + "?token=test_auto";
        }
        else {
            _command = "curl -s -S -H \"x-api-token:test_auto\" -d \"output_field=" + to_test + "\" http://localhost:50100/api/v" + api_version + endpoint;
        }
        var _grep_success = function ( _status, data ) {
            if ( !SHINKEN.TOOLS.STRING.contains( data.stdout, to_test ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "La clé demandée n'a pas été demandée par le livedata" );
            }
        };
        var _error        = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _grep_success, _error );
    };
    self.TEST.result   = function ( timeout, endpoint, key, value, api_version ) {
        var _command;
        if ( api_version === 1 ) {
            _command = "curl -s -S http://localhost:50100/api/v" + api_version + endpoint + "?token=test_auto";
        }
        else {
            _command = "curl -s -S -H \"x-api-token:test_auto\" -d \"output_field=" + key + "\" http://localhost:50100/api/v" + api_version + endpoint;
        }
        var _grep_success = function ( _status, data ) {
            var _data_to_dict = JSON.parse(data.stdout);
            if ( _data_to_dict[key] !== value ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "La clé ["+ key + "] n'a pas la valeur [" + value + "]" );
            }
        };
        var _error        = function ( err ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( err );
            SHINKEN.TOOLS.TEST_AUTO.addError( "IS SERVER FLASK RUNNING ??" );
        };
        SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( timeout, _command, _grep_success, _error );
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_LIVEDATA || {} );
