"use strict";

SHINKEN.TOOLS.TEST_AUTO.Addons           = function ( data ) {
    this.init( data );
};
SHINKEN.TOOLS.TEST_AUTO.Addons.prototype = {
    //********************************************  INIT  *****************************************************//
    init       : function ( data ) {
        this.initContents();
        this.parseData( data );
    },
    parseData  : function ( data ) {
        let lines = data.split( '\n' );
        for ( let i = 0, _size_i = lines.length; i < _size_i; i++ ) {
            if ( lines[ i ].length === 0 ) {
                continue;
            }
            this.add( new SHINKEN.TOOLS.TEST_AUTO.Addon( lines[ i ] ) );
        }
        
    },
    getNumberEnabledAndDisabled: function () {
        
        let enable_count  = 0;
        let disable_count = 0;
        
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            switch ( this.contents[ i ].getState() ) {
                case "ENABLED":
                    enable_count++;
                    break;
                case "DISABLED":
                    disable_count++;
                    break;
            }
        }
        return { "enable_count": enable_count, "disable_count": disable_count };
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.TEST_AUTO.Addons, SHINKEN.OBJECT.ShinkenObjectContainer );

SHINKEN.TOOLS.TEST_AUTO.Addon           = function ( data ) {
    this.init( data );
};
SHINKEN.TOOLS.TEST_AUTO.Addon.prototype = {
    //********************************************  INIT  *****************************************************//
    init: function ( line_to_parse ) {
        this.line_string = line_to_parse;
        let parsed_line  = line_to_parse.replace( /\u001b\[.*?m/g, "" ).split( ":" );
        this.name        = parsed_line[ 0 ].trim();
        this.state       = parsed_line[ 1 ].trim();
    },
    
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID : function () {
        return this.line_string;
    },
    getState: function () {
        return this.state;
    },
    getName : function () {
        return this.name;
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.TEST_AUTO.Addon, SHINKEN.OBJECT.ShinkenObject );