"use strict";

SHINKEN.TOOLS.TEST_AUTO.Daemons           = function ( data ) {
    this.init( data );
};
SHINKEN.TOOLS.TEST_AUTO.Daemons.prototype = {
    //********************************************  INIT  *****************************************************//
    init        : function ( data ) {
        this.initContents();
        this.parseData( data );
    },
    parseData   : function ( data ) {
        let lines = data.split( '\n' );
        for ( let i = 0, _size_i = lines.length; i < _size_i; i++ ) {
            if ( lines[ i ].length === 0 ) {
                continue;
            }
            this.add( new SHINKEN.TOOLS.TEST_AUTO.Daemon( lines[ i ] ) );
        }
        
    },
    getNumberEnabledAndDisabled: function () {
        
        
        let enable_count  = 0;
        let disable_count = 0;
        
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            switch ( this.contents[ i ].getState() ) {
                case "ENABLED":
                    enable_count++;
                    break;
                case "DISABLED":
                    disable_count++;
                    break;
            }
        }
        return { "enable_nb": enable_count, "disable_nb": disable_count };
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getDaemonByName ( daemon_name ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].getName() === daemon_name ) {
                return this.contents[ i ];
            }
        }
        return false;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.TEST_AUTO.Daemons, SHINKEN.OBJECT.ShinkenObjectContainer );

SHINKEN.TOOLS.TEST_AUTO.Daemon           = function ( data ) {
    this.init( data );
};
SHINKEN.TOOLS.TEST_AUTO.Daemon.prototype = {
    //********************************************  INIT  *****************************************************//
    init: function ( line_to_parse ) {
        this.line_string    = line_to_parse;
        line_to_parse       = line_to_parse.replace( /\u001b\[.*?m/g, "" );
        this.id             = SHINKEN.TOOLS.STRING.extractBetween( line_to_parse, "id:", "]" ).trim();
        this.type           = line_to_parse.slice( 2, 15 ).trim();
        this.name           = SHINKEN.TOOLS.STRING.extractBetween( line_to_parse, "]", ":" ).trim();
        this.state          = SHINKEN.TOOLS.STRING.extractBetween( line_to_parse, " : ", " | " ).trim();
        this.configFilepath = line_to_parse.slice( line_to_parse.indexOf( "in:" ) + 3 ).trim();
    },
    
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID          : function () {
        return this.line_string;
    },
    getState         : function () {
        return this.state;
    },
    getName          : function () {
        return this.name;
    },
    getConfigFilepath: function () {
        return this.configFilepath;
    },
    getId            : function () {
        return this.id;
    },
    getType          : function () {
        return this.type;
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.TOOLS.TEST_AUTO.Daemon, SHINKEN.OBJECT.ShinkenObject );