"use strict";
TI.PROPERTY.INPUT_STRING = (function ( self ) {
    self.DOM                       = {};
    self.TEST                      = {};
    self.ACTION                    = {};
    //********************************************  GET DOM ELEMENT   ****************************************//
    self.DOM.input                 = function ( property_name ) {
        return TI.PROPERTY.DOM.actionCell( property_name ).querySelector( ".shinken-input-V3" );
    };
    self.DOM.inputBroom            = function ( property_name ) {
        return TI.PROPERTY.DOM.actionCell( property_name ).querySelector( ".shinken-icon-delete-input" );
    };
    //********************************************  TEST   **************************************************//
    self.TEST.hasValue__20250225 = function ( timeout, property_name, text_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.input( property_name ), text_expected );
        }, timeout );
        return 100;
    };
    self.TEST.display__20250213 = function ( timeout, property_name, display_expected ) {
        setTimeout( function () {
            let dom_input = self.DOM.input( property_name );
            switch ( display_expected ) {
                case TI.PROPERTY.RADIO.WITH_INPUT.CONST.INPUT.DISPLAY.WITH_ERRORS:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "backgroundColor", "rgb(253, 123, 123)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "color", "rgb(255, 255, 255)" );
                    break;
            }
        }, timeout );
        return 100;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.setValue__20250205 = function ( timeout, property_name, value_to_set ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "PROPERTY.INPUT_STRING.setValue", property_name + " ->  " + value_to_set );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( 0, self.DOM.input( property_name ), value_to_set );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.cleanWithButton    = function ( timeout, property_name ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY.INPUT_STRING.cleanWithButton', property_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.inputBroom( property_name ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    return self;
})( TI.PROPERTY.INPUT_STRING || {} );