"use strict";
TI.PROPERTY.RADIO.WITH_INPUT = (function ( self ) {
    self.DOM                       = {};
    self.TEST                      = {};
    self.ACTION                    = {};
    self.CONST                     = {
        INPUT: {
            DISPLAY: {
                NORMAL      : "normal",
                NORMAL_FOCUS: "normal_focus",
                WITH_ERRORS : "with_errors"
            }
        }
    };
    //********************************************  DOM  ****************************************//
    self.DOM.input                 = function ( property_name ) {
        return TI.PROPERTY.RADIO.DOM.radio( property_name, SHINKEN.OBJECT.RADIOMODE.RADIO_INPUT ).querySelector( ".shinken-input-V3" );
    };
    self.DOM.inputBroom            = function ( property_name ) {
        return TI.PROPERTY.RADIO.DOM.radio( property_name, SHINKEN.OBJECT.RADIOMODE.RADIO_INPUT ).querySelector( ".shinken-icon-delete-input" );
    };
    //********************************************  TEST   ****************************************//
    self.TEST.inputDisplay         = function ( timeout, property_name, display_expected ) {
        setTimeout( function () {
            let dom_input = self.DOM.input( property_name );
            switch ( display_expected ) {
                case self.CONST.INPUT.DISPLAY.NORMAL:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "backgroundColor", "rgb(255, 255, 255)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "color", "rgb(85, 85, 85)" );
                    break;
                case self.CONST.INPUT.DISPLAY.NORMAL_FOCUS:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "backgroundColor", "rgba(119, 165, 255, 0.2)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "color", "rgb(85, 85, 85)" );
                    break;
                case self.CONST.INPUT.DISPLAY.WITH_ERRORS:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "backgroundColor", "rgb(253, 123, 123)" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "color", "rgb(255, 255, 255)" );
                    break;
            }
        }, timeout );
        return 100;
    };
    self.TEST.inputValue__20250129 = function ( timeout, property_name, value_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.input( property_name ), value_expected, "input value " + property_name );
        }, timeout );
        return 100;
    };
    //********************************************  ACTION   ****************************************//
    self.ACTION.setValueInput      = function ( timeout, property_name, value_to_set ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY.RADIO.WITH_INPUT', property_name + " --> " + value_to_set );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( 0, self.DOM.input( property_name ), value_to_set );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.cleanWithButton    = function ( timeout, property_name ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY.RADIO.WITH_INPUT cleanWithButton', property_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.inputBroom( property_name ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    return self;
})( TI.PROPERTY.RADIO.WITH_INPUT || {} );