"use strict";
TI.PROPERTY.RADIO = (function ( self ) {
    self.DOM                     = {};
    self.TEST                    = {};
    self.ACTION                  = {};
    self.CONST                   = {
        RADIO: {
            DISPLAY: {
                NORMAL     : "normal",
                SELECTED   : "selected",
                WITH_ERRORS: "with_errors"
            }
        }
    };
    //********************************************  DOM  ****************************************//
    self.DOM.radio               = function ( property_name, radio_name ) {
        return TI.PROPERTY.DOM.line( property_name ).querySelector( ".shinken-radio-mode[data-name='" + radio_name + "']" );
    };
    self.DOM.radioLabel          = function ( property_name, radio_name ) {
        return self.DOM.radio( property_name, radio_name ).querySelector( ".shinken-title-zone .shinken-title-zone-left .shinken-label-container" );
    };
    self.DOM.radioCheck          = function ( property_name, radio_name ) {
        return self.DOM.radio( property_name, radio_name ).querySelector( ".shinken-checked-svg" );
    };
    //********************************************  TEST  ****************************************//
    self.TEST.radioDisplay       = function ( timeout, property_name, display_expected, radio_name ) {
        setTimeout( function () {
            let dom_input = self.DOM.radioLabel( property_name, radio_name );
            switch ( display_expected ) {
                case self.CONST.RADIO.DISPLAY.NORMAL:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "color", "rgb(138, 138, 138)" );
                    break;
                case self.CONST.RADIO.DISPLAY.WITH_ERRORS:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "color", "rgb(255, 0, 0)" );
                    break;
                case self.CONST.RADIO.DISPLAY.SELECTED:
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( dom_input, "color", "rgb(0, 0, 0)" );
                    break;
            }
        }, timeout );
        return 100;
    };
    self.TEST.isSelect__20250204 = function ( timeout, property_name, radio_name ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( self.DOM.radioCheck( property_name, radio_name ) );
        }, timeout );
        return 300;
    };
    //********************************************  ACTION   ****************************************//
    self.ACTION.setValue         = function ( timeout, property_name, value_to_set ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY.RADIO.WITH_INPUT', property_name + " --> " + value_to_set );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click_V2( self.DOM.radio( property_name, value_to_set ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    return self;
})( TI.PROPERTY.RADIO || {} );