"use strict";
TI.WEATHER.FORM.DEFAULT = (function ( self ) {
    self.DOM                                                     = {};
    self.DOM.WEATHER                                             = {};
    self.TEST                                                    = {};
    self.TEST.WEATHER                                            = {};
    self.TEST.WEATHER.PREVIEW                                    = {};
    self.ACTION                                                  = {};
    self.ACTION.WEATHER                                          = {};
    self.ACTION.WEATHER.PREVIEW                                  = {};
    self.ACTION.WEATHER.PREVIEW.LEFT_AREA                        = {};
    self.ACTION.WEATHER.PREVIEW.SLA_AREA                         = {};
    self.ACTION.WEATHER.PREVIEW.NAME_AREA                        = {};
    self.ACTION.WEATHER.PREVIEW.TOP_RIGHT_AREA                   = {};
    self.CONST                                                   = {
        PREVIEW_WIDGET: {
            ZONE: {
                LEFT     : "form_default__zones__left_area",
                NAME     : "form_default__zones__name_area",
                TOP_RIGHT: "form_default__zones__top_right_area",
                SLA      : "form_default__zones__sla_area"
            }
        },
        STATE_DISPLAY : {
            HIDDEN : 0,
            VISIBLE: 1
        },
        ICON_DISPLAY  : {
            STATUS            : "STATUS",
            STATUS_AND_CONTEXT: "STATUS_AND_CONTEXT",
            QUALITY_SERVICE   : "QUALITY_SERVICE",
            TENDENCY          : "TENDENCY"
        },
        ICON_SLA      : {
            SLA_ICON    : "SLA_ICON",
            SLA_TENDENCY: "SLA_TENDENCY"
        }
    };
    //********************************************  DOM  ****************************************//
    self.DOM.form                                                = function () {
        return document.querySelector( ".shinken-tab-pane[data-name='edit_tab_default']" );
    };
    self.DOM.WEATHER.form                                        = function () {
        return self.DOM.form().querySelector( ".shinken-collapse-folder[data-name='cf_weather_default_widget_part']" );
    };
    self.DOM.WEATHER.widgetPreview                               = function () {
        return self.DOM.WEATHER.form().querySelector( ".shinken-widget" );
    };
    self.DOM.WEATHER.widgetPreview__zoneLeft                     = function () {
        return self.DOM.WEATHER.widgetPreview().querySelector( ".shinken-cell-left-area" );
    };
    self.DOM.WEATHER.widgetPreview__zoneName                     = function () {
        return self.DOM.WEATHER.widgetPreview().querySelector( ".shinken-cell-name" );
    };
    self.DOM.WEATHER.widgetPreview__zoneTopRight                 = function () {
        return self.DOM.WEATHER.widgetPreview().querySelector( ".shinken-cell-top-right-area" );
    };
    self.DOM.WEATHER.widgetPreview__zoneSla                      = function () {
        return self.DOM.WEATHER.widgetPreview().querySelector( ".shinken-cell-sla" );
    };
    self.DOM.WEATHER.widgetPreview__zone                         = function ( zone_area ) {
        let to_return;
        switch ( zone_area ) {
            case self.CONST.PREVIEW_WIDGET.ZONE.LEFT:
                return self.DOM.WEATHER.widgetPreview__zoneLeft();
            case self.CONST.PREVIEW_WIDGET.ZONE.NAME:
                return self.DOM.WEATHER.widgetPreview__zoneName();
            case self.CONST.PREVIEW_WIDGET.ZONE.TOP_RIGHT:
                return self.DOM.WEATHER.widgetPreview__zoneTopRight();
            case self.CONST.PREVIEW_WIDGET.ZONE.SLA:
                return self.DOM.WEATHER.widgetPreview__zoneSla();
        }
    };
    self.DOM.WEATHER.widgetPreview__zoneMask                     = function ( zone_area ) {
        return self.DOM.WEATHER.widgetPreview__zone( zone_area ).querySelector( ".shinken-grid-cell-mask-container-preview" );
    };
    self.DOM.WEATHER.iconContainer                               = function ( zone_area ) {
        return self.DOM.WEATHER.widgetPreview__zone( zone_area ).querySelector( ".shinken-icon-container" );
    };
    //********************************************  TEST   **************************************************//
    self.TEST.WEATHER.PREVIEW.isLabel__20250131                  = function ( timeout, text_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.WEATHER.widgetPreview__zoneName(), text_expected );
        }, timeout );
        return 200;
    };
    self.TEST.WEATHER.PREVIEW.hasBackgroundColor__20250131       = function ( timeout, color_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.WEATHER.widgetPreview(), "backgroundColor", color_expected );
        }, timeout );
        return 200;
    };
    self.TEST.WEATHER.PREVIEW.stateArea__20250131                = function ( timeout, widget_area, state ) {
        setTimeout( function () {
            var _dom_element = self.DOM.WEATHER.widgetPreview__zone( widget_area );
            switch ( state ) {
                case self.CONST.STATE_DISPLAY.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNoWidth( 0, _dom_element, widget_area );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_element, widget_area );
                    break;
            }
        }, timeout );
        return 300;
    };
    self.TEST.WEATHER.PREVIEW.iconType__20250203                 = function ( timeout, widget_area, icon_type ) {
        setTimeout( function () {
            const _dom = self.DOM.WEATHER.iconContainer( widget_area );
            switch ( icon_type ) {
                case self.CONST.ICON_DISPLAY.STATUS:
                    SHINKEN.TOOLS.TEST_AUTO.___isExisting( _dom.querySelector( ".shinken-primary-icon" ) );
                    SHINKEN.TOOLS.TEST_AUTO.__doesntExist( _dom.querySelector( ".shinken-secondary-icon" ) );
                    break;
                case self.CONST.ICON_DISPLAY.STATUS_AND_CONTEXT:
                    SHINKEN.TOOLS.TEST_AUTO.___isExisting( _dom.querySelector( ".shinken-primary-icon" ) );
                    //SHINKEN.TOOLS.TEST_AUTO.___isExisting( _dom.querySelector( ".shinken-secondary-icon" ) );
                    break;
                case self.CONST.ICON_DISPLAY.QUALITY_SERVICE:
                    SHINKEN.TOOLS.TEST_AUTO.___isExisting( _dom.querySelector( ".shinken-primary-icon" ) );
                    SHINKEN.TOOLS.TEST_AUTO.___isExisting( _dom.querySelector( "svg" ) );
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO.addError( "UNKNOWN icon type [" + icon_type + "]" );
                    break;
            }
        }, timeout );
        return 200;
    };
    self.TEST.WEATHER.PREVIEW.SLAIcon__20250205                  = function ( timeout, widget_area, icon_type, should_be_show ) {
        setTimeout( function () {
            const _dom = self.DOM.WEATHER.widgetPreview__zone( widget_area );
            switch ( icon_type ) {
                case self.CONST.ICON_SLA.SLA_ICON:
                    if ( should_be_show ) {
                        SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom.querySelector( ".shinken-cell-sla-icon" ) );
                    }
                    else {
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _dom.querySelector( ".shinken-cell-sla-icon" ) );
                    }
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO.addError( "UNKNOWN icon type [" + icon_type + "]" );
                    break;
            }
        }, timeout );
        return 200;
    };
    self.TEST.WEATHER.PREVIEW.verticalAlign__20250204            = function ( timeout, widget_area, alignment ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.WEATHER.widgetPreview__zone( widget_area ).querySelector(".shinken-label"), "vertical-align", alignment );
        }, timeout );
        return 50;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnPreviewZone                               = function ( timeout, zone_area ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.clickOnPreviewZone", zone_area );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.WEATHER.widgetPreview__zoneMask( zone_area ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.WEATHER.PREVIEW.LEFT_AREA.clickLeftArea          = function ( timeout ) {
        return self.ACTION.clickOnPreviewZone( timeout, self.CONST.PREVIEW_WIDGET.ZONE.LEFT );
    };
    self.ACTION.WEATHER.PREVIEW.NAME_AREA.clickNameArea    = function ( timeout ) {
        return self.ACTION.clickOnPreviewZone( timeout, self.CONST.PREVIEW_WIDGET.ZONE.NAME );
    };
    self.ACTION.WEATHER.PREVIEW.SLA_AREA.clickSLAArea            = function ( timeout ) {
        return self.ACTION.clickOnPreviewZone( timeout, self.CONST.PREVIEW_WIDGET.ZONE.SLA );
    };
    self.ACTION.WEATHER.PREVIEW.TOP_RIGHT_AREA.clickTopRightArea = function ( timeout ) {
        return self.ACTION.clickOnPreviewZone( timeout, self.CONST.PREVIEW_WIDGET.ZONE.TOP_RIGHT );
    };
    self.ACTION.WEATHER.PREVIEW.NAME_AREA.clickNameArea          = function ( timeout ) {
        return self.ACTION.clickOnPreviewZone( timeout, self.CONST.PREVIEW_WIDGET.ZONE.NAME );
    };
    
    
    return self;
})
( TI.WEATHER.FORM.DEFAULT || {} );
