"use strict";
SHINKEN.TOOLS.TEST_AUTO_WEATHER = (function ( self ) {
    self.DOM                                = {};
    self.DOM.WIDGET                         = {};
    self.DOM.WIDGET.TITLE                   = {};
    self.DOM.WIDGET.SEPARATOR               = {};
    self.DOM.WIDGET.WEATHER                 = {};
    self.DOM.IFRAME                         = {};
    self.TEST                               = {};
    self.TEST.IFRAME                        = {};
    self.TEST.LINES                         = {};
    self.TEST.WIDGET                        = {};
    self.TEST.WIDGET.TITLE                  = {};
    self.TEST.WIDGET.SEPARATOR              = {};
    self.TEST.WIDGET.WEATHER                = {};
    self.TEST.WEATHER_GRID_CELL             = {};
    self.TEST.JS                            = {};
    self.ACTION                             = {};
    self.CONST                              = {
        STATE_DISPLAY    : {
            HIDDEN                           : 0,
            VISIBLE                          : 1,
            VISIBLE_AND_DISABLED             : 2,
            VISIBLE_AND_CHILDREN_DISABLED    : 3,
            VISIBLE_AND_DISABLED_AND_NO_EVENT: 4
        },
        WEATHER_GRID_CELL: {
            STATE: {
                HIDDEN               : 0,
                VISIBLE              : 1,
                HAS_WARNING          : 2,
                HAS_ERROR            : 3,
                HAS_WARNING_AND_ERROR: 4,
                PARTIALLY_VISIBLE    : 5,
                KEY                  : {
                    0: "HIDDEN",
                    1: "VISIBLE",
                    2: "HAS_WARNING",
                    3: "HAS_ERROR",
                    4: "HAS_WARNING_AND_ERROR"
                }
            }
        },
        ICON_DISPLAY     : {
            STATUS            : "STATUS",
            STATUS_AND_CONTEXT: "STATUS_AND_CONTEXT",
            QUALITY_SERVICE   : "QUALITY_SERVICE",
            TENDENCY          : "TENDENCY"
        },
        ICON_SLA         : {
            SLA_TENDENCY: "SLA_TENDENCY",
            SLA_ICON    : "SLA_ICON"
        }
    };
    //********************************************  GET DOM ELEMENT IFRAME  **************************************************//
    self.DOM.IFRAME.getIframe               = function () {
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document.querySelector( "#id-shinken-iframe" ).contentWindow.document;
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.pageContainer                  = function ( in_iframe ) {
        return in_iframe ? self.DOM.IFRAME.getIframe().querySelector( ".shinken-grid-page-container" ) : document.querySelector( ".shinken-grid-page-container" );
    };
    self.DOM.gridContainer                  = function ( in_iframe ) {
        return self.DOM.pageContainer( in_iframe ).querySelector( ".shinken-weather-page.shinken-grid-container" );
    };
    self.DOM.grid                           = function ( in_iframe ) {
        return self.DOM.gridContainer( in_iframe ).querySelector( ".shinken-grid" );
    };
    self.DOM.infoBar                        = function ( in_iframe ) {
        return self.DOM.pageContainer( in_iframe ).querySelector( ".shinken-info-bar" );
    };
    self.DOM.infoBarShinkenLogo             = function ( in_iframe ) {
        return self.DOM.infoBar( in_iframe ).querySelector( ".shinken-logo" );
    };
    self.DOM.infoBarGenerateAt              = function ( in_iframe ) {
        return self.DOM.infoBar( in_iframe ).querySelector( ".shinken-generate-at" );
    };
    self.DOM.infoBarTimer                   = function ( in_iframe ) {
        return self.DOM.infoBar( in_iframe ).querySelector( ".shinken-container-clock" );
    };
    self.DOM.infoBarSoundNotification       = function ( in_iframe ) {
        return self.DOM.infoBar( in_iframe ).querySelector( ".shinken-sound-notification-container" );
    };
    self.DOM.infoBarBlinkNotification       = function ( in_iframe ) {
        return self.DOM.infoBar( in_iframe ).querySelector( ".shinken-blink-notification-container" );
    };
    self.DOM.shinkenDraftPhaseAlert         = function ( in_iframe ) {
        return self.DOM.infoBar( in_iframe ).querySelector( ".shinken-draft-phase-container" );
    };
    self.DOM.shinkenWeatherPublishButton    = function ( in_iframe ) {
        return self.DOM.pageContainer( in_iframe ).querySelector( ".shinken-weather-publish-button-cell" );
    };
    self.DOM.shinkenWeatherHistoryTab       = function ( in_iframe ) {
        return self.DOM.pageContainer( in_iframe ).querySelector( '.shinken-window-element-V2[data-name="edit_tab_history"]' );
    };
    self.DOM.shinkenWeatherHistoryTabButton = function ( in_iframe ) {
        return self.DOM.pageContainer( in_iframe ).querySelector( '.shinken-window-element-V2[data-name="edit_tab_history"]' );
    };
    self.DOM.copyHistoryButton              = function ( in_iframe ) {
        return self.DOM.pageContainer( in_iframe ).querySelector( ".shinken-clipboard-container" );
    };
    self.DOM.weatherPaginationContainer     = function ( in_iframe ) {
        return self.DOM.pageContainer( in_iframe ).querySelector( ".shinken-pagination" );
    };
    self.DOM.getElement                     = function ( type_element, in_iframe ) {
        switch ( type_element ) {
            case "button_mode_edit":
            case "button_back_to_previous_preview":
            case "button_external_links":
            case "popup_external_links":
                return SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.DOM.getElement( type_element, in_iframe );
            case "logo_shinken":
                return self.DOM.infoBarShinkenLogo( in_iframe );
            case "generate_at":
                return self.DOM.infoBarGenerateAt( in_iframe );
            case "timer_icon":
                return self.DOM.infoBarTimer( in_iframe );
            case "sound_notification_container":
                return self.DOM.infoBarSoundNotification( in_iframe );
            case "blink_notification_container":
                return self.DOM.infoBarBlinkNotification( in_iframe );
            case "shinken-draft-phase-alert":
                return self.DOM.shinkenDraftPhaseAlert( in_iframe );
            case "publish_view":
                return self.DOM.shinkenWeatherPublishButton( in_iframe );
            case "weather_history_tab":
                return self.DOM.shinkenWeatherHistoryTab( in_iframe );
            case "weather_history_pagination_container":
                return self.DOM.weatherPaginationContainer( in_iframe );
        }
    };
    self.DOM.getAllWidgets                  = function () {
        return self.DOM.pageContainer().querySelectorAll( ".shinken-widget" );
    };
    self.DOM.getAllGridElementWithErrors    = function ( data_set ) {
        return DOM.Service.querySelectorAllWithData( ".shinken-grid-cell", "errors", self.DOM.pageContainer() );
    };
    self.DOM.getAllGridElementWithWarning   = function () {
        return DOM.Service.querySelectorAllWithData( ".shinken-grid-cell", "warnings", self.DOM.pageContainer() );
    };
    self.DOM.getAllWidgetsSeparators        = function () {
        return self.DOM.gridContainer().querySelectorAll( '[data-type="separator_widget"]' );
    };
    self.DOM.getWidgetSeparator             = function ( index ) {
        return self.DOM.getAllWidgetsSeparators()[ index ];
    };
    self.DOM.getWidgetTitle                 = function () {
        return self.DOM.gridContainer().querySelector( '[data-type="title_widget"]' );
    };
    self.DOM.getWidgetWeather               = function () {
        return self.DOM.gridContainer().querySelector( '[data-type="weather_widget"]' );
    };
    self.DOM.WIDGET.WEATHER.widgets         = function () {
        return self.DOM.grid().querySelectorAll( '.shinken-widget[data-type="weather_widget"]' );
    };
    self.DOM.WIDGET.WEATHER.widget          = function ( index ) {
        return self.DOM.WIDGET.WEATHER.widgets()[ index ];
    };
    self.DOM.WIDGET.WEATHER.CellName        = function ( index ) {
        return self.DOM.WIDGET.WEATHER.widget( index ).querySelector( ".shinken-cell-name" );
    };
    self.DOM.WIDGET.WEATHER.CellNameLabel   = function ( index ) {
        return self.DOM.WIDGET.WEATHER.CellName( index ).querySelector( ".shinken-label" );
    };
    self.DOM.WIDGET.TITLE.widget            = function () {
        return self.DOM.grid().querySelector( '.shinken-widget[data-type="title_widget"]' );
    };
    self.DOM.WIDGET.TITLE.Label             = function () {
        return self.DOM.WIDGET.TITLE.widget().querySelector( ".shinken-widget-title-content" );
    };
    self.DOM.getWidget                      = function ( widget_type, widget_index ) {
        switch ( widget_type ) {
            case WIDGET.CONST.TYPE.SEPARATOR:
                return self.DOM.getWidgetSeparator( widget_index );
            case WIDGET.CONST.TYPE.TITLE:
                return self.DOM.getWidgetTitle();
            case WIDGET.CONST.TYPE.WEATHER:
                return self.DOM.getWidgetWeather( widget_index );
        }
    };
    self.DOM.getWidgetArea                  = function ( widget_type, widget_index, widget_area ) {
        const _dom = self.DOM.getWidget( widget_type, widget_index );
        switch ( widget_type ) {
            case WIDGET.CONST.TYPE.SEPARATOR:
                switch ( widget_area ) {
                    case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA._KEY:
                        return _dom.querySelector( ".shinken-cell-left" );
                    case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.RIGHT_AREA._KEY:
                        return _dom.querySelector( ".shinken-cell-right" );
                    case WIDGET.CONST.PARAM.LAYOUTS.SEPARATOR.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA._KEY:
                        return _dom.querySelector( ".shinken-widget-separator-title" );
                }
                break;
            case WIDGET.CONST.TYPE.WEATHER:
                switch ( widget_area ) {
                    case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.LEFT_AREA._KEY:
                        return _dom.querySelector( ".shinken-cell-left-area" );
                    case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA._KEY:
                        return _dom.querySelector( ".shinken-cell-top-right-area" );
                    case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA._KEY:
                        return _dom.querySelector( ".shinken-sla-container" );
                    case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.NAME_AREA._KEY:
                        return _dom.querySelector( ".shinken-widget-content .shinken-cell-remaining .shinken-cell-name .shinken-label" );
                    case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.SLA_AREA.SHOW_ICON._KEY:
                        return _dom.querySelector( ".shinken-sla-container .shinken-cell-sla-icon" );
                }
                break;
            case WIDGET.CONST.TYPE.TITLE:
                switch ( widget_area ) {
                    case WIDGET.CONST.PARAM.LAYOUTS.TITLE.LAYOUT.INFORMATION_TO_DISPLAY.TITLE_AREA._KEY:
                        return self.DOM.WIDGET.TITLE.Label();
                }
                break;
        }
    };
    self.DOM.WIDGET.WEATHER.iconContainer   = function ( widget_type, widget_index, zone_area ) {
        return self.DOM.getWidgetArea( widget_type, widget_index, zone_area ).querySelector( ".shinken-icon-container" );
    };
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.displayState            = function ( timeout, type_element, state, in_iframe ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.displayState", state, type_element );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.getElement( type_element, in_iframe );
            switch ( state ) {
                case self.CONST.STATE_DISPLAY.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, type_element );
                    break;
                case self.CONST.STATE_DISPLAY.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom, type_element );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE_AND_DISABLED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, type_element );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "0.3" );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE_AND_DISABLED_AND_NO_EVENT:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, type_element );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "0.3" );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE_AND_CHILDREN_DISABLED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, type_element );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom.firstElementChild, "pointerEvents", "none" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "0.3" );
                    break;
                default:
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.IFRAME.displayState     = function ( timeout, type_element, state ) {
        return self.TEST.displayState( timeout, type_element, state, true );
    };
    self.TEST.WIDGET.count            = function ( timeout, total_number_element_expected, number_with_errors, number_with_warning ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.WIDGET.count", total_number_element_expected + "-" + number_with_errors + "-" + number_with_warning );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.getAllWidgets(), total_number_element_expected, "total number widget" );
            if ( number_with_errors !== undefined ) {
                SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.getAllGridElementWithErrors(), number_with_errors, "error number widget" );
            }
            if ( number_with_warning !== undefined ) {
                SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( self.DOM.getAllGridElementWithWarning(), number_with_warning, "warning number widget" );
            }
        }, timeout );
        return _to_return;
    };
    self.TEST.WIDGET.stateArea        = function ( timeout, widget_type, widget_index, widget_area, state ) {
        var _to_return = 100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.WEATHER_GRID_CELL.stateArea", self.CONST.WEATHER_GRID_CELL.STATE.KEY[ state ] );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_element = self.DOM.getWidgetArea( widget_type, widget_index, widget_area );
            switch ( state ) {
                case self.CONST.STATE_DISPLAY.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasNoWidth( 0, _dom_element, widget_area );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_element, widget_area );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return 300;
    };
    self.TEST.WEATHER_GRID_CELL.state = function ( timeout, cell_index, state ) {
        var _to_return = 100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.WEATHER_GRID_CELL.state", self.CONST.WEATHER_GRID_CELL.STATE.KEY[ state ] );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _cells       = document.querySelectorAll( ".shinken-grid-cell" );
            var _dom_element = _cells[ cell_index ];
            switch ( state ) {
                case self.CONST.WEATHER_GRID_CELL.STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_element );
                    break;
                case self.CONST.WEATHER_GRID_CELL.STATE.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_element );
                    break;
                case self.CONST.WEATHER_GRID_CELL.STATE.PARTIALLY_VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isPartiallyInScreen( 0, _dom_element, _dom_element.parentElement );
                    break;
                case self.CONST.WEATHER_GRID_CELL.STATE.HAS_WARNING:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.containsData( 0, _dom_element, "warnings" );
                    break;
                case self.CONST.WEATHER_GRID_CELL.STATE.HAS_ERROR:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.containsData( 0, _dom_element, "errors" );
                    break;
                case self.CONST.WEATHER_GRID_CELL.STATE.HAS_WARNING_AND_ERROR:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.containsData( 0, _dom_element, "errors" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.containsData( 0, _dom_element, "warnings" );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    self.TEST.WIDGET.contentArea                          = function ( timeout, widget_type, widget_index, widget_area, content ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.contentArea", widget_area + " --> " + content );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_element = self.DOM.getWidgetArea( widget_type, widget_index, widget_area ).querySelector( ".shinken-primary-icon" );
            var _style       = "";
            switch ( content ) {
                case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.STATUS_THEN_CONTEXT:
                case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.QUALITY_SERVICE_ICON:
                case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.ONLY_STATUS:
                case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.CONTEXT_THEN_STATUS:
                case WIDGET.CONST.PARAM.LAYOUTS.WEATHER.LAYOUT.INFORMATION_TO_DISPLAY.TOP_RIGHT_AREA.ICON_TYPE.OPTIONS.FROM_WEBUI:
                    if ( SHINKEN.NAVIGATOR.isNavigator( "isFireFox" ) ) {
                        _style = "url(\"/static/" + __SHINKEN_HTTP_START_TIME__ + "/img/icons/critical.svg\") 50% 50% no-repeat";
                    }
                    else {
                        _style = "rgba(0, 0, 0, 0) url(\"http://" + SHINKEN.HIGHWAY.getHost() + "/static/" + __SHINKEN_HTTP_START_TIME__ + "/img/icons/critical.svg\") no-repeat scroll 50% 50% / auto padding-box border-box";
                    }
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom_element, "background", _style );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.WIDGET.textColor__20250205                  = function ( timeout, widget_type, widget_index, widget_area, color ) {
        var _to_return = 100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.changeColorInTitleArea" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getWidgetArea( widget_type, widget_index, widget_area ), "color", color );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.WIDGET.textAlign__20250213                  = function ( timeout, widget_type, widget_index, widget_area, alignment ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getWidgetArea( widget_type, widget_index, widget_area ), "text-align", alignment );
        }, timeout );
        return 50;
    };
    self.TEST.WIDGET.verticalAlign                        = function ( timeout, widget_type, widget_index, widget_area, alignment ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "TEST.verticalAlign" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getWidgetArea( widget_type, widget_index, widget_area ), "vertical-align", alignment );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.WIDGET.showArea                             = function ( timeout, widget_type, widget_index, widget_area, is_show ) {
        setTimeout( function () {
            if ( is_show ) {
                SHINKEN.TOOLS.TEST_AUTO.__hasNotStyle( self.DOM.getWidgetArea( widget_type, widget_index, widget_area ), "width", 0 );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.getWidgetArea( widget_type, widget_index, widget_area ), "width", 0 );
            }
        }, timeout );
        return 50;
    };
    self.TEST.WIDGET.WEATHER.isLabel__20251022            = function ( timeout, index_widget, text_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.WIDGET.WEATHER.CellNameLabel( index_widget ), text_expected );
        }, timeout );
        return 100;
    };
    self.TEST.WIDGET.WEATHER.hasBackgroundColor__20250129 = function ( timeout, index_widget, color_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__hasStyle( self.DOM.WIDGET.WEATHER.widget( index_widget ), "backgroundColor", color_expected );
        }, timeout );
        return 200;
    };
    self.TEST.WIDGET.WEATHER.stateArea                    = function ( timeout, widget_index, widget_area, state ) {
        return self.TEST.WIDGET.stateArea( timeout, WIDGET.CONST.TYPE.WEATHER, widget_index, widget_area, state );
    };
    self.TEST.WIDGET.WEATHER.iconType__20250204           = function ( timeout, index, widget_area, icon_type ) {
        setTimeout( function () {
            const _dom = self.DOM.WIDGET.WEATHER.iconContainer( WIDGET.CONST.TYPE.WEATHER, index, widget_area );
            switch ( icon_type ) {
                case self.CONST.ICON_DISPLAY.STATUS:
                    SHINKEN.TOOLS.TEST_AUTO.___isExisting( _dom.querySelector( ".shinken-primary-icon" ) );
                    SHINKEN.TOOLS.TEST_AUTO.__doesntExist( _dom.querySelector( ".shinken-secondary-icon" ) );
                    break;
                case self.CONST.ICON_DISPLAY.STATUS_AND_CONTEXT:
                    SHINKEN.TOOLS.TEST_AUTO.___isExisting( _dom.querySelector( ".shinken-primary-icon" ) );
                    //SHINKEN.TOOLS.TEST_AUTO.___isExisting( _dom.querySelector( ".shinken-secondary-icon" ) );
                    break;
                case self.CONST.ICON_DISPLAY.QUALITY_SERVICE:
                    SHINKEN.TOOLS.TEST_AUTO.___isExisting( _dom.querySelector( ".shinken-primary-icon" ) );
                    SHINKEN.TOOLS.TEST_AUTO.___isExisting( _dom.querySelector( "svg" ) );
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO.addError( "UNKNOWN icon type [" + icon_type + "]" );
                    break;
            }
        }, timeout );
        return 200;
    };
    self.TEST.WIDGET.WEATHER.SLAIcon__20250204            = function ( timeout, index, widget_area, icon_type, should_be_show ) {
        setTimeout( function () {
            const _dom = self.DOM.getWidgetArea( WIDGET.CONST.TYPE.WEATHER, index, widget_area );
            switch ( icon_type ) {
                case self.CONST.ICON_SLA.SLA_TENDENCY:
                    if ( should_be_show ) {
                        SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom.querySelector( ".shinken-cell-sla-tendency" ) );
                    }
                    else {
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _dom.querySelector( ".shinken-cell-sla-tendency" ) );
                    }
                    break;
                case self.CONST.ICON_SLA.SLA_ICON:
                    if ( should_be_show ) {
                        SHINKEN.TOOLS.TEST_AUTO.__isVisible( _dom.querySelector( ".shinken-cell-sla-icon" ) );
                    }
                    else {
                        SHINKEN.TOOLS.TEST_AUTO.__isNotVisible( _dom.querySelector( ".shinken-cell-sla-icon" ) );
                    }
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO.addError( "UNKNOWN icon type [" + icon_type + "]" );
                    break;
            }
        }, timeout );
        return 200;
    };
    
    self.TEST.WIDGET.TITLE.isLabel__20250205 = function ( timeout, text_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.WIDGET.TITLE.Label(), text_expected );
        }, timeout );
        return 100;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.createWeather                = function ( timeout, name, user_name ) {
        var _to_return = 3000 + 3000 + 2000 + 1000 + 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, "ACTION.createWeather", name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _timeout = SHINKEN.TOOLS.TEST_AUTO_UI_VISU_MENU.ACTION.clickOnSubMenu( 0, SHINKEN.SCREEN.TYPE.SERVICE_WEATHER, "menu_expand_new_service_weather" );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.ACTION.IFRAME.clickOnButton( _timeout, "button_mode_edit" );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.ACTION.IFRAME.clickOnButton( _timeout, "edit_tab_json" );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.ACTION.IFRAME.createJSONInForm( _timeout, name, user_name );
            _timeout += SHINKEN.TOOLS.TEST_AUTO_WEATHER_EDIT.ACTION.IFRAME.clickOnButton( _timeout, "button_save" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  CONSTANT **************************************************//
    
    return self;
})
( SHINKEN.TOOLS.TEST_AUTO_WEATHER || {} );
