"use strict";
SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT = (function ( self ) {
    self.DOM                          = {};
    self.TEST                         = {};
    self.ACTION                       = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.document                 = function ( window ) {
        return window ? window.document : document;
    };
    self.DOM.getButtonSave            = function ( window ) {
        return self.DOM.document( window ).getElementById( 'id-shinken-btn-save' );
    };
    self.DOM.getButtonDelete          = function ( window ) {
        return self.DOM.document( window ).getElementById( 'id-shinken-btn-remove' );
    };
    self.DOM.getButtonSubmitToStaging = function ( window ) {
        return self.DOM.document( window ).getElementById( 'id-shinken-btn-submit-to-staging' );
    };
    self.DOM.getButtonAcceptPropose   = function ( window ) {
        return self.DOM.document( window ).querySelector( '#element-btn-apply_work_area .btn-apply_work_area' );
    };
    self.DOM.getButtonRejectPropose   = function ( window ) {
        return self.DOM.document( window ).querySelector( '#element-btn-reject_work_area .btn-reject_work_area' );
    };
    self.DOM.workFlowManagerButton    = function ( workflow_name, is_window ) {
        var _css_selector = '.shinken-row-workflow-title ';
        switch ( workflow_name ) {
            case MANAGER.CONST.STATE.WORK_FLOW.STAGING:
                _css_selector += '.shinken-workflow-direct-staging-cell';
                break;
            case MANAGER.CONST.STATE.WORK_FLOW.WORKING_AREA:
                _css_selector += '.shinken-workflow-working-area-cell';
                break;
        }
        return self.DOM.document( is_window ? SHINKEN.TOOLS.TEST_AUTO_OPEN_WINDOW.instance : null ).querySelector( _css_selector );
    };
    
    //********************************************  GETTER SETTER   **************************************************//
    self.getSavingLog                              = function () {
        return document.getElementById( "saving-log" );
    };
    self.getTitleSavingLog                         = function () {
        return self.getSavingLog().querySelector( ".saving-log-title" );
    };
    //********************************************  CHANGE DATABASE   **************************************************//
    self.deleteElement                             = function ( timeout, shinken_element, result_expected, in_working_area, extra_label ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, in_working_area ? 'deleteElement in workarea' : 'deleteElement', shinken_element.getUUID() );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            //if ( SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
            //    return;
            //}
            if ( !extra_label ) {
                extra_label = "";
            }
            var item_type = shinken_element.getType();
            var item_id   = shinken_element.getUUID();
            var res       = {};
            var _url      = in_working_area ? '/elements/delete/working_area/' + item_type + '/' + item_id + '?bypass_work_area=1' : '/element/q/' + item_type + '/delete/' + item_id;
            
            $.post( _url, res ).success(
                function ( data ) {
                    var _identifiant = shinken_element.getName() || shinken_element.getUUID();
                    switch ( result_expected ) {
                        case "PROTECTED" :
                            if ( data.rc !== COMMUNICATION.CODE.FORBIDDEN ) {
                                SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "La suppresion de l'élement <b>" + _identifiant + "</b> n'a pas eu le retour attendu " + result_expected + "  ==> [" + data.shinken_return_code + "]", "" );
                            }
                            break;
                        default:
                            if ( result_expected && data.shinken_return_code !== result_expected ) {
                                SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + "La suppresion de l'élement <b>" + _identifiant + "</b> n'a pas eu le retour attendu " + result_expected + "  ==> [" + data.shinken_return_code + "]", "" );
                            }
                            break;
                    }
                    
                    SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
                }
            ).error(
                function ( res ) {
                    SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "ERROR", _to_return );
                }
            );
        }, timeout );
        return _to_return;
    };
    self.importElement                             = function ( timeout, item_type, item_id, datas ) {
        setTimeout( function () {
            if ( SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                return;
            }
            var _url = '/element/q/' + item_type + '/save/' + item_id + '?pending=1';
            $.post( _url, datas ).success(
                function ( data ) {
                    console.log( "[ - ]", data );
                }
            ).error(
                function ( res ) {
                }
            );
        }, timeout );
        return 2000;
    };
    self.ACTION.save_external_shinken_element      = function ( timeout, code_expected, is_current, switch_case_value ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'save_external_shinken_element', switch_case_value );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK", _to_return );
            }
            self.__save_external_object( code_expected, is_current, '', switch_case_value );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.__save_external_object                    = function ( code_expected, is_current, extra_label, switch_case_value ) {
        var _url  = self.__save_external_object_url( switch_case_value );
        var _data = self.__save_external_object_data( is_current, switch_case_value );
        self.__do__external_object_save_request( _url, _data, code_expected, extra_label );
    };
    self.__save_external_object_url                = function ( switch_case_value ) {
        var _switch_value = switch_case_value || __shinken_test_type + "-" + __phase;
        if ( __shinken_test_type === 'DEV' ) {
            _switch_value = "DEV";
        }
        switch ( _switch_value ) {
            case "00021-1":
                return '/element/q/serviceshosts/save/20000000000000000000000000000021';
            case "00024-1":
            case "00024-2":
                return '/element/q/hostgroups/save/40000000000000000000000000000024?bypass_work_area=1';
            case "00025-1":
                return '/element/q/hosts/save_in_work_area/00000000000000000000000000000025?submit_to_stagging=1';
            case "00025-3":
                return '/element/q/hosts/apply_work_area/00000000000000000000000000000025?ts=' + Date.now();
            case "00025-4":
            case "00025-7":
                return '/element/q/hosts/delete/00000000000000000000000000000025';
            case "00025-5":
                return '/element/q/hosts/save/00000000000000000000000000000025?bypass_work_area=1';
            case "00026-1":
                return '/element/q/hosts/save_in_work_area/00000000000000000000000000000026?submit_to_stagging=1';
            case "00026-2":
                return '/element/q/hosts/apply_work_area/00000000000000000000000000000026?ts=' + Date.now();
            case "00026-3":
                return '/element/q/hosts/save/00000000000000000000000000000026?bypass_work_area=1';
            case "00028-1":
            case "00028-2":
            case "00028-3":
            case "00028-4":
            case "00028-5":
            case "00028-6":
            case "00028-7":
            case "00028-8":
            case "00028-9":
            case "00028-10":
            case "00028-11":
            case "00028-12":
                return '/element/q/commands/save/50000000000000000000000000000028';
            case "00040-1":
            case "00040-2":
            case "00040-3":
            case "00040-7":
                return '/element/q/hosttpls/save/10000000000000000000000000000040?bypass_work_area=1';
            case "00040-4":
            case "00040-5":
            case "00040-6":
                return '/element/q/hosttpls/save/11000000000000000000000000000040?bypass_work_area=1';
            case "00083-4":
                return '/element/q/hosts/save/00000000000000000000000000000001?bypass_work_area=1&submit_to_stagging=1';
            case "00083-5":
                return '/element/q/hosts/save_in_work_area/00000000000000000000000000000001?submit_to_stagging=1';
            case "00094-1":
                return SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CHECK_TEMPLATE.TEST_AUTO_VALID.URL;
            case "00120-1":
            case "00120-4":
                return SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CLUSTERTPLS.TEST_AUTO_VALID_CLUSTER.URL;
            case "00122-1":
            case "00122-7":
                return SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.COMMAND.TEST_AUTO_VALID.URL;
            case "00122-2":
            case "00122-5":
                return SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CHECK.TEST_AUTO_VALID.URL;
            case "00122-3":
                return SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.HOSTS.TEST_AUTO_VALID.URL;
            case "00130-2":
                return SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CHECK.TEST_AUTO_DFE.URL;
            case "00132-1":
            case "00132-2":
            case "00132-3":
            case "00132-4":
            case "00133-1":
            case "00133-2":
            case "00133-3":
            case "00133-4":
                return SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.HOSTS.TEST_AUTO_VALID_132.URL;
            case "00139-1":
            case "00215-1":
                return '/element/q/hosts/save/00000000000000000000000000000003?bypass_work_area=1';
            case "00142-2":
                return '/element/q/hosts/save/00000000000000000000000000000142?bypass_work_area=1';
            case "00142-4":
                return '/element/q/serviceshosts/save/20000000000000000000000000000142';
            case "00143-2":
                return '/element/q/hosts/save/00000000000000000000000000000143?bypass_work_area=1';
            case "00143-4":
                return '/element/q/serviceshosts/save/20000000000000000000000000000143';
            case "00144-2":
                return '/element/q/hosts/save/00000000000000000000000000000144?bypass_work_area=1';
            case "00144-4":
                return '/element/q/serviceshosts/save/20000000000000000000000000000144';
            case "00145-2":
                return '/element/q/hosts/save/00000000000000000000000000000145?bypass_work_area=1';
            case "00145-3":
                return '/element/q/hosttpls/save/10000000000000000000000000000145';
            case "00145-4":
                return '/element/q/hosttpls/save/10100000000000000000000000000145';
            case "00145-5":
                return '/element/q/serviceshosttpls/save/20000000000000000000000000000145';
            //case "00163-6":
            //case "00163-10":
            //    return '/element/q/hosts/save_in_work_area/00000000000000000000000000000163?submit_to_stagging=1';
            //case "00163-8":
            //    return '/element/q/hosts/reject_submit/00000000000000000000000000000163?ts=' + Date.now();
            //case "00163-11":
            //    return '/element/q/hosts/apply_work_area/00000000000000000000000000000163?ts=' + Date.now();
            case "00177-1":
                return SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CLUSTER.TEST_AUTO_VALID_CLUSTER.URL;
            case "00179-1":
                return '/element/q/hosts/save/00000000000000000000000000000179?bypass_work_area=1';
            case "00179-2":
                return '/element/q/hosttpls/save/10000000000000000000000000000179';
            case "00183-4":
                return '/element/q/hosts/save/00000000000000000000000000000001';
            case "00183-5":
                return '/element/q/hosts/unlock_work_area/00000000000000000000000000000001';
            case "00183-7":
                return '/element/q/contacts/save/35000000000000000000000000000000';
            case "00239-1":
            case "00239-3-2":
                return '/element/q/hosttpls/save/12000000000000000000000000000000';
            case "00263-1-1":
                return '/element/q/hosttpls/save/10010000000000000000000000000263';
            case "00263-1-2":
                return '/element/q/serviceshosttpls/save/20020000000000000000000000000263';
            case "00263-1-3":
                return '/element/q/servicetpls/save/C0000000000000000000000000000263';
            case "00308-1":
            case "00308-5":
            case "00308-8":
            case "00308-12":
            case "00308-15":
            case "00308-18":
            case "00308-21":
            case "00308-24":
                return '/element/q/contacts/save/32000000000000000000000000000000';
            case "00341-1-1":
                return '/element/q/hosts/save/00000000000000000000000000000341?bypass_work_area=1';
            case "00341-1-2":
                return '/element/q/serviceshosts/save/20000000000000000000000000000341';
            case "00342-1-1":
                return '/element/q/hosts/save/00000000000000000000000000000342?bypass_work_area=1';
            case "00342-1-2":
                return '/element/q/serviceshosts/save/20000000000000000000000000000342';
            case "00352-1-1":
                return "/element/q/serviceshosts/save/22000000000000000000000000000000";
            case "00352-1-2":
                return "/element/q/serviceshosts/save/22000000000000000000000000000001";
            case "00352-1-3":
                return "/element/q/hosts/save/03000000000000000000000000000000?bypass_work_area=1";
            case "00352-1-4":
                return "/element/q/clusters/save/06000000000000000000000000000000";
            default:
                return '/element/q/hosts/save/00000000000000000000000000000001?bypass_work_area=1';
            
        }
    };
    self.__save_external_object_data               = function ( is_current, switch_value ) {
        if ( is_current ) {
            return getCurrentObjectFromProperty();
        }
        var _to_return = {};
        if ( !switch_value ) {
            switch_value = __shinken_test_type + "-" + __phase;
            if ( __shinken_test_type === 'DEV' ) {
                switch_value = "DEV";
            }
        }
        switch ( switch_value ) {
            case "00021-1":
                _to_return[ "service_description" ] = "00021_test_auto";
                _to_return[ "_id" ]                 = "20000000000000000000000000000021";
                _to_return[ "use" ]                 = "generic-service";
                _to_return[ "_PASSWORD" ]           = "test";
                _to_return[ "_PASSWORD_1" ]         = "test";
                _to_return[ "_PASSWORD_2" ]         = "test";
                _to_return[ "_PASSWORD_3" ]         = "test";
                _to_return[ "_PASSWORD_4" ]         = "test";
                _to_return[ "display_name" ]        = "dsmljfhsdlkmfjsdhklmfjhdsklfjhdslkjfhsdlkfjh";
                break;
            case "00024-1":
                _to_return[ "members" ]                                = {};
                _to_return[ "members" ][ "has_plus" ]                  = false;
                _to_return[ "members" ][ "links" ]                     = [];
                _to_return[ "members" ][ "links" ][ 0 ]                = {};
                _to_return[ "members" ][ "links" ][ 0 ][ "exists" ]    = true;
                _to_return[ "members" ][ "links" ][ 0 ][ "item_type" ] = "hosts";
                _to_return[ "members" ][ "links" ][ 0 ][ "name" ]      = "00024_test_auto";
                _to_return[ "members" ][ "links" ][ 0 ][ "_id" ]       = "00000000000000000000000000000024";
                _to_return[ "hostgroup_name" ]                         = "00024_test_auto";
                _to_return[ "_id" ]                                    = "40000000000000000000000000000024";
                break;
            case "00024-2":
                _to_return[ "hostgroup_name" ] = "00024_test_auto";
                _to_return[ "_id" ]            = "40000000000000000000000000000024";
                break;
            case "00025-1":
            case "00025-5":
                _to_return[ "host_name" ]   = "00025_test_auto";
                _to_return[ "description" ] = DATE_TIME.now(); //IN ORDER TO HAVE A DIFFERENT OBJECT
                _to_return[ "_id" ]         = "00000000000000000000000000000025";
                break;
            case "00025-3":
            case "00025-4":
                break;
            case "00026-1":
                _to_return[ "host_name" ] = "00026_test_auto_renammed";
                _to_return[ "_id" ]       = "00000000000000000000000000000026";
                break;
            case "00026-3":
                _to_return[ "host_name" ]    = "00026_test_auto";
                _to_return[ "_id" ]          = "00000000000000000000000000000026";
                _to_return[ "display_name" ] = "Non regression SEF-4419";
                break;
            case "00028-1":
                _to_return[ "command_name" ]    = "00028_test_auto";
                _to_return[ "command_line" ]    = "echo \"HTTP OK: HTTP/1.1 200 OK - 1124 bytes in 0.216 second response time |time=0.216080s size=1124B\"";
                _to_return[ "_id" ]             = "50000000000000000000000000000028";
                _to_return[ "shell_execution" ] = "1";
                _to_return[ "timeout" ]         = "20";
                break;
            case "00028-2":
                _to_return[ "command_name" ]    = "00028_test_auto";
                _to_return[ "command_line" ]    = "echo \"HTTP OK: HTTP/1.1 200 OK - 1124 bytes in 0.216 second response time |time=0.216080s\"";
                _to_return[ "_id" ]             = "50000000000000000000000000000028";
                _to_return[ "shell_execution" ] = "1";
                _to_return[ "timeout" ]         = "20";
                break;
            case "00028-3":
                _to_return[ "command_name" ]    = "00028_test_auto";
                _to_return[ "command_line" ]    = "echo \"HTTP OK: HTTP/1.1 200 OK - 1124 bytes in 0.216 second response time |time blabla=0.216080s\"";
                _to_return[ "_id" ]             = "50000000000000000000000000000028";
                _to_return[ "shell_execution" ] = "1";
                _to_return[ "timeout" ]         = "20";
                break;
            case "00028-4":
                _to_return[ "command_name" ]    = "00028_test_auto";
                _to_return[ "command_line" ]    = "echo \"HTTP OK: HTTP/1.1 200 OK - 1124 bytes in 0.216 second response time |time=0.216080s,\"";
                _to_return[ "_id" ]             = "50000000000000000000000000000028";
                _to_return[ "shell_execution" ] = "1";
                _to_return[ "timeout" ]         = "20";
                break;
            case "00028-5":
                _to_return[ "command_name" ]    = "00028_test_auto";
                _to_return[ "command_line" ]    = "echo \"HTTP OK: HTTP/1.1 200 OK - 1124 bytes in 0.216 second response time |time=0,216080s\"";
                _to_return[ "_id" ]             = "50000000000000000000000000000028";
                _to_return[ "shell_execution" ] = "1";
                _to_return[ "timeout" ]         = "20";
                break;
            case "00028-6":
                _to_return[ "command_name" ]    = "00028_test_auto";
                _to_return[ "command_line" ]    = "echo \"HTTP OK: HTTP/1.1 200 OK - 1124 bytes in 0.216 second response time |'john''s disk'=83%\"";
                _to_return[ "_id" ]             = "50000000000000000000000000000028";
                _to_return[ "shell_execution" ] = "1";
                _to_return[ "timeout" ]         = "20";
                break;
            case "00028-7":
                _to_return[ "command_name" ]    = "00028_test_auto";
                _to_return[ "command_line" ]    = "echo \"HTTP OK: HTTP/1.1 200 OK - 1124 bytes in 0.216 second response time |'disk usage'=78%;80;90;;;\"";
                _to_return[ "_id" ]             = "50000000000000000000000000000028";
                _to_return[ "shell_execution" ] = "1";
                _to_return[ "timeout" ]         = "20";
                break;
            case "00028-8":
                _to_return[ "command_name" ]    = "00028_test_auto";
                _to_return[ "command_line" ]    = "echo \"HTTP OK: HTTP/1.1 200 OK - 1124 bytes in 0.216 second response time |'disk usage'=78%;80;90\"";
                _to_return[ "_id" ]             = "50000000000000000000000000000028";
                _to_return[ "shell_execution" ] = "1";
                _to_return[ "timeout" ]         = "20";
                break;
            case "00028-9":
                _to_return[ "command_name" ]    = "00028_test_auto";
                _to_return[ "command_line" ]    = "echo \"HTTP OK: HTTP/1.1 200 OK - 1124 bytes in 0.216 second response time |'data packets'=11345234c\"";
                _to_return[ "_id" ]             = "50000000000000000000000000000028";
                _to_return[ "shell_execution" ] = "1";
                _to_return[ "timeout" ]         = "20";
                break;
            case "00028-10":
                _to_return[ "command_name" ]    = "00028_test_auto";
                _to_return[ "command_line" ]    = "echo \"HTTP OK: HTTP/1.1 200 OK - 1124 bytes in 0.216 second response time |temperature=23;;;20;30\"";
                _to_return[ "_id" ]             = "50000000000000000000000000000028";
                _to_return[ "shell_execution" ] = "1";
                _to_return[ "timeout" ]         = "20";
                break;
            case "00028-11":
                _to_return[ "command_name" ]    = "00028_test_auto";
                _to_return[ "command_line" ]    = "echo \"HTTP OK: HTTP/1.1 200 OK - 1124 bytes in 0.216 second response time\"";
                _to_return[ "_id" ]             = "50000000000000000000000000000028";
                _to_return[ "shell_execution" ] = "1";
                _to_return[ "timeout" ]         = "20";
                break;
            case "00028-12":
                _to_return[ "command_name" ]    = "00028_test_auto";
                _to_return[ "command_line" ]    = "echo \"HTTP OK: HTTP/1.1 200 OK - 1124 bytes in 0.216 second response time |time=0.216080s size=1124B\"";
                _to_return[ "_id" ]             = "50000000000000000000000000000028";
                _to_return[ "shell_execution" ] = "1";
                _to_return[ "timeout" ]         = "20";
                break;
            case "00040-1":
                _to_return[ "_id" ]              = "10000000000000000000000000000040";
                _to_return[ "name" ]             = "00040_test_auto_1";
                _to_return[ "service_excludes" ] = "*_1";
                break;
            case "00040-2":
                _to_return[ "_id" ]                                                   = "10000000000000000000000000000040";
                _to_return[ "name" ]                                                  = "00040_test_auto_1";
                _to_return[ "service_excludes_by_id" ]                                = {};
                _to_return[ "service_excludes_by_id" ][ "has_plus" ]                  = false;
                _to_return[ "service_excludes_by_id" ][ "raw_value" ]                 = "";
                _to_return[ "service_excludes_by_id" ][ "links" ]                     = [];
                _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ]                = {};
                _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "exists" ]    = true;
                _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "item_type" ] = "serviceshosttpls";
                _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "name" ]      = "00040_test_auto_1";
                _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "_id" ]       = "20000000000000000000000000000040";
                break;
            case "00040-3":
                _to_return[ "_id" ]                                                   = "10000000000000000000000000000040";
                _to_return[ "name" ]                                                  = "00040_test_auto_1";
                _to_return[ "service_excludes_by_id" ]                                = {};
                _to_return[ "service_excludes_by_id" ][ "has_plus" ]                  = false;
                _to_return[ "service_excludes_by_id" ][ "raw_value" ]                 = "";
                _to_return[ "service_excludes_by_id" ][ "links" ]                     = [];
                _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ]                = {};
                _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "exists" ]    = true;
                _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "item_type" ] = "serviceshosttpls";
                _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "name" ]      = "00040_test_auto_1";
                _to_return[ "service_excludes_by_id" ][ "links" ][ 0 ][ "_id" ]       = "20000000000000000000000000000040";
                _to_return[ "service_excludes" ]                                      = "*_1";
                break;
            case "00040-4":
                _to_return[ "_id" ]              = "11000000000000000000000000000040";
                _to_return[ "name" ]             = "00040_test_auto_2";
                _to_return[ "service_excludes" ] = "*";
                break;
            case "00040-5":
                _to_return[ "_id" ]     = "11000000000000000000000000000040";
                _to_return[ "name" ]    = "00040_test_auto_2";
                _to_return[ "enabled" ] = "0";
                break;
            case "00040-6":
                _to_return[ "_id" ]  = "11000000000000000000000000000040";
                _to_return[ "name" ] = "00040_test_auto_2";
                break;
            case "00040-7":
                _to_return[ "_id" ]  = "10000000000000000000000000000040";
                _to_return[ "name" ] = "00040_test_auto_1";
                break;
            case "00083-4":
                _to_return[ "_id" ]          = "00000000000000000000000000000001";
                _to_return[ "host_name" ]    = "00001_test_auto";
                _to_return[ "enabled" ]      = "0";
                _to_return[ "display_name" ] = "vérification des propriétés présentes dans un hôte";
                break;
            case "00083-5":
                _to_return[ "_id" ]          = "00000000000000000000000000000001";
                _to_return[ "host_name" ]    = "00001_test_auto";
                _to_return[ "enabled" ]      = "1";
                _to_return[ "display_name" ] = "vérification des propriétés présentes dans un hôte";
                break;
            case "00067-2":
                _to_return[ "_id" ]          = "00000000000000000000000000000001";
                _to_return[ "host_name" ]    = "00001_test_auto";
                _to_return[ "display_name" ] = "vérification des propriétés présentes dans un hôte";
                _to_return[ "address" ]      = "localhost";
                break;
            case "00070-3":
            case "00071-2":
                _to_return[ "_id" ]          = "00000000000000000000000000000001";
                _to_return[ "host_name" ]    = "00001_test_auto";
                _to_return[ "display_name" ] = "vérification des propriétés présentes dans un hôte";
                _to_return[ "address" ]      = "localhost";
                _to_return[ "use" ]          = "test_auto_disabled";
                break;
            case "00070-5":
            case "00072-2":
            case "00073-2":
            case "00074-2":
            case "00075-2":
            case "00076-2":
            case "00077-2":
            case "00078-2":
            case "00079-2":
            case "00080-2":
                _to_return[ "_id" ]          = "00000000000000000000000000000001";
                _to_return[ "host_name" ]    = "00001_test_auto";
                _to_return[ "display_name" ] = "vérification des propriétés présentes dans un hôte";
                _to_return[ "address" ]      = "localhost";
                _to_return[ "use" ]          = "test_auto_valid";
                _to_return[ "hostgroups" ]   = "test_auto_valid";
                break;
            case "00092-2":
            case "00093-2":
                _to_return[ "_id" ]             = "00000000000000000000000000000001";
                _to_return[ "host_name" ]       = "00001_test_auto";
                _to_return[ "display_name" ]    = "vérification des propriétés présentes dans un hôte";
                _to_return[ "notes_multi_url" ] = "test_auto_1~=http://test_auto_1~=tag~=OPEN_IN_NEW_TAB";
                break;
            case "00093-3":
            case "00093-5":
                _to_return[ "_id" ]             = "00000000000000000000000000000001";
                _to_return[ "host_name" ]       = "00001_test_auto";
                _to_return[ "display_name" ]    = "vérification des propriétés présentes dans un hôte";
                _to_return[ "notes_multi_url" ] = "test_auto_2~=http://test_auto_1~=tag~=OPEN_IN_NEW_TAB";
                break;
            case "00093-4":
            case "00093-6":
            case "00093-7":
            case "00093-8":
                _to_return[ "_id" ]             = "00000000000000000000000000000001";
                _to_return[ "host_name" ]       = "00001_test_auto";
                _to_return[ "display_name" ]    = "vérification des propriétés présentes dans un hôte";
                _to_return[ "notes_multi_url" ] = "test_auto_2~=http://test_auto_2~=tag~=OPEN_IN_NEW_TAB~#~test_auto_3~=http://test_auto_3~=tag~=OPEN_IN_NEW_TAB~#~test_auto_4~=http://test_auto_4~=tag~=OPEN_IN_NEW_TAB";
                break;
            case "00094-1":
                _to_return = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CHECK_TEMPLATE.TEST_AUTO_VALID.DATA;
                break;
            case "00120-1":
                _to_return              = self.__save_external_object_data( false, "00120-4" );
                _to_return[ "bp_rule" ] = "test_auto";
                break;
            case "00120-4":
                _to_return = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CLUSTERTPLS.TEST_AUTO_VALID_CLUSTER.DATA;
                break;
            case "00122-1":
                _to_return                   = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.COMMAND.TEST_AUTO_VALID.DATA;
                _to_return[ "command_line" ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL._00122.COMMAND_LINE;
                break;
            case "00122-2":
                _to_return                    = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CHECK.TEST_AUTO_VALID.DATA;
                _to_return[ "host_name" ]     = "test_auto_valid";
                _to_return[ "check_command" ] = "test_auto_valid!$_HOSTTEST_AUTO_A$";
                break;
            case "00122-3":
                _to_return                          = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.HOSTS.TEST_AUTO_VALID.DATA;
                _to_return[ "_TEST_AUTO_A" ]        = "test auto";
                _to_return[ "_TEST_AUTO_PASSWORD" ] = "dGVzdCBhdXRv";
                break;
            case "00122-5":
                _to_return                    = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CHECK.TEST_AUTO_VALID.DATA;
                _to_return[ "host_name" ]     = "test_auto_valid";
                _to_return[ "check_command" ] = "test_auto_valid!$_HOSTTEST_AUTO_PASSWORD$";
                break;
            case "00122-7":
                _to_return                   = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.COMMAND.TEST_AUTO_VALID.DATA;
                _to_return[ "command_line" ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL._00122.COMMAND_LINE_7;
                break;
            case "00123-2":
            case "00126-2":
                _to_return[ "_id" ]                             = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ]     = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.VIEW_CONTACTS ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACT.TEST_AUTO_VALID.PARSE_TO_LINK;
                break;
            case "00123-3":
            case "00126-3":
                _to_return[ "_id" ]                                   = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ]           = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACTGROUP.TEST_AUTO_VALID.PARSE_TO_LINK;
                break;
            case "00123-4":
            case "00126-4":
                _to_return[ "_id" ]                             = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ]     = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.VIEW_CONTACTS ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACT.TEST_AUTO_VALID.PARSE_TO_LINK;
                break;
            case "00123-5":
            case "00126-5":
                _to_return[ "_id" ]                                   = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ]           = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACTGROUP.TEST_AUTO_VALID.PARSE_TO_LINK;
                break;
            case "00123-8":
            case "00123-17":
            case "00126-8":
            case "00126-17":
                _to_return[ "_id" ]                                           = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ]                   = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACTGROUP.TEST_AUTO_VALID.PARSE_TO_LINK;
                break;
            case "00123-9":
            case "00126-9":
                _to_return[ "_id" ]                                           = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ]                   = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACTGROUP.TEST_AUTO_VALID.PARSE_TO_LINK;
                _to_return[ PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS ]      = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACTGROUP.TEST_AUTO_DISABLED.PARSE_TO_LINK;
                break;
            case "00123-10":
            case "00126-10":
                _to_return[ "_id" ]                                           = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ]                   = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS ] = PROPERTY.CONST.DEFAULT_TO_LINK;
                _to_return[ PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS ]      = PROPERTY.CONST.NONE_TO_LINK;
                break;
            case "00123-11":
            case "00126-11":
                _to_return[ "_id" ]                                           = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ]                   = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.VIEW_CONTACTS ]               = PROPERTY.CONST.NONE_TO_LINK;
                _to_return[ PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACTGROUP.TEST_AUTO_VALID.PARSE_TO_LINK;
                _to_return[ PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS ]      = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACTGROUP.TEST_AUTO_DISABLED.PARSE_TO_LINK;
                break;
            case "00123-12":
            case "00123-13":
            case "00126-12":
            case "00126-13":
                _to_return[ "_id" ]                                           = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ]                   = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.VIEW_CONTACTS ]               = PROPERTY.CONST.DEFAULT_TO_LINK;
                _to_return[ PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACTGROUP.TEST_AUTO_VALID.PARSE_TO_LINK;
                _to_return[ PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS ]      = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACTGROUP.TEST_AUTO_DISABLED.PARSE_TO_LINK;
                break;
            case "00123-14":
            case "00126-14":
                _to_return[ "_id" ]                                     = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ]             = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACT.TEST_AUTO_VALID.PARSE_TO_LINK;
                _to_return[ PROPERTY.CONST.NAME.EDITION_CONTACTS ]      = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACT.TEST_AUTO_DISABLED.PARSE_TO_LINK;
                break;
            case "00123-15":
            case "00123-18":
            case "00123-19":
            case "00126-15":
            case "00126-18":
            case "00126-19":
                _to_return[ "_id" ]                                           = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ]                   = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS ]       = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACT.TEST_AUTO_VALID.PARSE_TO_LINK;
                _to_return[ PROPERTY.CONST.NAME.EDITION_CONTACTS ]            = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACT.TEST_AUTO_DISABLED.PARSE_TO_LINK;
                _to_return[ PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACTGROUP.TEST_AUTO_VALID.PARSE_TO_LINK;
                _to_return[ PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS ]      = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACTGROUP.TEST_AUTO_DISABLED.PARSE_TO_LINK;
                break;
            case "00123-20":
            case "00123-21":
            case "00123-22":
            case "00123-23":
            case "00126-20":
            case "00126-21":
            case "00126-22":
            case "00126-23":
                _to_return[ "_id" ]                         = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ] = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.USE ]       = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.HOSTTPLS.TEST_AUTO_VALID_WITH_USER_RIGHTS_1.PARSE_TO_LINK;
                break;
            case "00123-24":
            case "00126-24":
                _to_return                                       = self.__save_external_object_data( false, "00123-23" );
                _to_return[ PROPERTY.CONST.NAME.USE ][ 'links' ] = SHINKEN.TOOLS.ARRAY.concat( _to_return[ PROPERTY.CONST.NAME.USE ][ 'links' ], SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.HOSTTPLS.TEST_AUTO_VALID_WITH_USER_RIGHTS_2.PARSE_TO_LINK[ 'links' ] );
                break;
            case "00123-25":
            case "00123-27":
            case "00123-28":
            case "00126-25":
            case "00126-27":
            case "00126-28":
                _to_return[ "_id" ]                         = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ] = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.USE ]       = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.HOSTTPLS.TEST_AUTO_VALID_WITH_USER_RIGHTS_3.PARSE_TO_LINK;
                break;
            case "00123-26":
            case "00126-26":
                _to_return                                            = self.__save_external_object_data( false, "00123-24" );
                _to_return[ PROPERTY.CONST.NAME.USE ][ 'links' ]      = SHINKEN.TOOLS.ARRAY.concat( _to_return[ PROPERTY.CONST.NAME.USE ][ 'links' ], SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.HOSTTPLS.TEST_AUTO_VALID_WITH_USER_RIGHTS_3.PARSE_TO_LINK[ 'links' ] );
                _to_return[ PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACTGROUP.TEST_AUTO_DISABLED.PARSE_TO_LINK;
                break;
            case "00123-29":
            case "00126-29":
                _to_return[ "_id" ]                         = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ] = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.USE ]       = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.HOSTTPLS.TEST_AUTO_VALID_WITH_USER_RIGHTS_5.PARSE_TO_LINK;
                break;
            case "00130-1":
                _to_return[ "_id" ]                                                           = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ]                                   = "00001_test_auto";
                _to_return[ SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.PASSWORD.KEY_NAME ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.PASSWORD.VALUES.TEST_AUTO_VALID_1;
                break;
            case "00130-2":
                _to_return                                                                    = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CHECK.TEST_AUTO_VALID.DATA;
                _to_return[ 'host_name' ]                                                     = {
                    links      : [
                        {
                            exists   : true,
                            item_type: "hosts",
                            name     : "00001_test_auto",
                            _id      : "00000000000000000000000000000001"
                        }
                    ], has_plus: false
                };
                _to_return[ SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.PASSWORD.KEY_NAME ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.PASSWORD.VALUES.TEST_AUTO_VALID_1;
                break;
            case "00132-1":
                _to_return = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.HOSTS.TEST_AUTO_VALID_132.DATA;
                break;
            case "00132-2":
                _to_return                            = self.__save_external_object_data( false, "00132-1" );
                _to_return[ PROPERTY.CONST.NAME.USE ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.HOSTTPLS.TEST_AUTO_VALID_WITH_DATA_1.PARSE_TO_LINK;
                break;
            case "00132-3":
            case "00132-4":
                _to_return                  = self.__save_external_object_data( false, "00132-2" );
                _to_return[ "_LOCAL_DATA" ] = "TEST_AUTO";
                break;
            case "00133-1":
                _to_return                            = self.__save_external_object_data( false, "00132-1" );
                _to_return[ PROPERTY.CONST.NAME.USE ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.HOSTTPLS.TEST_AUTO_VALID_WITH_DATA_2.PARSE_TO_LINK;
                break;
            case "00133-2":
            case "00133-3":
            case "00133-4":
                _to_return = self.__save_external_object_data( false, "00133-1" );
                break;
            case "00139-1":
                _to_return[ "_id" ]       = "00000000000000000000000000000003";
                _to_return[ "host_name" ] = "_test_auto";
                _to_return[ "use" ]       = "00003_test_auto_1,00003_test_auto_2";
                break;
            case "00142-2":
                _to_return[ "_id" ]               = "00000000000000000000000000000142";
                _to_return[ "host_name" ]         = "00142_test_auto";
                _to_return[ "service_overrides" ] = "00142_test_auto,business_impact 1";
                break;
            case "00142-4":
                _to_return[ "_id" ]                 = "20000000000000000000000000000142";
                _to_return[ "service_description" ] = "00142_test_auto";
                _to_return[ "host_name" ]           = "00142_test_auto";
                _to_return[ "use" ]                 = "generic-service";
                break;
            case "00143-2":
                _to_return[ "_id" ]               = "00000000000000000000000000000143";
                _to_return[ "host_name" ]         = "00143_test_auto";
                _to_return[ "service_overrides" ] = "00143_test_auto_1,business_impact 1";
                _to_return[ "_TEST_AUTO" ]        = "1";
                break;
            case "00143-4":
                _to_return[ "_id" ]                 = "20000000000000000000000000000143";
                _to_return[ "service_description" ] = "00143_test_auto_$KEY$";
                _to_return[ "host_name" ]           = "00143_test_auto";
                _to_return[ "use" ]                 = "generic-service";
                _to_return[ "duplicate_foreach" ]   = "_TEST_AUTO";
                break;
            case "00144-2":
                _to_return[ "_id" ]               = "00000000000000000000000000000144";
                _to_return[ "host_name" ]         = "00144_test_auto";
                _to_return[ "service_overrides" ] = "00144_test_auto_1,business_impact 1";
                break;
            case "00144-4":
                _to_return[ "_id" ]                 = "20000000000000000000000000000144";
                _to_return[ "service_description" ] = "00144_test_auto_$KEY$";
                _to_return[ "host_name" ]           = "00144_test_auto";
                _to_return[ "use" ]                 = "generic-service";
                _to_return[ "duplicate_foreach" ]   = "_TEST_AUTO";
                break;
            case "00145-2":
                _to_return[ "_id" ]               = "00000000000000000000000000000145";
                _to_return[ "host_name" ]         = "00145_test_auto";
                _to_return[ "use" ]               = "00145_test_auto_1,00145_test_auto_2";
                _to_return[ "service_overrides" ] = "00145_test_auto_1,business_impact 1";
                break;
            case "00145-3":
                _to_return[ "_id" ]      = "10000000000000000000000000000145";
                _to_return[ "name" ]     = "00145_test_auto_1";
                _to_return[ "register" ] = "0";
                break;
            case "00145-4":
                _to_return[ "_id" ]      = "10100000000000000000000000000145";
                _to_return[ "name" ]     = "00145_test_auto_2";
                _to_return[ "register" ] = "0";
                break;
            case "00145-5":
                _to_return[ "_id" ]                 = "20000000000000000000000000000145";
                _to_return[ "service_description" ] = "00145_test_auto_$KEY$";
                _to_return[ "host_name" ]           = "00145_test_auto_1";
                _to_return[ "use" ]                 = "generic-service";
                _to_return[ "duplicate_foreach" ]   = "_TEST_AUTO";
                _to_return[ "register" ]            = "0";
                break;
            case "00169-1":
                _to_return[ "_id" ]                             = "00000000000000000000000000000001";
                _to_return[ PROPERTY.CONST.NAME.HOST_NAME ]     = "00001_test_auto";
                _to_return[ PROPERTY.CONST.NAME.VIEW_CONTACTS ] = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CONTACT.TEST_AUTO_VALID.PARSE_TO_LINK;
                _to_return[ PROPERTY.CONST.NAME.USE ]           = "00006_test_auto";
                _to_return[ "_KEY" ]                            = "1";
                _to_return[ "_KEY2" ]                           = "DFE_1";
                break;
            case "00177-1":
                _to_return                         = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID.CLUSTER.TEST_AUTO_VALID_CLUSTER.DATA;
                _to_return[ "host_name" ]          = "TEST_auto_VALID_cluster";
                _to_return[ "visualisation_name" ] = "validation name OF TEST_auto_VALID_cluster";
                break;
            case "00179-1":
                _to_return[ "_id" ]       = "00000000000000000000000000000179";
                _to_return[ "host_name" ] = "00179_test_auto";
                _to_return[ "use" ]       = "00179_test_auto";
                _to_return[ "enabled" ]   = "0";
                break;
            case "00179-2":
                _to_return[ "_id" ]       = "10000000000000000000000000000179";
                _to_return[ "name" ]      = "00179_test_auto";
                _to_return[ "register" ]  = "0";
                _to_return[ "_PASSWORD" ] = btoa("test_auto");
                break;
            case "00183-7":
                _to_return[ "_id" ]          = "35000000000000000000000000000000";
                _to_return[ "contact_name" ] = "test_auto_user_executor";
                _to_return[ "expert" ]       = "1";
                _to_return[ "is_admin" ]     = "1";
                _to_return[ "password" ]     = btoa( "test_auto_user_executor" );
                break;
            case "DEV":
                _to_return[ "_id" ]          = "00000000000000000000000000000001";
                _to_return[ "host_name" ]    = "00001_test_auto";
                _to_return[ "display_name" ] = "ssssssssssssssssssssss";
                break;
            case "00227-1":
                _to_return[ "_id" ]                = "00000000000000000000000000000227";
                _to_return[ "host_name" ]          = "00227_test_auto_host";
                _to_return[ "address" ]            = "localhost";
                _to_return[ "maintenance_period" ] = "24x7";
                _to_return[ "_SE_UUID" ]           = "core-hosts-00000000000000000000000000000227";
                break;
            case "00227-2":
                _to_return[ "_id" ]       = "00000000000000000000000000000227";
                _to_return[ "host_name" ] = "00227_test_auto_host";
                _to_return[ "address" ]   = "localhost";
                _to_return[ "_SE_UUID" ]  = "core-hosts-00000000000000000000000000000227";
                break;
            case "00215-1":
                _to_return[ "_id" ]       = "00000000000000000000000000000003";
                _to_return[ "host_name" ] = "00003_test_auto";
                _to_return[ "use" ]       = "00003_test_auto_1,00003_test_auto_2";
                break;
            case "00239-1":
                _to_return[ "_id" ]      = "12000000000000000000000000000000";
                _to_return[ "name" ]     = "test_auto_valid";
                _to_return[ "register" ] = "0";
                _to_return[ "use" ]      = "shinken-full";
                break;
            case "00239-3-2":
                _to_return[ "_id" ]      = "12000000000000000000000000000000";
                _to_return[ "name" ]     = "test_auto_valid";
                _to_return[ "register" ] = "0";
                break;
            case "00367-1":
                _to_return[ "_id" ]              = "35000000000000000000000000000000";
                _to_return[ "contact_name" ]     = "test_auto_user_executor";
                _to_return[ "expert" ]           = "1";
                _to_return[ "is_admin" ]         = "1";
                _to_return[ "notificationways" ] = "00367_test_auto_notification_way";
                break;
            case "00367-1-2":
                _to_return[ "_id" ]                   = "00000000000000000000000000000003";
                _to_return[ "host_name" ]             = "00003_test_auto";
                _to_return[ "use" ]                   = "00003_test_auto_1,00003_test_auto_2";
                _to_return[ "notification_contacts" ] = "test_auto_user_executor";
                _to_return[ "max_check_attempts" ]    = "1";
                break;
            case "00263-1-1":
                _to_return[ "_id" ]                = "10010000000000000000000000000263";
                _to_return[ "name" ]               = "00263_test_auto_new ⭐ô🍠";
                _to_return[ "thresholds_display" ] = "$_HOSTTEST_1$ .🥣/⭐,?$%";
                _to_return[ "_TEST_1" ]            = "1-.🍠/⭐,?%-";
                _to_return[ "service_overrides" ]  = "00263_test_auto_check_new ⭐ô🍠,thresholds_display $_HOSTTEST_1$ $_SERVICETEST_1$ $VALUE1$ .🥣/⭐,?$%";
                _to_return[ "register" ]           = "0";
                break;
            case "00263-1-2":
                _to_return[ "_id" ]                 = "20020000000000000000000000000263";
                _to_return[ "service_description" ] = "00263_test_auto_check_new ⭐ô🍠";
                _to_return[ "use" ]                 = "00263_test_auto_check_tpl_new ⭐ô🍠";
                _to_return[ "host_name" ]           = "00263_test_auto_tpl ⭐ô🍠";
                _to_return[ "_TEST_1" ]             = "1-.🍠/⭐,?%-";
                _to_return[ "thresholds_display" ]  = "check $_HOSTTEST_1$ $_SERVICETEST_1$ $VALUE1$ .🥣/⭐,?$%";
                _to_return[ "register" ]            = "0";
                break;
            case "00263-1-3":
                _to_return[ "_id" ]                = "C0000000000000000000000000000263";
                _to_return[ "name" ]               = "00263_test_auto_check_tpl_new ⭐ô🍠";
                _to_return[ "use" ]                = "generic-service";
                _to_return[ "_TEST_1" ]            = "1-.🍠/⭐,?%-";
                _to_return[ "thresholds_display" ] = "checktpl $_HOSTTEST_1$ $_SERVICETEST_1$ $VALUE1$ .🥣/⭐,?$%";
                _to_return[ "register" ]           = "0";
                break;
            case "00308-1":
            case "00308-24":
                _to_return[ "_id" ]          = "32000000000000000000000000000000";
                _to_return[ "contact_name" ] = "test_auto_valid";
                _to_return[ "expert" ]       = "1";
                _to_return[ "password" ]     = btoa( "test_auto_valid" );
                break;
            case "00308-5":
                _to_return[ "_id" ]                                                     = "32000000000000000000000000000000";
                _to_return[ "contact_name" ]                                            = "test_auto_valid";
                _to_return[ "password" ]                                                = btoa( "test_auto_valid" );
                _to_return[ "expert" ]                                                  = "1";
                _to_return[ "acl_change_element_visibility_on_not_authenticated_view" ] = "1";
                break;
            case "00308-8":
                _to_return[ "_id" ]                                                     = "32000000000000000000000000000000";
                _to_return[ "contact_name" ]                                            = "test_auto_valid";
                _to_return[ "password" ]                                                = btoa( "test_auto_valid" );
                _to_return[ "expert" ]                                                  = "1";
                _to_return[ "acl_change_element_visibility_on_not_authenticated_view" ] = "0";
                break;
            case "00308-12":
                _to_return[ "_id" ]          = "32000000000000000000000000000000";
                _to_return[ "contact_name" ] = "test_auto_valid";
                _to_return[ "password" ]     = btoa( "test_auto_valid" );
                _to_return[ "expert" ]       = "1";
                _to_return[ "is_admin" ]     = "1";
                break;
            case "00308-15":
                _to_return[ "_id" ]          = "32000000000000000000000000000000";
                _to_return[ "contact_name" ] = "test_auto_valid";
                _to_return[ "expert" ]       = "1";
                _to_return[ "is_admin" ]     = "0";
                _to_return[ "password" ]     = btoa( "test_auto_valid" );
                break;
            case "00308-18":
                _to_return[ "_id" ]          = "32000000000000000000000000000000";
                _to_return[ "contact_name" ] = "test_auto_valid";
                _to_return[ "password" ]     = btoa( "test_auto_valid" );
                _to_return[ "use" ]          = "test_auto_00308_visibility_on_not_authenticated_view";
                _to_return[ "expert" ]       = "1";
                break;
            case "00308-21":
                _to_return[ "_id" ]          = "32000000000000000000000000000000";
                _to_return[ "contact_name" ] = "test_auto_valid";
                _to_return[ "password" ]     = btoa( "test_auto_valid" );
                _to_return[ "use" ]          = "test_auto_00308_admin_shinken";
                _to_return[ "expert" ]       = "1";
                break;
            case "00341-1-1":
                _to_return[ "_id" ]               = "00000000000000000000000000000341";
                _to_return[ "host_name" ]         = "00341_test_auto";
                _to_return[ "service_overrides" ] = "00341_test_auto_1,business_impact 5-=#=-00341_test_auto_2,business_impact 0";
                break;
            case "00341-1-2":
                _to_return[ "_id" ]                 = "20000000000000000000000000000341";
                _to_return[ "service_description" ] = "00341_test_auto_1";
                _to_return[ "host_name" ]           = "00341_test_auto";
                _to_return[ "use" ]                 = "generic-service";
                break;
            case "00342-1-1":
                _to_return[ "_id" ]               = "00000000000000000000000000000342";
                _to_return[ "host_name" ]         = "00342_test_auto";
                _to_return[ "service_overrides" ] = "00342_test_auto_1,business_impact 0-=#=-00342_test_auto_1,notification_interval 100-=#=-00342_test_auto_1,first_notification_delay 100-=#=-00342_test_auto_2,business_impact 5-=#=-00342_test_auto_2,notification_interval 1-=#=-00342_test_auto_2,first_notification_delay 2";
                break;
            case "00342-1-2":
                _to_return[ "_id" ]                 = "20000000000000000000000000000342";
                _to_return[ "service_description" ] = "00342_test_auto_1";
                _to_return[ "host_name" ]           = "00342_test_auto";
                _to_return[ "use" ]                 = "generic-service";
                break;
            case "00352-1-1":
                _to_return[ "_id" ]                 = "22000000000000000000000000000000";
                _to_return[ "service_description" ] = "test_auto_valid";
                _to_return[ "host_name" ]           = "test_auto_valid";
                _to_return[ "check_command" ]       = "no-check";
                _to_return[ "use" ]                 = "generic-service";
                break;
            case "00352-1-2":
                _to_return[ "_id" ]                 = "22000000000000000000000000000001";
                _to_return[ "service_description" ] = "test_auto_valid_2";
                _to_return[ "host_name" ]           = "test_auto_valid";
                _to_return[ "check_command" ]       = "test_auto_valid";
                _to_return[ "use" ]                 = "generic-service";
                break;
            case "00352-1-3":
                _to_return[ "_id" ]                = "03000000000000000000000000000000";
                _to_return[ "host_name" ]          = "test_auto_valid";
                _to_return[ "address" ]            = "localhost";
                _to_return[ "parents" ]            = "test_auto_valid_2";
                _to_return[ "visualisation_name" ] = "nom de visualisation : test_auto_valid";
                break;
            case "00352-1-4":
                _to_return[ "_id" ]       = "06000000000000000000000000000000";
                _to_return[ "host_name" ] = "test_auto_valid_cluster";
                _to_return[ "bp_rule" ]   = "test_auto_valid_3 & test_auto_valid_2";
                break;
            case "00357":
                _to_return[ "_id" ]                = "03000000000000000000000000000000";
                _to_return[ "host_name" ]          = "test_auto_valid";
                _to_return[ "address" ]            = "localhost";
                _to_return[ "parents" ]            = "test_auto_valid_2";
                _to_return[ "visualisation_name" ] = "nom de visualisation : test_auto_valid";
                _to_return[ "maintenance_period" ] = "test_auto_valid";
                break;
            default:
                _to_return[ "_id" ]          = "00000000000000000000000000000001";
                _to_return[ "host_name" ]    = "00001_test_auto";
                _to_return[ "display_name" ] = "vérification des propriétés présentes dans un hôte";
                break;
        }
        return _to_return;
    };
    self.__do__external_object_save_request        = function ( url, data, code_expected, extra_label ) {
        if ( !extra_label ) {
            extra_label = "";
        }
        var item_dump                                                = {};
        item_dump[ 'protect_fields__substrings_matching_fields' ]    = JSON.stringify( SHINKEN.TOOLS.ENCRYPTION.getProtectedKeys() );
        item_dump[ 'protect_fields__activate_interface_encryption' ] = SHINKEN.TOOLS.ENCRYPTION.isDatabaseEncryptionActivated();
        item_dump[ 'protect_fields__are_viewable_by_admin_si' ]      = SHINKEN.TOOLS.ENCRYPTION.isProtectedFieldsAreViewableByAdminSi();
        item_dump[ 'item' ]                                          = JSON.stringify( data );
        if ( !url ) {
            return;
        }
        $.post( url, item_dump ).success(
            function ( data ) {
                if ( typeof code_expected !== "object" ) {
                    code_expected = [code_expected];
                }
                if ( !SHINKEN.TOOLS.ARRAY.contains( code_expected, data.rc ) ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " La sauvegarde de l'élement n'a pas réussi [SUCCESS]" + JSON.stringify( data ) );
                }
            }
        ).error(
            function ( res ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( extra_label + " La sauvegarde de l'élement n'a pas réussi [ERROR]" + res.responseText );
            }
        );
    };
    //********************************************  SOURCE LISTENER   **************************************************//
    self.initShinkenElementsSyncUIListener         = function ( timeout ) {
        setTimeout( function () {
            var _keys = Object.keys( SHINKEN.TOOLS.TEST_AUTO.CONST_LISTENERS.ELEMENTS );
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                self.initShinkenElementsSyncUIListener_2( SHINKEN.TOOLS.TEST_AUTO.CONST_LISTENERS.ELEMENTS[ _keys[ i ] ] );
            }
        }, timeout );
        
        return 5000;
    };
    self.initShinkenElementsSyncUIListener_2       = function ( test_auto ) {
        var _keys = Object.keys( test_auto );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            for ( var j = 0, _size_j = test_auto[ _current_key ].length; j < _size_j; j++ ) {
                SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT._sendElementToListenerTestAuto( test_auto[ _current_key ][ j ], _current_key );
            }
        }
    };
    //********************************************  SOURCE SYNC_UI   **************************************************//
    self.initShinkenElementsSyncUI                 = function ( timeout ) {
        setTimeout( function () {
            var _keys = Object.keys( SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID );
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                self.initShinkenElementsSyncUIByType( timeout, _keys[ i ] );
            }
        }, timeout );
        
        return 2000;
    };
    self.initShinkenElementsSyncUIByType           = function ( timeout, type ) {
        setTimeout( function () {
            var _keys = Object.keys( SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID[ type ] );
            var _current_key;
            var _current;
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                _current_key = _keys[ i ];
                _current     = SHINKEN.TOOLS.TEST_AUTO.CONST_SOURCE_INTERNAL.DEFAULT_CONFIG_TEST_AUTO_VALID[ type ][ _current_key ];
                if ( !_current.URL ) {
                    continue;
                }
                self.__do__external_object_save_request( _current.URL, _current.DATA, [200, 202], 'Init test auto valid : ' + _current_key );
            }
        }, timeout );
        return 1000;
    };
    self.resetTestAutoValid                        = function ( timeout, ELEMENT_TO_RESET ) {
        setTimeout( function () {
            self.__do__external_object_save_request( ELEMENT_TO_RESET.URL, ELEMENT_TO_RESET.DATA, 200, 'Reset test auto valid' );
        }, timeout );
        return 2000;
    };
    self.sendElementToListenerTestAuto             = function ( timeout, element, element_type ) {
        setTimeout( function () {
            self._sendElementToListenerTestAuto( element, element_type );
        }, timeout );
        
        return 2000;
    };
    self._sendElementToListenerTestAuto            = function ( element, element_type ) {
        $.ajax( {
            type       : "PUT",
            url        : "http://" + SHINKEN.HIGHWAY.getHostName() + ":" + SOURCE__PORT__LISTENER_TEST_AUTO + "/shinken/listener-test-auto/v1/" + element_type + "/",
            contentType: "application/json",
            headers    : {
                "Authorization": "Basic " + btoa( "Shinken" + ":" + "Shinken" )
            },
            data       : JSON.stringify( element ),
            success    : function ( data ) {
                console.log( "Element correctly sent to the listener test auto" );
                //process the JSON data etc
            },
            error      : function ( error ) {
                console.log( "Test-auto error sending element to listener :" + error );
            }
        } );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.goToMode                           = function ( timeout, workflow_mode, is_window ) {
        setTimeout( function () {
            self.DOM.workFlowManagerButton( workflow_mode, is_window ).click();
        }, timeout );
        return 200;
    };
    //********************************************  EDITION ELEMENT SINGLE   **************************************************//
    self.ACTION.saveWithButtonSubmitToStagging     = function ( timeout, is_window ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'saveWithButtonSubmitToStaging' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _save_button = self.DOM.getButtonSubmitToStaging( is_window ? SHINKEN.TOOLS.TEST_AUTO_OPEN_WINDOW.instance : null );
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _save_button, '' );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                _save_button.click();
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK" );
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le test comporte des erreurs, la dernière action n'a pas été faites" );
            }
            if ( __test_auto_continue_if_error || !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
            }
            
        }, timeout );
        return _to_return;
    };
    self.ACTION.saveWithButtonImport               = function ( timeout, escape_do_next ) {
        return self.ACTION.saveWithButtonSave( timeout, escape_do_next );
    };
    self.ACTION.saveWithButtonSave                 = function ( timeout, escape_do_next, window ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'saveWithButtonSave' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _save_button = self.DOM.getButtonSave( window );
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _save_button, '' );
            SHINKEN.TOOLS.TEST_AUTO.buildMessage( 0 );
            if ( !escape_do_next ) {
                __do_next = false;
                if ( __test_auto_continue_if_error || !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                    SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
                }
            }
            else {
                if ( __window_phase ) {
                    SHINKEN.HIGHWAY.changeUrl();
                }
            }
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                _save_button.click();
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK" );
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le test comporte des erreurs, la dernière action n'a pas été faites" );
            }
            
        }, timeout );
        return _to_return;
    };
    self.ACTION.saveWithButtonSave_withSpecialUUID = function ( timeout, id_to_save, escape_do_next, window ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'saveWithSpecificIdWithButtonSave' );
        setTimeout( function () {
            var _temp_timeout = SHINKEN.TOOLS.TEST_AUTO.ACTION.do_JS_action( 0, `MANAGER.__instance_element_distributor.current_element.uuid = "${id_to_save}"` );
            self.ACTION.saveWithButtonSave( _temp_timeout, escape_do_next, window );
        }, timeout );
        return _to_return;
    };
    self.ACTION.deleteWithButtonDelete             = function ( timeout ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.deleteWithButtonDelete', '-' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            confirm         = function () {
                return true;
            };
            var dom_element = self.DOM.getButtonDelete();
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, dom_element );
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK" );
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le test comporte des erreurs, la dernière action n'a pas été faites" );
            }
            if ( __test_auto_continue_if_error || !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextLink( __shinken_test_type, __phase + 1 ) );
            }
        }, timeout );
        return _to_return;
    };
    self.ACTION.saveWithButtonDifference           = function ( timeout ) {
        setTimeout( function () {
            var _save_button = document.querySelector( '#element-btn-differences .btn-differences' );
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _save_button, '' );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                _save_button.click();
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le test comporte des erreurs, la dernière action n'a pas été faites" );
            }
            if ( __test_auto_continue_if_error || !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
            }
        }, timeout );
        return 2000;
    };
    self.ACTION.saveWithButtonAcceptPropose        = function ( timeout, window ) {
        var _to_return = 4000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.saveWithButtonAcceptPropose' );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT_EDITION.ACTION.navigateInTab( 0, WINDOW.CONST.ELEMENT.PROPOSED );
        }, timeout / 2 );
        setTimeout( function () {
            var _save_button = self.DOM.getButtonAcceptPropose( window );
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _save_button, '' );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                _save_button.click();
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK" );
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le test comporte des erreurs, la dernière action n'a pas été faites" );
            }
            if ( __test_auto_continue_if_error || !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
            }
        }, timeout );
        return _to_return;
    };
    self.ACTION.saveWithButtonRejectPropose        = function ( timeout, window ) {
        var _to_return = 4000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.saveWithButtonRejectPropose' );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT_EDITION.ACTION.navigateInTab( 0, WINDOW.CONST.ELEMENT.PROPOSED );
        }, timeout / 2 );
        setTimeout( function () {
            var _save_button = self.DOM.getButtonRejectPropose( window );
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _save_button, '' );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                _save_button.click();
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK" );
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le test comporte des erreurs, la dernière action n'a pas été faites" );
            }
            if ( __test_auto_continue_if_error || !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
            }
        }, timeout );
        return _to_return;
    };
    //********************************************  EDITION ELEMENT SINGLE   **************************************************//
    self.TEST.numberOfPropertyToSave               = function ( timeout, nb_element ) {
        setTimeout( function () {
            var _datas = getCurrentObjectFromProperty();
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( Object.keys( _datas ), nb_element, "nb property saved" );
        }, timeout );
        return 10;
    };
    self.TEST.workFlowState                        = function ( timeout, state_expected ) {
        setTimeout( function () {
            var _body = DOM.BodyService.getDomElement();
            if ( _body.dataset.stateWorkFlow !== state_expected ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "le workflow state n'est pas <span class='shinken-data-user'>" + state_expected + "</span> mais à [<span class='shinken-data-user'>" + _body.dataset.stateWorkFlow + "</span>]" );
            }
        }, timeout );
        return 10;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.logStatus                            = function ( timeout, status ) {
        setTimeout( function () {
            switch ( status ) {
                case SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT_CONST.LOG_STATUS.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, self.getSavingLog() );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT_CONST.LOG_STATUS.SUCCESS:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, self.getSavingLog() );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( 0, self.getTitleSavingLog() );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT_CONST.LOG_STATUS.ERROR:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, self.getSavingLog() );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, self.getTitleSavingLog() );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, self.getTitleSavingLog(), _( 'common.errors' ) );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT_CONST.LOG_STATUS.WARNING:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, self.getSavingLog() );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, self.getTitleSavingLog() );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, self.getTitleSavingLog(), _( 'common.warnings' ) );
                    break;
                
            }
        }, timeout );
        return 200;
    };
    self.validDataInBase                           = function ( timeout, shinken_element ) {
        var _to_return = 8000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'validDataInBase', shinken_element.getUUID() );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _url = '/internal/private_shinken_test/item?password=private_shinken_test&' + shinken_element.buildBaseUrl();
            $.ajax( {
                type   : "get",
                url    : _url,
                success: self.validDataInBaseSuccess,
                error  : function ( response ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "validDataInBaseError ==> statusText=" + response.statusText );
                    if ( response.status === 403 ) {
                        SHINKEN.TOOLS.TEST_AUTO.addError( "-- Synchronizer not in debug mode --" );
                    }
                    SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK", _to_return );
                }
            } );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.validDataInBaseSuccess                    = function ( response ) {
        var _switch_value = __shinken_test_type + "-" + __phase;
        try {
            switch ( _switch_value ) {
                case "00157-5":
                case "00157-7":
                    break;
                case "00142-3":
                case "00143-3":
                case "00144-3":
                case "00144-5":
                case "00150-3":
                case "00150-5":
                case "00150-7":
                case "00150-9":
                case "00151-3":
                case "00151-5":
                case "00151-7":
                case "00151-9":
                case "00152-3":
                case "00152-5":
                case "00152-7":
                case "00152-9":
                case "00152-11":
                case "00153-3":
                case "00153-5":
                case "00153-7":
                case "00153-9":
                case "00153-11":
                case "00154-3":
                case "00154-5":
                case "00154-7":
                case "00154-9":
                case "00154-11":
                case "00154-14":
                case "00154-27":
                case "00155-5":
                case "00155-7":
                case "00155-9":
                case "00155-11":
                case "00155-14":
                case "00155-27":
                case "00156-5":
                case "00156-7":
                case "00156-9":
                case "00156-11":
                case "00157-9":
                case "00157-11":
                case "00157-14":
                case "00157-27":
                    SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( response.item.service_overrides.links[ 0 ].check_link.exists, false, 'validDataInBaseSuccess' );
                    break;
                case "00142-5":
                case "00142-9":
                case "00143-5":
                case "00143-9":
                case "00144-7":
                case "00144-12":
                case "00145-4":
                case "00146-10":
                case "00146-18":
                case "00148-10":
                case "00148-18":
                case "00149-10":
                case "00149-18":
                case "00150-12":
                case "00150-22":
                case "00151-12":
                case "00151-22":
                case "00152-14":
                case "00152-27":
                case "00153-14":
                case "00153-27":
                case "00156-14":
                case "00156-27":
                    SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( response.item.service_overrides.links[ 0 ].check_link.exists, true, 'validDataInBaseSuccess' );
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO.addError( "no test done ==> Should be configured" );
            }
        }
        catch ( e ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( "validDataInBaseSuccess failed " + e );
        }
    };
    self.addNewElementWithListener                 = function ( jsonString ) {
        var url  = "http://localhost:7762/shinken/listener-rest-test-auto/v1/hosts/";
        var init = {
            headers: {
                Authorization : "Basic cm9vdDpyb290",  // root:root
                "Content-Type": 'application/json'
            },
            method : "PUT",
            body   : jsonString // The body is expected to be a json 'stringified' : JSON.stringify( jsonString )
        };
        //FORMAT NOT IE COMPATIBLE
        fetch( url, init ).then( response => response.text() )
                          .then( text => console.log( text ) )
                          .catch( err => console.error( "Error Billy", err ) );
    };
    self.TEST.counterSave                          = function ( timeout, error_expected, warning_expected ) {
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.counter( 0, self.DOM.getButtonSave(), error_expected, warning_expected );
        }, timeout );
        return 100;
    };
    self.TEST.hasCriticalError                     = function ( timeout ) {
        setTimeout( function () {
            let _dom = document.querySelector( ".saving-log-title .shinken-tooltip-message" );
            SHINKEN.TOOLS.TEST_AUTO.__containsText( _dom.innerHTML, _( 'element.tooltip_message_tag_critical' ) );
        }, timeout );
        return 500;
    };
    self.TEST.countCriticalErrorAfterSave          = function ( timeout, error_expected ) {
        setTimeout( function () {
            let _dom_list = self.getSavingLog().querySelectorAll( ".shinken-critical-status" );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _dom_list.length, error_expected );
        }, timeout );
        return 500;
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT || {} );

SHINKEN.TOOLS.TEST_AUTO_SHINKEN_ELEMENT_CONST = {
    LOG_STATUS: {
        HIDDEN : 0,
        SUCCESS: 1,
        ERROR  : 2,
        WARNING: 3
    }
};