SHINKEN.TOOLS.TEST_AUTO_SOURCE_ANALYZER = (function ( self ) {
    self.DOM                             = {};
    self.DOM.FORM                        = {};
    self.TEST                            = {};
    self.ACTION                          = {};
    self.ACTION.FORM                     = {};
    //********************************************  DOM   **************************************************//
    self.DOM.getTabListRange             = function ( window ) {
        var _document = window ? window.document : document;
        return _document.querySelector( "#tab-pane-network-scan-target" );
    };
    self.DOM.getTabDoAnalyse             = function ( window ) {
        var _document = window ? window.document : document;
        return _document.querySelector( "#tab-pane-analyze-jobs-in-progress-target" );
    };
    self.DOM.getTabTemplateMapping       = function ( window ) {
        var _document = window ? window.document : document;
        return _document.querySelector( "#tab-pane-analyzer-template-mapping-target" );
    };
    self.DOM.buttonAddNetworkRange       = function ( window ) {
        var _document = window ? window.document : document;
        return _document.getElementById( "id-shinken-add-button" );
    };
    self.DOM.inputConfiguration          = function ( key ) {
        return SHINKEN.TOOLS.TEST_AUTO_SOURCE_CONFIGURATION_TAB.DOM.getTab().querySelector( '#' + key );
    };
    self.DOM.FORM.getIFrameContentWIndow = function () {
        return document.querySelector( ".shinken-window-modal-content iframe" ).contentWindow;
    };
    self.DOM.FORM.getIFrame              = function () {
        return self.DOM.FORM.getIFrameContentWIndow().document;
    };
    self.DOM.FORM.mainInput              = function ( property_name ) {
        return SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.line( property_name, self.DOM.FORM.getIFrame() ).querySelector( '.shinken-prop-cell-action .shinken-input' );
    };
    self.DOM.FORM.saveButton             = function () {
        return self.DOM.FORM.getIFrame().getElementById( 'id-shinken-btn-save' );
    };
    self.DOM.FORM.deleteButton           = function () {
        return self.DOM.FORM.getIFrame().getElementById( 'id-shinken-btn-remove' );
    };
    self.DOM.ipRangeLineByName           = function ( ip_range_name, window ) {
        var _doms_cells_name_ip_range = self.DOM.getTabListRange( window ).querySelectorAll( ".shinken-network-scan-row" );
        for ( var i = 0, _size_i = _doms_cells_name_ip_range.length; i < _size_i; i++ ) {
            if ( _doms_cells_name_ip_range[ i ].querySelector( ".discovery_name .shinken-label" ).innerText === ip_range_name ) {
                return _doms_cells_name_ip_range[ i ];
            }
        }
        return null;
    };
    self.DOM.formButtonAnalyse           = function ( ip_range_name, window ) {
        return self.DOM.ipRangeLineByName( ip_range_name, window ).querySelector( 'form[name="shadow_form_analyzer"]' );
    };
    self.DOM.analyzeButton               = function ( ip_range_name, window ) {
        return self.DOM.formButtonAnalyse( ip_range_name, window ).querySelector( ".analyzer-analyze-button" );
    };
    self.DOM.nameButton                  = function ( ip_range_name, window ) {
        return self.DOM.ipRangeLineByName( ip_range_name, window ).querySelector( ".shinken-link" );
    };
    self.DOM.formButtonAnalyze           = function ( ip_range_name, window ) {
        return self.DOM.ipRangeLineByName( ip_range_name, window ).querySelector( "#analyze-button" );
    };
    self.DOM.launchAnalyzeButton         = function ( window ) {
        return self.DOM.getTabDoAnalyse( window ).querySelector( "#analyze-button" );
    };
    self.DOM.mappingTemplateInput        = function ( template_name, window ) {
        return self.DOM.getTabTemplateMapping( window ).querySelector( "input[name='" + template_name + "']" );
    };
    self.DOM.mappingTemplateSubmit       = function ( window ) {
        return self.DOM.getTabTemplateMapping( window ).querySelector( ".table-foot-js button" );
    };
    //********************************************  ACTION   **************************************************//
    //http://192.168.1.88:7766/sources/server-analyzer?tab=tab-analyzer-template-mapping&shinken_test_auto=00214
    //http://192.168.1.88:7766/sources/server-analyzer?tab=tab-analyzer-template-mapping&shinken_test_auto=00214&phase=2
    self.ACTION.clickOnSubmitMappingTemplate = function ( timeout, window ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnSubmitMappingTemplate', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.mappingTemplateSubmit( window ) );
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK" );
            }
        }, timeout );
        return _to_return;
    };
    self.ACTION.setValueToMappingTemplate    = function ( timeout, template_name, value, window ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.setValueToMappingTemplate', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.mappingTemplateInput( template_name, window );
            _dom.scrollIntoView();
            DOM.Service.setInputValue( _dom, value );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnAddNetworkRange       = function ( timeout ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnAddNetworkRange', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonAddNetworkRange() );
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
            }
            SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnAnalyzerButton        = function ( timeout, ip_range_name, window ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnAnalyserButton', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                if ( !window ) {
                    SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setAttribute( 0, self.DOM.formButtonAnalyse( ip_range_name ), "action", "/analyzers/server-analyzer" + SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
                }
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 100, self.DOM.analyzeButton( ip_range_name, window ) );
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
            }
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnLaunchAnalyzeButton   = function ( timeout, window ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnLaunchAnaliseButton', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.launchAnalyzeButton( window ) );
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
            }
        }, timeout );
        return _to_return;
    };
    self.ACTION.setConfiguration             = function ( timeout, key, value ) {
        var _to_return = 400;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.addConfiguration', key, value );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_SOURCE_CONFIGURATION_TAB.ACTION.setInputValue( 500, self.DOM.inputConfiguration( key ), value );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
        }, timeout );
        return _to_return;
    };
    self.ACTION.FORM.setValue                = function ( timeout, property_name, value_to_set ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.FORM.setValue', property_name + " ==> " + value_to_set );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.setValue( 0, self.DOM.FORM.mainInput( property_name ), value_to_set );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    self.ACTION.FORM.save = function ( timeout ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.FORM.save', '-' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.FORM.saveButton() );
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK" );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "NOK" );
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le test comporte des erreurs, la dernière action n'a pas été faites" );
            }
            if ( __test_auto_continue_if_error || !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
            }
        }, timeout );
        return _to_return;
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_SOURCE_ANALYZER || {} );
