"use strict";
TI.ANGULAR = (function ( self ) {
    self.DOM                 = {};
    self.TEST                = {};
    self.ACTION              = {};
    self.CONST               = {};
    let INTERNAL             = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getIframe       = function () {
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).window.onerror = function () {
            _has_script_error++;
        };
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document;
    };
    self.DOM.helpButton      = function () {
        return self.DOM.getIframe().querySelector( "#table-help-btn" );
    };
    self.DOM.helpContainer   = function () {
        return self.DOM.getIframe().querySelector( ".help-container" );
    };
    //********************************************  INTERNAL **************************************************//
    INTERNAL.stopPropagation = function () {
        return function () {
        };
    };
    
    //********************************************  TEST   **************************************************//
    self.TEST.displayHelp         = function ( timeout, state ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY_INFORMATION.TEST.display_', state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.helpContainer();
            switch ( state ) {
                case TI.ANGULAR.CONST.STATE.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, "help container" );
                    break;
                case TI.ANGULAR.CONST.STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom, "help container" );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnHelpButton = function ( timeout ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickHelp', "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.helpButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.ACTION.ngClick           = function ( timeout, dom_element, function__name, function__data__extra ) {
        let function__data;
        setTimeout( function () {
            switch ( function__name ) {
                case "clickOnTableData" :
                    function__data = { target: dom_element, stopPropagation: INTERNAL.stopPropagation };
                    break;
                case "clickOnActionButton" :
                case "onClickActionButton" :
                    function__data = { target: dom_element, stopPropagation: INTERNAL.stopPropagation, action_name: function__data__extra };
                    break;
                
            }
            SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).EXTERNAL.COMMUNICATION
                   .doAction( "do_angular_broadcast", { broad_cast_event: "TEST_AUTO_SIMULATE_CLICK", function__name: function__name, function__data: function__data } );
        }, timeout );
        return 500;
    };
    return self;
})( TI.ANGULAR || {} );

TI.ANGULAR.CONST = {
    STATE: {
        DISABLE: "disable",
        RUNNING: "running",
        HIDDEN : "hidden",
        VISIBLE: "visible",
        INHERITED: "inherited"
    }
};