//__lib__ lib_common
//priority 100

"use strict";

SHINKEN.OBJECT.CollapseFolderFromData           = function ( name, label ) {
    this.initSpecific( name, label );
};
SHINKEN.OBJECT.CollapseFolderFromData.prototype = {
    initSpecific     : function ( name, label ) {
        this.class = "shinken-collapse-folder shinken-toggle-container";
        this.init( name, label );
        this.initCounterCommon();
    },
    initCounterCommon: function () {
        this.counters = {};
    },
    //********************************************  EVENT LISTENER  **************************************************//
    
    //********************************************  ACTIONS  *****************************************************//
    
    //********************************************  GETTER SETTER  *****************************************************//
    
    //********************************************  HTML  *****************************************************//
    computeHtml             : function () {
        this.computeCommonHtml();
        this.computeSpecificHtml();
    },
    computeCommonHtml       : function () {
        this.setDomElement( DOM.Service.createElement( "div", this.computeHtml_getAttribute() ) );
        var _button        = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-toggle-button", onclick: this.getOnClickEvent() } ) );
        this._button_label = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-toggle-button-label shinken-layout-center-h-v shinken-layout-justify-between" } ), _button );
        let label          = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-label" }, this.label ), this._button_label );
        var _div           = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-collapse-icon-cell" } ), this._button_label );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-toggle-icon shinken-hidden-if-toggle-close shinken-2023-arrow-down" } ), _div );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-toggle-icon shinken-hidden-if-toggle-open shinken-2023-arrow-up" } ), _div );
        
        this.dom_content_target = DOM.Service.createElement( "div", { class: "shinken-toggle-target" } );
        this.addDomElement( this.dom_content_target );
        
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            DOM.Service.addElementTo( this.getContent( i ).getDomElement(), this.dom_content_target );
        }
        this.computeHtmlExtra();
        this.addCounterComputeHtmlIfExist( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WIDGET_TOTAL, label );
    },
    getOnClickEvent         : function () {
        return this.onclick_event || "DOM.Service.Toggle.toggle(this)";
    },
    computeHtml_getAttribute: function () {
        var _to_return                        = {};
        _to_return[ "class" ]                 = this.class;
        _to_return[ "data-name" ]             = this.name;
        _to_return[ "data-visibility-state" ] = this.getVisibilityState();
        return _to_return;
    },
    computeSpecificHtml     : function () {
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function ( type ) {
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CollapseFolderFromData, SHINKEN.OBJECT.CollapseFolder );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CollapseFolderFromData, SHINKEN.OBJECT.CounterInterfaceV2 );

SHINKEN.OBJECT.CollapseFolderForProperties           = function ( name, label ) {
    this.initSpecific( name, label );
};
SHINKEN.OBJECT.CollapseFolderForProperties.prototype = {
    initSpecific     : function ( name, label ) {
        this.class = "shinken-collapse-folder shinken-toggle-container";
        this.init( name, label );
        this.initCounterCommon();
    },
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    
    //********************************************  ACTIONS  *****************************************************//
    add: function ( to_add ) {
        to_add.setCountersParent( this );
        return this.addCommon( to_add );
    }
    //********************************************  GETTER SETTER  *****************************************************//
    
    //********************************************  HTML  *****************************************************//
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CollapseFolderForProperties, SHINKEN.OBJECT.CollapseFolderFromData );

SHINKEN.OBJECT.CollapseFolderFromData_V3           = function ( name, label ) {
    this.initSpecific( name, label );
};
SHINKEN.OBJECT.CollapseFolderFromData_V3.prototype = {
    initSpecific : SHINKEN.OBJECT.CollapseFolderFromData.prototype.initSpecific,
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "toggl_collapse_folder__is_open":
                param[ DOM.Service.Toggle.CONST.PARAM_EVENT.TOGGL_SERVICE__IS_OPEN ] = DOM.Service.Toggle.toggle_V3( this.getDomElement() );
                break;
            case "toggl_collapse_folder__is_open__or__close_others":
                if ( this.getUUID() === param[SHINKEN.OBJECT.COLLAPSE.PARAM.NAME] ){
                    param[ DOM.Service.Toggle.CONST.PARAM_EVENT.TOGGL_SERVICE__IS_OPEN ] = DOM.Service.Toggle.toggle_V3( this.getDomElement() );
                }
                else {
                    DOM.Service.Toggle.close( this.getDomElement() );
                    param[ DOM.Service.Toggle.CONST.PARAM_EVENT.TOGGL_SERVICE__IS_OPEN ] = false;
                }
                break;
        }
        this.doActionAfterCommon( event_name, param );
    },
    //********************************************  USER PREF  *****************************************************//
    getUserPref: function () {
        return {
            [SHINKEN.USER_PREFS.KEY]  : SHINKEN.OBJECT.COLLAPSE.PARAM.IS_OPEN,
            [SHINKEN.USER_PREFS.VALUE]: DOM.Service.Toggle.isOpen( this.getDomElement() )
        };
    } ,
    //********************************************  HTML  *****************************************************//
    getOnClickEvent: function () {
        return this.onclick_event || "MANAGER.EventManagerV2.doActionAfter(event, 'toggl_collapse_folder__is_open', " + this.parseParamForEventsToHtml() + ")";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CollapseFolderFromData_V3, SHINKEN.OBJECT.CollapseFolderFromData );