//__lib__ lib_common_V02_01
//priority 100

"use strict";

SHINKEN.OBJECT.FORMSET = {
    PARAM: {
        FORM_NAME                      : "form__name",
        FORM_LINK_OBJECT_UUID          : "form__linked__object_uuid",
        FORM_OBJECT                    : "form__object",
        FORM_ANIMATION_STOP_PROPAGATION: "form__animation_stop_propagation",
        DATA                           : "form__data",
        IS_VALID                       : "form__is_valid"
    }
};

SHINKEN.OBJECT.FormSet           = function ( name ) {
    this.init( name );
};
SHINKEN.OBJECT.FormSet.prototype = {
    init      : function ( name ) {
        this.initCommon( name );
    },
    initCommon: function ( name ) {
        this.setName( name );
        this.initContents();
        this.initPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
        this.property_set = this.getChildConstructor();
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter               : function ( event_name, param ) {
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon         : function ( event_name, param ) {
        param = param || {};
        switch ( event_name ) {
            case "click_on_button_V3":
                switch ( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case "validated_form":
                    case "cancel_form":
                        param[ SHINKEN.OBJECT.FORMSET.PARAM.FORM_OBJECT ] = this;
                        this.getController__20241003().doActionAfter( event_name, param );
                        return;
                }
                break;
            case "add_message_validation":
                this.updateStatusValidationWithMessage( param[ PROPERTY.COMMON.PARAM.PROPERTY_MESSAGES ] );
                break;
            case "toggl_collapse_folder__is_open":
                this.getContentByUUID( param[ SHINKEN.OBJECT.COLLAPSE.PARAM.NAME ] ).doActionAfter( event_name, param );
                return;
        }
        if ( param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] || param[ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ] ) {
            this.property_set.doActionAfter( event_name, param );
        }
        else {
            for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
                this.contents[ i ].doActionAfter( event_name, param );
            }
            //this.doActionAfterContentChildren( event_name, param );
        }
    },
    doActionAfterContentChildren: function ( event_name, param ) {
        for ( let i = 0, _size_i = this.property_set.getSize(); i < _size_i; i++ ) {
            this.property_set.getContent( i ).doActionAfter( event_name, param );
        }
    },
    hidePopup                   : function ( param ) {
        var _current;
        for ( let i = 0, _size_i = this.property_set.getSize(); i < _size_i; i++ ) {
            _current = this.property_set.getContent( i );
            if ( param && _current.getName() !== param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] ) {
                _current.hidePopup();
            }
            else {
                _current.doActionAfter( "ask_hide_pop_up", param );
            }
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setName                : function ( to_set ) {
        this.name = to_set;
        this.addParamForEvents( SHINKEN.OBJECT.FORMSET.PARAM.FORM_NAME, this.name );
    },
    getChildConstructor    : function () {
        return new SHINKEN.OBJECT.PropertiesSet();
    },
    setController__20241003: function ( to_set ) {
        this.controller = to_set;
    },
    getController__20241003: function () {
        return this.controller;
    },
    addToProperties        : function ( to_add ) {
        this.property_set.add( to_add );
        to_add.addParamsForEvents( this.getParamForEvents() );
    },
    getPropertyByName      : function ( property_name ) {
        return this.property_set.getContentByUUID( property_name );
    },
    addSpecific            : function ( to_add, ignore_property, visibility_state ) {
        if ( !ignore_property ) {
            this.addToProperties( to_add );
        }
        if ( visibility_state ) {
            to_add.setVisibilityState( visibility_state );
        }
        to_add.addParamsForEvents( this.getParamForEvents() );
        return this.add( to_add );
    },
    addSpecificToChild     : function ( to_add, child, ignore_property, visibility_state ) {
        if ( !ignore_property ) {
            this.addToProperties( to_add );
        }
        if ( visibility_state ) {
            to_add.setVisibilityState( visibility_state );
        }
        return child.add( to_add );
    },
    getName                : function () {
        return this.name;
    },
    computeFooterContent   : function () {
        this.footer_content = null;
    },
    getFooterContent       : function () {
        return this.footer_content;
    },
    //********************************************  VALIDATION  *****************************************************//
    updateStatusValidationWithMessage: function ( messages ) {
        let status_message = messages.getStatus();
        switch ( status_message ) {
            case COMPONENT.CONST.STATUS.ERROR:
                this.setStatusValidation( COMPONENT.CONST.STATUS.ERROR );
                break;
            case COMPONENT.CONST.STATUS.WARNING:
                if ( this.status_validation !== COMPONENT.CONST.STATUS.ERROR ) {
                    this.setStatusValidation( COMPONENT.CONST.STATUS.WARNING );
                }
                break;
        }
    },
    setStatusValidation              : function ( to_set ) {
        this.status_validation = to_set;
    },
    isValid                          : function () {
        return this.status_validation !== COMPONENT.CONST.STATUS.ERROR;
    },
    computeValidation__20241125      : function () {
        this.status_validation = COMPONENT.CONST.STATUS.VALID;
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave__20241114: function ( type_save, property_list ) {
        return this.property_set.getDataToSave__20241114( type_save, property_list );
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.FormSet, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.FormSet, SHINKEN.OBJECT.PhaseInterface );

SHINKEN.OBJECT.PropertiesSet           = function () {
    this.initContentsSpecific();
};
SHINKEN.OBJECT.PropertiesSet.prototype = {
    initContentsSpecific: function () {
        this.initContents();
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter      : function ( event_name, param ) {
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon: function ( event_name, param ) {
        var _current_prop;
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current_prop = this.getContent( i );
            if ( _current_prop.getUUID() === param[ PROPERTY.COMMON.PARAM.PROPERTY_NAME ] ) {
                _current_prop.doActionAfter( event_name, param );
            }
            else if ( _current_prop === param[ PROPERTY.COMMON.PARAM.PROPERTY_OBJECT ] ) {
                _current_prop.doActionAfter( event_name, param );
            }
            else {
                _current_prop.hidePopup();
            }
        }
    },
    //********************************************  SAVE   **************************************************//
    getDataToSave__20241114: function ( type_save, property_list ) {
        const _to_return = {};
        let _current;
        for ( let i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            if ( property_list && !SHINKEN.TOOLS.ARRAY.contains( property_list, _current.getUUID() ) ) {
                continue;
            }
            _to_return[ _current.getUUID() ] = _current.getDataToSave__20241127( type_save );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.PropertiesSet, SHINKEN.OBJECT.ShinkenObjectContainer );