//__lib__ lib_common
"use strict";

SHINKEN_LIST.HeaderFromDataWithSort           = function ( name, label ) {
    this.initSpecific( name, label );
};
SHINKEN_LIST.HeaderFromDataWithSort.prototype = {
    initSpecific: function ( name, label ) {
        this.init( name, label );
        this.initSorting();
        this.initSortingAvailability();
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_button":
                switch ( param_1 ) {
                    case "click-on-header-popup":
                    case "click-on-option-header-popup":
                    case "click-on-header":
                        this.sorting_object.doActionAfter( param_1, param_2, param_3 );
                        break;
                }
                break;
        }
        this.doActionAfterCommon( event_name, param_1, param_2, param_3 );
    },
    //********************************************  HTML  *****************************************************//
    addHtmlCounters: function ( dom_element_parent) {
    },
    computeHtml        : function () {
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-list-header", "data-name": this.name, "data-display-sort-popup": true, "data-object-type": this.getObjectType() } ) );
        this.cell_content            = DOM.Service.createElement( "div", { class: "shinken-list-cell-content", onclick: "MANAGER.EventManagerV2.clickButton(event, 'click-on-header', '" + this.name + "',event)" } );
        var _table                   = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-header-table" } );
        var _line                    = DOM.Service.createElement( "tr", {} );
        var _label_cell              = DOM.Service.createElement( "td", { class: "shinken-list-header-name-cell" }, "<div class='shinken-list-header-name'>" + this.label + "</div>" );
        this.dom_sort_priority_cell  = DOM.Service.createElement( "td", { class: "shinken-list-header-sort-priority-cell" } );
        this.dom_actions_button_cell = DOM.Service.createElement( "td", { class: "shinken-list-header-sort-button-cell" } );
        
        DOM.Service.addElementTo( _label_cell, _line );
        
        this.addHtmlCounters(_line);
        DOM.Service.addElementTo( this.dom_sort_priority_cell, _line );
        DOM.Service.addElementTo( this.dom_actions_button_cell, _line );
        DOM.Service.addElementTo( _line, _table );
        DOM.Service.addElementTo( _table, this.cell_content );
        DOM.Service.addElementTo( this.cell_content, this.dom_element );
        
        //TODO IL NE FAUDRAIT PAS UTILISER "sorting_object"
        if ( this.sorting_object.getStatus() !== SHINKEN.OBJECT.SORTING.STATUS.UNAVAILABLE ){
            this.computeHtmlSorting();
            DOM.Service.addElementTo( this.sorting_object.sort_priority_dom_element, this.dom_sort_priority_cell );
            DOM.Service.addElementTo( this.sorting_object.sort_popup_button, this.dom_actions_button_cell );
            DOM.Service.addElementTo( this.sorting_object.popup_sort_container, this.cell_content );
            this.setDomParentForSorting( this.dom_element );
        }
    },
    hidePopup          : function () {
        this.hidePopupSorting();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeaderFromDataWithSort, SHINKEN_LIST.HeaderFromData );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeaderFromDataWithSort, SHINKEN.OBJECT.SortingInterface );