//__lib__ lib_common
"use strict";

SHINKEN_LIST.LineFromData           = function ( data, headers ) {
    this.init( data, headers );
};
SHINKEN_LIST.LineFromData.prototype = {
    init          : function ( data, headers ) {
        this.unused_data = {};
        this.initCommon();
        this.initCellsValue( data, headers );
        this.initLineCountersValue();
    },
    initCellsValue: function ( data, headers ) {
        var _current_name;
        for ( var i = 0, _size_i = headers.contents.length; i < _size_i; i++ ) {
            _current_name = headers.contents[ i ].name;
            this.addSpecific( this.getChildConstructor( _current_name, data[ _current_name ], data ) );
        }
        var _keys = Object.keys( data );
        var _current_key;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            if ( this.getMappingIndex( _current_key ) === undefined ) {
                this.unused_data[ _current_key ] = data[ _current_key ];
            }
        }
        this.doActionAfter( "init_cells_value_done" );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getChildConstructor: function ( name, value ) {
        return new SHINKEN_LIST.LineCellFromData( name, value );
    },
    getData__20241114  : function ( key ) {
        let to_return = this.getContentByUUID( key );
        if ( to_return ) {
            return to_return.getValue();
        }
        return this.unused_data[ key ];
    },
    //********************************************  SAVE  *****************************************************//
    getInitialDataToSave: function () {
        return this.unused_data;
    },
    //********************************************  HTML  *****************************************************//
    getAttributeHtml: function () {
        return {
            class    : "shinken-list-line",
            "onclick": "MANAGER.EventManagerV2.doActionAfter(event,'line_list_content__clicked'," + this.parseParamForEventsToHtml() + ")"
        };
    },
    computeHtml     : function () {
        this.setDomElement( DOM.Service.createElement( "tr", this.getAttributeHtml() ) );
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            this.addDomElement( this.getContent( i ).getDomElement() );
        }
        this.doActionAfter( "compute_html_done" );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineFromData, SHINKEN_LIST.Line );

SHINKEN_LIST.LineForPropertyResearch           = function ( data, headers ) {
    this.init( data, headers );
};
SHINKEN_LIST.LineForPropertyResearch.prototype = {
    init             : SHINKEN_LIST.LineFromData.prototype.init,
    initCounterCommon: function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL );
    },
    initCounter      : SHINKEN.OBJECT.CounterInterfaceV2_patient.prototype.initCounter,
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "clean_selected_element" :
                if ( this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED ) ) {
                    this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED, this.getUUID(), 0 );
                }
                return;
        }
        this.doActionAfterCommon( event_name, param );
    },
    //********************************************  GETTER SETTER **************************************************//
    setIsSelected__20241219: function ( to_set ) {
        if ( to_set ) {
            if ( !this.getCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED ) ) {
                this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED );
                if ( this.getDomElement() ) {
                    this.addCounterTargetDomElement( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED, this.getDomElement() );
                }
            }
        }
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.SELECTED, this.getUUID(), to_set ? 1 : 0 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineForPropertyResearch, SHINKEN_LIST.LineFromData );
