//__lib__ lib_common
"use strict";
SHINKEN_LIST.LinesFromDataWithPagination           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.LinesFromDataWithPagination.prototype = {
    init: SHINKEN_LIST.LinesFromData.prototype.init,
    
    //********************************************  EVENT LISTENER  **************************************************//
    
    //********************************************  COLLAPSE  *****************************************************//
    
    //********************************************  FILTERS  *****************************************************//
    
    //********************************************  SAVE  *****************************************************//
    
    //********************************************  HTML  *****************************************************//
    computeHtml: function ( pagination ) {
        if ( this.getDomElement() ) {
            DOM.Service.empty( this.getDomElement() );
        }
        else {
            this.setDomElement( DOM.Service.createElement( "tbody", { class: "shinken-list-tbody" } ) );
        }
        var _first_element_to_display = pagination.getDisplayStartingIndex();
        var _size_end_display         = Math.min( pagination.getDisplayEndingIndex(), this.getSize() );
        
        var _current;
        var _running_index = 0;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            if ( _current.is_filtered ) {
                continue;
            }
            if ( _running_index >= _first_element_to_display && _running_index < _size_end_display ) {
                _current.computeHtml();
                this.addDomElement( _current.getDomElement() );
            }
            _running_index++;
        }
        this.computeTextNoElements();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesFromDataWithPagination, SHINKEN_LIST.LinesFromData );

SHINKEN_LIST.LinesForPropertyResearch           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.LinesForPropertyResearch.prototype = {
    init               : SHINKEN_LIST.LinesFromDataWithPagination.prototype.init,
    getChildConstructor: function ( data, headers ) {
        return new SHINKEN_LIST.LineForPropertyResearch( data, headers );
    },
    initCounterCommon  : function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "update_counter__with_children":
            case "apply_filter_done":
                let value_to_set = {};
                let current_line;
                var _keys;
                var _current_key;
                for ( let i = 0; i < this.getSize(); i++ ) {
                    current_line = this.getContent( i );
                    _keys = Object.keys( current_line.counters );
                    for( let j = 0, _size = _keys.length ; j < _size; j++ ) {
                        value_to_set[_keys[j]] =  value_to_set[_keys[j]] || 0;
                        value_to_set[_keys[j]] += current_line.counters[_keys[j]].getValue();
                    }
                }
                _keys = Object.keys( value_to_set );
                for( let i = 0, _size = _keys.length ; i < _size; i++ ) {
                    _current_key = _keys[i];
                    this.setCounterValue( _current_key, this.uuid, value_to_set[_current_key] );
                }
                break;
            case "clean_selected_element":
                for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
                    this.contents[ i ].doActionAfter( event_name, param );
                }
                break;
        }
        this.doActionAfterCommon( event_name, param, param_2, param_3 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LinesForPropertyResearch, SHINKEN_LIST.LinesFromDataWithPagination );