//priority 50
//__lib__ lib_common
"use strict";

SHINKEN_LIST.Pagination_V3           = function ( page_size, parent_name ) {
    this.__class_name__ = "SHINKEN_LIST.Pagination_V3";
    this.init( page_size, parent_name );
};
SHINKEN_LIST.Pagination_V3.prototype = {
    init                : function ( page_size, parent_name ) {
        this.page_size          = page_size || 100;
        this.parent_name        = parent_name;
        this.total_page         = 0;
        this.current_page_index = 0;
        this.initSpecificContents();
    },
    initSpecificContents: function () {
        this.initContents();
        this.add( new SHINKEN_LIST.PaginationNavigation_V3( COMPONENT.CONST.PAGINATION_NAVIGATION.FIRST ) );
        this.add( new SHINKEN_LIST.PaginationNavigation_V3( COMPONENT.CONST.PAGINATION_NAVIGATION.PREVIOUS ) );
        this.add( new SHINKEN_LIST.PaginationSelector_V3( this.total_page, this.current_page_index, this.parent_name ) );
        this.add( new SHINKEN_LIST.PaginationNavigation_V3( COMPONENT.CONST.PAGINATION_NAVIGATION.NEXT ) );
        this.add( new SHINKEN_LIST.PaginationNavigation_V3( COMPONENT.CONST.PAGINATION_NAVIGATION.LAST ) );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_button_V3":
                switch ( param[ COMPONENT.BUTTON.PARAM.BUTTON_NAME ] ) {
                    case COMPONENT.CONST.PAGINATION_NAVIGATION.FIRST :
                        this.setActiveIndex( 0 );
                        break;
                    case COMPONENT.CONST.PAGINATION_NAVIGATION.PREVIOUS :
                        this.setActiveIndex( this.current_page_index - 1 );
                        break;
                    case COMPONENT.CONST.PAGINATION_NAVIGATION.NEXT :
                        this.setActiveIndex( this.current_page_index + 1 );
                        break;
                    case COMPONENT.CONST.PAGINATION_NAVIGATION.LAST :
                        this.setActiveIndex( this.total_page - 1 );
                        break;
                }
                break;
            case "click_on_item_selector_done" :
                this.setActiveIndex( parseInt( param.getValue() ), true );
                break;
            case "click_on_selector_V3":
            case "click_on_item_selector_V3":
                this.getSelector().doActionAfter( event_name, param, param_2, param_3 );
                break;
            default:
                console.warn( "[Pagination - doActionAfter]", event_name );
                break;
        }
    },
    onClick      : function ( event ) {
        this.getSelector().onClick();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getSelector            : function () {
        return this.getContentByUUID( "pagination_selector" );
    },
    setActiveIndex         : function ( index, index_already_update ) {
        this.current_page_index = parseInt( index );
        if ( !index_already_update ) {
            this.getSelector().setCurrentPage( this.current_page_index );
        }
        this.computeClass();
    },
    getDisplayStartingIndex: function () {
        return this.current_page_index * this.page_size;
    },
    getDisplayEndingIndex  : function ( to_set ) {
        return this.getDisplayStartingIndex() + this.page_size;
    },
    setTotalElement        : function ( to_set ) {
        this.setActiveIndex( 0 );
        this.total_page = parseInt( Math.ceil( to_set / this.page_size ) );
        this.getSelector().setTotalPage( this.total_page );
        if ( this.getDomElement() ) {
            this.getSelector().computeHtml();
            this.computeClass();
        }
    },
    setPageSize            : function ( to_set ) {
        this.page_size = to_set;
    },
    //********************************************  ACTION  *****************************************************//
    add: function ( to_add ) {
        this.addCommon( to_add );
        to_add.addParamForEvents( SHINKEN_LIST.CONST.PARAM.PAGINATION_PARENT_NAME, this.parent_name );
        return to_add;
    },
    //********************************************  HTML  *****************************************************//
    computeHtml : function () {
        if ( this.getDomElement() ) {
            DOM.Service.empty( this.getDomElement() );
        }
        else {
            this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-pagination-V3 shinken-layout-center-h-v" } ) );
        }
        var _div = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-pagination-container shinken-layout-inline-center-h-v" } ) );
        
        for ( var i = 0; i < this.getSize(); i++ ) {
            this.getContent( i ).computeHtml();
            DOM.Service.addElementTo( this.getContent( i ).getDomElement(), _div );
        }
        this.computeClass();
    },
    computeClass: function () {
        if ( !this.getDomElement() ) {
            return;
        }
        
        this.getDomElement().classList.remove( "shinken-is-first-pagination" );
        this.getDomElement().classList.remove( "shinken-is-last-pagination" );
        if ( this.current_page_index === 0 ) {
            this.getDomElement().classList.add( "shinken-is-first-pagination" );
        }
        if ( this.current_page_index === this.total_page - 1 || this.total_page === 0 ) {
            this.getDomElement().classList.add( "shinken-is-last-pagination" );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Pagination_V3, SHINKEN.OBJECT.ShinkenObjectContainerHtml );