//__lib__ lib_common
//priority 100

"use strict";

SHINKEN_LIST.Line           = function () {
    this.init();
};
SHINKEN_LIST.Line.prototype = {
    init                 : function () {
        this.initCommon();
    },
    initCommon           : function () {
        this.initCounterCommon();
        this.initContents();
        this.initPhase();
    },
    initCounterCommon    : function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL );
    },
    initLineCountersValue: function () {
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.TOTAL, this.getUUID(), 1 );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING, this.getUUID(), 1 );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter                  : function ( event_name, param ) {
        this.doActionAfterCommon( event_name, param );
    },
    doActionAfterCommon            : function ( event_name, param ) {
        switch ( event_name ) {
            case "compute_html_done":
                this.addCountersTargetDomElement( this.getDomElement() );
                break;
            case "click_on_button_V3":
            case "onchange_in_input_V3":
                this.getContentByUUID( param[ SHINKEN_LIST.CONST.PARAM.CELL_UUID ] ).doActionAfter( event_name, param );
                break;
            case "click_on_button":
                switch ( param ) {
                    case "restore-deleting-view":
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.TO_BE_RESTORED );
                        break;
                }
                break;
            case "cancel_user_orders":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                this.doActionAfterContentChildren( event_name, param );
                this.doActionAfterSpecific__20240909( "cancel_user_orders_specific", param );
                break;
        }
    },
    doActionAfterSpecific__20240909: function ( event_name, param ) {
    },
    clickOnInput                   : function ( event ) {
        var _cell = this.getContentByEvent( event );
        if ( _cell ) {
            _cell.clickOnInput();
        }
    },
    askComputeAfterChange          : function ( dom_element, parent ) {
        var _cell = this.getContentByDomElement( dom_element );
        if ( _cell ) {
            _cell.askComputeAfterChange( dom_element, parent );
        }
    },
    clickOnItemSelector            : function ( event ) {
        var _cell = this.getContentByEvent( event );
        if ( _cell ) {
            _cell.clickOnItemSelector( event );
        }
    },
    //********************************************  GETTER BY EVENT  *****************************************************//
    getContentByDomElement: function ( dom_element ) {
        var _parent_dom_element = DOM.Service.findParentElementWithClass( dom_element, 'shinken-list-cell', 20 );
        if ( !_parent_dom_element ) {
            return null;
        }
        return this.getContentByUUID( _parent_dom_element.dataset.uuid );
    },
    getContentByEvent     : function ( event ) {
        return this.getContentByDomElement( event.target );
    },
    //********************************************  FILTERS  *****************************************************//
    applyFilter                       : function ( filters, params_filter_by_line ) {
        var _filter = SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
        if ( params_filter_by_line ) {
            for ( let i = 0, _size_i = params_filter_by_line.length; i < _size_i; i++ ) {
                switch ( params_filter_by_line[ i ] ) {
                    case "filter_by_line_has_problem":
                        if ( !this.hasCounterProblems() ) {
                            this.setFilter( SHINKEN_LIST.CONST.FILTER.STATUS.ON );
                            return;
                        }
                        break;
                    case "filter_by_line_has_error":
                        if ( !this.hasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS ) ) {
                            this.setFilter( SHINKEN_LIST.CONST.FILTER.STATUS.ON );
                            return;
                        }
                        break;
                }
            }
        }
        for ( var i = 0, _size_i = filters.length; i < _size_i; i++ ) {
            var _value_filter = filters[ i ].getValue();
            var _value_cell   = this.getCellValueForApplyFilter( filters[ i ].getName() );
            switch ( _value_cell ) {
                case SHINKEN_LIST.CONST.FILTER.HAS_CHILDREN:
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.HAS_CHILDREN;
                    continue;
            }
            var _type_filter = filters[ i ].type;
            switch ( _type_filter ) {
                case COMPONENT.CONST.TYPE.SINGLE_SELECT:
                    _filter = this.getFilterStatusForSingleSelect( _value_filter, _value_cell, _filter );
                    break;
                case COMPONENT.CONST.TYPE.STRING_INPUT:
                case COMPONENT.CONST.TYPE.STRING_INPUT_WITH_DROPDOWN:
                    _filter = this.getFilterStatusForInputString( _value_filter, _value_cell, _filter );
                    break;
                case COMPONENT.CONST.TYPE.INPUT_STRING_ARRAY:
                    _filter = this.getFilterStatusForInputStringArray( _value_filter, _value_cell, _filter );
                    break;
            }
        }
        this.setFilter( _filter );
    },
    getFilterStatusForSingleSelect    : function ( _value_filter, _value_cell, _filter ) {
        if ( _value_filter === SHINKEN_LIST.CONST.FILTER.ALL ) {
            return _filter;
        }
        else if ( _value_filter === SHINKEN_LIST.CONST.FILTER.NOT_EMPTY ) {
            if ( Array.isArray( _value_cell ) ) {
                if ( SHINKEN.TOOLS.ARRAY.contains( _value_cell, SHINKEN_LIST.CONST.FILTER.EMPTY ) ) {
                    _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
                }
            }
            else if ( _value_cell === SHINKEN_LIST.CONST.FILTER.EMPTY ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
            return _filter;
        }
        if ( Array.isArray( _value_cell ) ) {
            if ( !SHINKEN.TOOLS.ARRAY.contains( _value_cell, _value_filter ) ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( _value_cell !== _value_filter ) {
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
        }
        return _filter;
    },
    getFilterStatusForInputString     : function ( _value_filter, _value_cell, _filter ) {
        if ( SHINKEN.TOOLS.STRING.contains( _value_filter, "&" ) ) {
            var _values_filters = _value_filter.split( "&" );
            var _found          = false;
            for ( var j = 0, _size_j = _values_filters.length; j < _size_j; j++ ) {
                if ( SHINKEN.TOOLS.STRING_FILTER.containsIgnoreCase( _value_cell + "", _values_filters[ j ] ) ) {
                    _found = true;
                }
            }
            if ( !_found ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( _value_filter === '=""' ) {
            if ( _value_cell ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( _value_filter === '!=""' ) {
            if ( !_value_cell ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( SHINKEN.TOOLS.STRING.startsWith( _value_filter, "!" ) ) {
            if ( SHINKEN.TOOLS.STRING_FILTER.containsIgnoreCase( _value_cell + "", _value_filter.substr( 1 ) ) ) {
                _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
            }
        }
        else if ( !SHINKEN.TOOLS.STRING_FILTER.containsIgnoreCase( _value_cell + "", _value_filter ) ) {
            _filter = SHINKEN_LIST.CONST.FILTER.STATUS.ON;
        }
        return _filter;
    },
    getFilterStatusForInputStringArray: function ( _value_filter, _value_cell, _filter ) {
        var _list  = _value_filter.split( "," );
        var _found = false;
        for ( var j = 0, _size_j = _list.length; j < _size_j; j++ ) {
            if ( _list[ j ] === _value_cell ) {
                _found = true;
                break;
            }
        }
        if ( !_found ) {
            return SHINKEN_LIST.CONST.FILTER.STATUS.ON;
        }
        else {
            return _filter;
        }
    },
    setFilter                         : function ( to_set ) {
        this.is_filtered = to_set;
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.FILTERING, this.getUUID(), this.isFiltered() ? 0 : 1 );
        this.doActionAfter( "do_action_after_filter_change", this.is_filtered );
    },
    isFiltered                        : function () {
        return this.is_filtered === SHINKEN_LIST.CONST.FILTER.STATUS.ON;
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getChildConstructor       : function () {
        return new SHINKEN_LIST.LineCell();
    },
    setUUID                   : function ( to_set ) {
        this.uuid = to_set;
        this.addParamForEvents( SHINKEN_LIST.CONST.PARAM.LINE_UUID, this.uuid );
    },
    getUUID                   : function () {
        if ( !this.uuid ) {
            this.setUUID( SHINKEN.TOOLS.STRING.buildUUID() );
        }
        return this.uuid;
    },
    toggleSelect              : function () {
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.OFF );
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.setIsSelected( SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
                break;
        }
    },
    setIsSelected             : function ( to_set ) {
        if ( this.is_filtered ) {
            return;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return;
        }
        this.is_selected = to_set;
        this.updateSelectionCounter();
        switch ( this.is_selected ) {
            case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                this.dom_element.classList.add( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.add( "shinken-selected-parent" );
                }
                break;
            case SHINKEN_LIST.CONST.SELECTION.STATUS.OFF:
                this.dom_element.classList.remove( "shinken-selected" );
                if ( this.parent_select_element ) {
                    this.parent_select_element.classList.remove( "shinken-selected-parent" );
                }
                break;
        }
        if ( this.checkbox ) {
            this.checkbox.setChecked( this.is_selected );
        }
        
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                switch ( this.is_selected ) {
                    case SHINKEN_LIST.CONST.SELECTION.STATUS.ON:
                        this.showCountersForParent();
                        break;
                    default:
                        this.hideCountersForParent();
                        break;
                }
        }
        
    },
    updateSelectionCounter    : function () {
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.is_selected_counter.update( this.uuid, this.isSelected() ? 1 : 0 );
                break;
        }
    },
    setDataSet                : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        if ( if_key ) {
            if ( if_function === "matching_regex" ) {
                if ( !SHINKEN.TOOLS.STRING.isMatchingStarRegexTab( this.getCellValue( if_key ), if_values ) ) {
                    data_value = else_data_value;
                }
            }
            else {
                if ( !SHINKEN.TOOLS.STRING.containsAny( this.getCellValue( if_key ), if_values ) ) {
                    data_value = else_data_value;
                }
            }
        }
        DOM.Service.setDataSet( this.dom_element, datakey, data_value );
    },
    isSelected                : function () {
        return this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON;
    },
    isSelectedOrFiltered      : function () {
        if ( this.is_filtered ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED ) {
            return SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        return this.is_selected;
    },
    isCollapsedOrFiltered     : function () {
        if ( this.is_filtered ) {
            return true;
        }
        return this.is_collapse;
    },
    getData                   : function ( key ) {
        return this.dom_element.dataset[ key ];
    },
    getCellValue              : function ( key ) {
        return this.getContentByUUID( key ).getValue();
    },
    getCellValueForSum        : function ( key ) {
        return this.getContentByUUID( key ).getValueForSum();
    },
    getCellValueForApplyFilter: function ( key ) {
        return this.getContentByUUID( key ).getValueForApplyFilter();
    },
    changeElementValue        : function ( key, to_set ) {
        if ( this.getContentByUUID( key ) !== undefined ) {
            this.dom_element.querySelector( '.shinken-list-cell[data-filter="' + key + '"]' ).innerHTML = to_set;
        }
    },
    simulateToggleSelect      : function () {
        this.dom_element.click();
    },
    isSibling                 : function ( list_line ) {
        return (list_line.parent_uuid === this.parent_uuid && list_line.uuid === this.uuid);
    },
    setIndexOriginal          : function ( to_set ) {
        this.index_origin = to_set;
    },
    getIndexOriginal          : function () {
        return this.index_origin;
    },
    getDomElementBind         : function () {
        return null;
    },
    add                       : function ( to_add ) {
        let to_return = this.addCommon( to_add );
        to_return.addParamsForEvents( this.getParamForEvents() );
        return to_return;
    },
    //********************************************  DATAS  *****************************************************//
    updateCellsValue: function ( data ) {
        var _keys = Object.keys( data );
        var current_cell;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            current_cell = this.getContentByUUID( _keys[ i ] );
            if ( current_cell ) {
                current_cell.setValue( data[ _keys[ i ] ] );
            }
        }
    },
    //********************************************  COLLAPSE  *****************************************************//
    toggleCollapse        : function ( children ) {
        this.setIsCollapsed( !this.is_collapse );
        for ( var i = 0, _size_i = children.length; i < _size_i; i++ ) {
            children[ i ].setIsCollapsed( this.is_collapse );
        }
    },
    setIsCollapsed        : function ( to_set, children ) {
        this.is_collapse = to_set;
        if ( this.is_collapse ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
        if ( children ) {
            for ( var i = 0, _size_i = children.length; i < _size_i; i++ ) {
                children[ i ].setIsCollapsed( this.is_collapse );
            }
        }
    },
    simulateToggleCollapse: function () {
        DOM.Service.SimulateAction.click( this.dom_element.querySelector( ".shinken-collapse-listener" ) );
    },
    //********************************************  SAVE  *****************************************************//
    cleanCellsWithProblem       : function () {
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].cleanCellIfHasProblem( this );
        }
    },
    getInitialDataToSave        : function () {
        return {};
    },
    getDataToSave               : function () {
        var to_return = this.getInitialDataToSave();
        for ( let i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            to_return[ this.contents[ i ].getUUID() ] = this.contents[ i ].getDataToSave();
        }
        return to_return;
    },
    getDataToExport             : function ( headers ) {
        var _to_return = [];
        var _current;
        for ( var i = 0, _size_i = headers.contents.length; i < _size_i; i++ ) {
            _to_return.push( this.getContentByUUID( headers.contents[ i ].getUUID() ).getDataToExport() );
        }
        return _to_return;
    },
    updateAfterActionDoneOK     : function ( action ) {
        this.setMessages();
        var _current = this.getContentByUUID( this.parseToFindCellUuid( action.key ) );
        _current.updateAfterActionDoneOK( action );
        this.addMessages( _current.getMessages() );
        this.extraActionAfterActionDoneOK( action );
    },
    extraActionAfterActionDoneOK: function ( action ) {
    },
    updateAfterActionDoneNOK    : function ( action ) {
        this.setMessages();
        var _current = this.getContentByUUID( this.parseToFindCellUuid( action.key ) );
        _current.updateAfterActionDoneNOK( action );
        this.addMessages( _current.getMessages() );
    },
    parseToFindCellUuid         : function ( key ) {
        return key;
    },
    //********************************************  OTHERS *****************************************************//
    applySiblingSettings: function ( list_line ) {
        if ( this.isSelected() !== list_line.isSelected() ) {
            this.simulateToggleSelect();
        }
        if ( this.is_collapse !== list_line.is_collapse ) {
            this.simulateToggleCollapse();
        }
        DOM.Service.applySiblingSettings( this.dom_element, list_line.dom_element );
    },
    remove              : function () {
        this.removeDomElement();
        this.resetContentsCounters();
        this.resetCounters();
    },
    removeDomElement    : function () {
        if ( this.dom_element ) {
            DOM.Service.removeElement( this.dom_element );
        }
    },
    getObjectsType      : function () {
        return "shinken-list-cell";
    },
    askHidePopup        : SHINKEN.OBJECT.ShinkenObjectContainerHtml.prototype.askHidePopup,
    addParamForEvents   : SHINKEN.OBJECT.ShinkenObjectContainerHtml.prototype.addParamForEvents
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Line, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Line, SHINKEN.OBJECT.CounterInterfaceWithShinkenObjectContainer );
