//priority 10
//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.COUNTER_V2_CONST = {
    TYPE: {
        ERRORS      : "errors",
        WARNINGS    : "warnings",
        PROBLEMS    : "problems",
        TOTAL       : "total",
        FILTERING   : "filtering",
        USER        : "user",
        OVERLAPPING : "overlapping",
        SELECTED    : "selected",
        DELETED     : "deleted",
        WIDGET_TOTAL: "widget_total"
    }
};

SHINKEN.OBJECT.CounterV2           = function ( type ) {
    this.__class_name__ = 'SHINKEN.OBJECT.CounterV2';
    this.init( type );
};
SHINKEN.OBJECT.CounterV2.prototype = {
    init: function ( type ) {
        this._counter_final       = 0;
        this.label                = "";
        this._is_label_before     = false;
        this._show_if_null        = false;
        this._is_string           = false;
        this.type                 = type;
        this._show_to_parent      = true;
        this._data_target_name    = "number";
        this._counter_parent_list = [];
        this._elements_mapping    = {};
        this.uuid                 = SHINKEN.TOOLS.STRING.buildUUID();
        this._targets_dom_element = [];
        this._has_animation       = false;
        this.class                = "shinken-counter shinken-" + this.type + "-counter";
    },
    //********************************************  SETTER GETTER   **************************************************//
    getValue                  : function () {
        return this._counter_final;
    },
    getType                   : function () {
        return this.type;
    },
    hasCounter                : function () {
        return !!this._counter_final;
    },
    setShowIfNull             : function ( to_set ) {
        this._show_if_null = !!to_set;
    },
    setAnimation              : function ( to_set ) {
        this._has_animation = !!to_set;
    },
    reset                     : function () {
        this._elements_mapping = {};
        this._counter_final    = 0;
        this.showForParent( true );
        this.updateTargetsDomElement();
        this._updateHTML();
    },
    showForParent             : function ( show ) {
        this._show_to_parent = !!show;
        this.updateParents();
    },
    updateParents             : function () {
        if ( this.is_patient ) {
            return;
        }
        for ( let i = 0, _size_i = this._counter_parent_list.length; i < _size_i; i++ ) {
            this._counter_parent_list[ i ].update( this.uuid, this._show_to_parent ? this._counter_final : 0 );
        }
    },
    update                    : function ( name, nb_counter, tooltip, retry_update_html, is_force ) {
        if ( !nb_counter ) {
            delete this._elements_mapping[ name ];
        }
        else {
            if ( !is_force && this._elements_mapping[ name ] === nb_counter ) {
                return;
            }
            this._elements_mapping[ name ] = nb_counter;
            
        }
        if ( tooltip ) {
            this.setTooltipHtml( tooltip );
        }
        
        this._counter_final = this._is_string ? "" : 0;
        this.finalUpdate( retry_update_html );
    },
    askFinalUpdate            : function ( retry_update_html ) {
        if ( this.timeout_final_update ) {
            clearTimeout( this.timeout_final_update );
        }
        this.timeout_final_update = setTimeout( () => {
            this.finalUpdate( retry_update_html );
            this.timeout_final_update = null;
        }, 10 );
    },
    finalUpdate               : function ( retry_update_html ) {
        let _keys = Object.keys( this._elements_mapping );
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            this._counter_final = this._counter_final + this._elements_mapping[ _keys[ i ] ];
        }
        this.updateTargetsDomElement();
        this.updateParents();
        return this._askUpdateHTML( retry_update_html );
    },
    setParent                 : function ( to_add ) {
        if ( !to_add ) {
            return;
        }
        SHINKEN.TOOLS.ARRAY.addElement( this._counter_parent_list, to_add );
        this.updateParents();
    },
    setDataTargetName         : function ( to_set ) {
        this._data_target_name = to_set;
    },
    doActionAfterSetDomElement: function () {
        if ( !this.dom_element_label ) {
            this.dom_element_label = this.getDomElement().querySelector( ".shinken-counter-label" );
        }
    },
    setDomElementLabel        : function ( to_set ) {
        this.dom_element_label = to_set;
        this._updateHTML();
    },
    addTargetsDomElement      : function ( to_set, data_target_name ) {
        if ( data_target_name ) {
            this.setDataTargetName( data_target_name );
        }
        SHINKEN.TOOLS.ARRAY.addElement( this._targets_dom_element, to_set );
        this.updateTargetsDomElement();
    },
    updateTargetsDomElement   : function () {
        for ( let i = 0, _size_i = this._targets_dom_element.length; i < _size_i; i++ ) {
            DOM.Service.setDataSet( this._targets_dom_element[ i ], this._data_target_name, this._counter_final || '' );
        }
    },
    setLabel                  : function ( to_set, is_before ) {
        this.label            = DOM.Service.createElement( 'span', { class: 'shinken-counter-extra-label' }, to_set ).outerHTML;
        this._is_label_before = !!is_before;
    },
    isString                  : function ( to_set ) {
        this._is_string = to_set;
    },
    _askUpdateHTML            : function ( retry_update_html ) {
        if ( this.timeout_html ) {
            clearTimeout( this.timeout_html );
        }
        this.timeout_html = setTimeout( () => {
            this._updateHTML( retry_update_html );
            this.timeout_html = null;
        }, 50 );
    },
    _updateHTML               : function ( retry_update_html ) {
        if ( !this.dom_element_label && !this.dom_element ) {
            return;
        }
        let _html       = "";
        let _data_value = "";
        if ( this._counter_final ) {
            _html       = (this.label ? this._is_label_before ? this.label + this._counter_final : this._counter_final + this.label : this._counter_final);
            _data_value = this._counter_final;
        }
        else if ( this._show_if_null ) {
            _html       = "0";
            _data_value = "0";
        }
        if ( this.dom_element_label ) {
            this.dom_element_label.innerHTML = _html;
        }
        if ( this.dom_element ) {
            DOM.Service.setDataSet( this.dom_element, 'number', _data_value );
        }
        if ( this._has_animation ) {
            var _parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-pulsate-parent', 10 );
            if ( _parent_dom_element ) {
                DOM.Service.askAddClass( _parent_dom_element, 'shinken-pulsate', 1600 );
            }
        }
    },
    //********************************************  OTHERS   **************************************************//
    getObjectParentWithClassNameV2: function ( class_name ) {
        if ( !this.object_parent_v2 ) {
            return null;
        }
        if ( this.object_parent_v2.getObjectClassName() === class_name ) {
            return this.object_parent_v2;
        }
        if ( !this._counter_parent_list.length ) {
            return null;
        }
        var _current;
        for ( var i = 0, _size_i = this._counter_parent_list.length; i < _size_i; i++ ) {
            _current = this._counter_parent_list[ i ].getObjectParentWithClassNameV2( class_name );
            if ( _current ) {
                return _current;
            }
        }
        return null;
    },
    //********************************************  HTML   **************************************************//
    computeHtml: function () {
        let _value = this._counter_final;
        if ( !_value ) {
            if ( this._show_if_null ) {
                _value = 0;
            }
            else {
                _value = "";
            }
        }
        
        this.setDomElement( DOM.Service.createElement( "span", {
            class        : this.getClass(),
            "data-number": _value
        } ) );
        this.dom_element_label = DOM.Service.createElement( "span", { class: "shinken-counter-label" }, _value );
        DOM.Service.addElementTo( this.dom_element_label, this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterV2, SHINKEN.OBJECT.ShinkenObjectHtml );



SHINKEN.OBJECT.CounterInterfaceV2           = function () {
};
SHINKEN.OBJECT.CounterInterfaceV2.prototype = {
    initCounterCommon           : function () {
        this.counters = {};
    },
    initCounter                 : function ( type, name_for_distributor ) {
        if ( this.counters[ type ] ) {
            console.shinken.debug( "[CounterInterfaceV2 - initCounter]", "Already Exists", type, this );
        }
        this.counters[ type ] = new SHINKEN.OBJECT.CounterV2( type );
        if ( name_for_distributor ) {
            MANAGER.__instance_counter_distributorV2.setCounter( name_for_distributor, this.counters[ type ] );
        }
    },
    resetCounters               : function () {
        if ( !this.counters ) {
            return;
        }
        let _keys = Object.keys( this.counters );
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            this.counters[ _keys[ i ] ].reset();
        }
    },
    resetCounterByType          : function ( counter_type ) {
        if ( this.counters[ counter_type ] ) {
            this.counters[ counter_type ].reset();
        }
    },
    resetCountersByType         : function ( array_type ) {
        for ( let i = 0, _size_i = array_type.length; i < _size_i; i++ ) {
            this.resetCounterByType( array_type[ i ] );
        }
    },
    countersShowForParent       : function ( to_set ) {
        let _keys = Object.keys( this.counters );
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            this.counters[ _keys[ i ] ].showForParent( to_set );
        }
    },
    addCountersTargetDomElement : function ( dom_element ) {
        let _keys = Object.keys( this.counters );
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            this.addCounterTargetDomElement( _keys[ i ], dom_element );
        }
    },
    addCounterTargetDomElement  : function ( type, dom_element, data_target_name ) {
        this.counters[ type ].addTargetsDomElement( dom_element, data_target_name || type );
    },
    hasCounter                  : function ( type ) {
        if ( !this.counters[ type ] ) {
            return false;
        }
        return this.counters[ type ].hasCounter();
    },
    hasCounterProblems          : function () {
        return !!(this.hasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS ) || this.hasCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS ));
    },
    setCounterValue             : function ( type, data_name, nb ) {
        if ( !this.counters || !this.counters[ type ] ) {
            this.initCounter( type );
        }
        this.counters[ type ].update( data_name, nb );
    },
    getCounter                  : function ( type ) {
        return this.counters[ type ];
    },
    getCounterValue             : function ( type ) {
        return this.counters[ type ].getValue();
    },
    setCountersParent           : function ( parent ) {
        let _keys = Object.keys( this.counters );
        let _current_key;
        for ( let i = 0, _size = _keys.length; i < _size; i++ ) {
            this.setCounterParent( parent, _keys[ i ] );
        }
    },
    setCounterParent            : function ( parent, type ) {
        this.counters[ type ].setParent( parent.getCounter( type ) );
    },
    addCounterComputeHtmlIfExist: function ( type, dom_element_parent ) {
        if ( !this.counters[ type ] ) {
            return;
        }
        this.counters[ type ].computeHtml();
        DOM.Service.addElementTo( this.counters[ type ].getDomElement(), dom_element_parent );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterfaceV2, SHINKEN.OBJECT.ShinkenObjectHtml );

SHINKEN.OBJECT.CounterInterfaceV2LinkWithParentAndDomElement           = function () {
};
SHINKEN.OBJECT.CounterInterfaceV2LinkWithParentAndDomElement.prototype = {
    setCounterValue: function ( type, data_name, nb, parent ) {
        if ( !this.counters || !this.counters[ type ] ) {
            this.initCounter( type );
            this.counters[ type ].addTargetsDomElement( this.getDomElement(), type );
            this.setCounterParent( parent, type );
        }
        this.counters[ type ].update( data_name, nb );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterfaceV2LinkWithParentAndDomElement, SHINKEN.OBJECT.CounterInterfaceV2 );

SHINKEN.OBJECT.CounterInterfaceWithShinkenObjectContainer           = function () {
};
SHINKEN.OBJECT.CounterInterfaceWithShinkenObjectContainer.prototype = {
    resetChildCountersByType: function ( array_type ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].resetCountersByType( array_type );
        }
    },
    addSpecific             : function ( to_add ) {
        this.add( to_add );
        to_add.setCountersParent( this );
        return to_add;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterfaceWithShinkenObjectContainer, SHINKEN.OBJECT.CounterInterfaceV2 );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterfaceWithShinkenObjectContainer, SHINKEN.OBJECT.ShinkenObjectContainerHtml );

SHINKEN.OBJECT.CounterInterfaceValidation           = function () {
};
SHINKEN.OBJECT.CounterInterfaceValidation.prototype = {
    initCounterCommon       : function () {
        this.counters = {};
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS );
        this.initCounter( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS );
    },
    doActionAfterAddMessages: function () {
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.WARNINGS, this.getObjectClassName(), this.messages.getNumberWarnings() );
        this.setCounterValue( SHINKEN.OBJECT.COUNTER_V2_CONST.TYPE.ERRORS, this.getObjectClassName(), this.messages.getNumberErrors() );
    },
    initCounter             : function ( type, name_for_distributor ) {
        if ( this.counters[ type ] ) {
            console.shinken.debug( "[CounterInterfaceV2 - initCounter]", "Already Exists", type, this );
        }
        this.counters[ type ]                  = new SHINKEN.OBJECT.CounterV2( type );
        this.counters[ type ].object_parent_v2 = this;
        if ( name_for_distributor ) {
            MANAGER.__instance_counter_distributorV2.setCounter( name_for_distributor, this.counters[ type ] );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterfaceValidation, SHINKEN.OBJECT.CounterInterfaceV2 );

SHINKEN.OBJECT.CounterInterfaceV2_patient           = function () {
};
SHINKEN.OBJECT.CounterInterfaceV2_patient.prototype = {
    initCounter: function ( type ) {
        if ( this.counters[ type ] ) {
            console.shinken.debug( "[CounterInterfaceV2 - initCounter]", "Already Exists", type, this );
        }
        this.counters[ type ]            = new SHINKEN.OBJECT.CounterV2( type );
        this.counters[ type ].is_patient = true;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterfaceV2, SHINKEN.OBJECT.ShinkenObjectHtml );