//priority 19
//__lib__ lib_common
"use strict";


SHINKEN.OBJECT.DoActionsAfter = function () {
    this.init();
};

SHINKEN.OBJECT.DoActionsAfter.prototype = {
    init         : function () {
        this.initContents();
    },
    doActionAfter: function ( to_test ) {
        var _current;
        for ( let i = this.getSize() - 1; i >= 0; i-- ) {
            _current = this.getContent( i );
            if ( _current.doActionAfter( to_test ) ) {
                this.removeContentByIndex( i );
            }
        }
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DoActionsAfter, SHINKEN.OBJECT.ShinkenObjectContainer );

SHINKEN.OBJECT.DoActionAfter = function ( parent_object, to_test, event_name, param_1, param_2, param_3 ) {
    this.init( parent_object, to_test, event_name, param_1, param_2, param_3 );
};

SHINKEN.OBJECT.DoActionAfter.prototype = {
    init         : function ( parent_object, to_test, event_name, param_1, param_2, param_3 ) {
        this.uuid          = SHINKEN.TOOLS.STRING.buildUUID();
        this.parent_object = parent_object;
        this.to_test       = to_test;
        this.event_name    = event_name;
        this.param_1       = param_1;
        this.param_2       = param_2;
        this.param_3       = param_3;
    },
    doActionAfter: function ( to_test ) {
        if ( this.to_test !== to_test ) {
            return false;
        }
        this.parent_object.doActionAfter( this.event_name, this.param_1, this.param_2, this.param_3 );
        return true;
    },
    getUUID      : function ( to_test ) {
        return this.uuid;
    },
    remove      : function () {
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.DoActionAfter, SHINKEN.OBJECT.ShinkenObject );