//__lib__ lib_common
"use strict";

OBJECT.ElementCheckbox           = function ( dom_element, parent ) {
    this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
    this.init( dom_element, parent );
};
OBJECT.ElementCheckbox.prototype = {
    init           : function ( dom_element, parent ) {
        this.initCounters( parent );
        this.dom_element = dom_element;
        if ( this.dom_element ) {
            this.is_checked = dom_element.classList.contains( 'shinken-checked' );
        }
        this.computeCounters();
    },
    //********************************************  GETTER AND SETTER  *************************************//
    setChecked     : function ( to_set ) {
        if ( to_set === '0' ) {
            to_set = false;
        }
        this.is_checked = !!to_set;
        this.updateView();
    },
    getValue       : function () {
        return this.is_checked ? '1' : '0';
    },
    //********************************************  COMPUTE  ***********************************************//
    isChecked      : function () {
        return this.is_checked;
    },
    computeCounters: function () {
        if ( !this.dom_element ) {
            return ;
        }
        var _number_error   = this.dom_element.classList.contains( "shinken-error" ) ? 0 : 0;
        var _number_warning = this.dom_element.classList.contains( "shinken-warning" ) ? 0 : 0;
        this.getCounterError().update( this.uuid, _number_error );
        this.getCounterWarning().update( this.uuid, _number_warning );
    },
    //********************************************  HTML  **************************************************//
    updateView     : function () {
        if ( this.is_checked ) {
            this.dom_element.classList.add( 'shinken-checked' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-checked' );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( OBJECT.ElementCheckbox, SHINKEN.OBJECT.CounterInterface );