//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.VisualNotificationOfChange = function ( data ) {
    this.init( data );
};

SHINKEN.OBJECT.VisualNotificationOfChange.prototype = {
    init: function ( data ) {
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK ] = new SHINKEN.OBJECT.BlinkNotificationOfChange();
        if ( data ) {
            this.updateData( data );
        }
    },
    //**************************************    EVENT LISTENER     **************************************************//
    doActionAfter: function ( event_name, param ) {
        this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK ].doActionAfter( event_name, param );
    },
    //**************************************    DATAS         **************************************************//
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case "value":
                var _keys = Object.keys( value );
                var _current_key;
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    this.setData( _keys[ i ], value[ _keys[ i ] ] );
                }
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK:
                this[ key ].updateData( value );
                break;
        }
    },
    //**************************************    GETTER SETTER         **************************************************//
    getBlinkValue: function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK ].getValue();
    },
    //**************************************    SAVE         **************************************************//
    getDataToSave             : function () {
        var _to_return                                                        = {};
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK ] = this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK ].getDataToSave();
        return _to_return;
    },
    isBlinkNotificationEnabled: function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.BLINK ].isEnabled();
    }
};